/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.visualizers;

import com.jaxfront.core.type.SimpleType;
import com.jaxfront.core.type.Type;
import com.jaxfront.swing.ui.tools.Dialog;
import com.jaxfront.swing.ui.visualizers.AbstractSimpleTypeView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class SimpleChooserBean
extends AbstractSimpleTypeView {
    private JPanel _chooserPanel;
    private JTextField _textField;
    private JButton _showChooserButton;
    private JButton _selectButton;
    private JButton _cancelButton;
    private JTextArea _chooser;

    public SimpleChooserBean() {
    }

    public SimpleChooserBean(Type type) {
        this.setModel(type);
    }

    public SimpleChooserBean(Type type, Type context) {
        super(context);
        this.setModel(type);
    }

    protected JComponent createEditorComponent() {
        this._editorComponent = new JPanel(new BorderLayout());
        this._textField = new JTextField(this.getModelValue());
        this._textField.setColumns(1);
        this._textField.addActionListener(new ButtonListener());
        this._textField.addFocusListener(this);
        this.setEditorField(this._textField);
        this.setFirstFocusableComponent(this._textField);
        this._showChooserButton = new JButton("...");
        this._showChooserButton.addActionListener(new ButtonListener());
        this._showChooserButton.addFocusListener(this);
        this._editorComponent.add((Component)this._textField, "Center");
        this._editorComponent.add((Component)this._showChooserButton, "East");
        return this._editorComponent;
    }

    public String getText() {
        return this._textField.getText();
    }

    public void focusLost(FocusEvent e) {
        if (e.getSource() == this._textField && !e.isTemporary()) {
            this.populateModel();
        }
    }

    private String getModelValue() {
        if (this.getModel() != null) {
            return ((SimpleType)this.getModel()).getValue();
        }
        return "";
    }

    public void populateView() {
        String modelValue = ((SimpleType)this.getModel()).getValue();
        String defaultValue = ((SimpleType)this.getModel()).getDefaultValue();
        String xuiDefaultValue = this.getStyle().getLeafDefaultValue();
        if (modelValue == null || modelValue.length() == 0) {
            if (xuiDefaultValue != null && xuiDefaultValue.length() > 0) {
                modelValue = xuiDefaultValue;
            } else if (defaultValue != null && defaultValue.length() > 0) {
                modelValue = defaultValue;
            }
        }
        this._textField.setText(modelValue);
    }

    public void release() {
        super.release();
        if (this._textField != null) {
            this._textField.removeFocusListener(this);
        }
        if (this._showChooserButton != null) {
            this._showChooserButton.removeFocusListener(this);
        }
        this._chooserPanel = null;
        this._textField = null;
        this._showChooserButton = null;
        this._selectButton = null;
        this._cancelButton = null;
        this._chooser = null;
    }

    public JTextArea getChooser() {
        if (this._chooser == null) {
            this._chooser = new JTextArea();
        }
        return this._chooser;
    }

    public class ButtonListener
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == SimpleChooserBean.this._showChooserButton) {
                if (SimpleChooserBean.this._chooserPanel == null) {
                    SimpleChooserBean.this._chooserPanel = new JPanel(new BorderLayout());
                    SimpleChooserBean.this._chooserPanel.add(SimpleChooserBean.this.getChooser());
                }
                int ok = Dialog.showComponentDialog(SimpleChooserBean.this._chooserPanel, "select");
                switch (ok) {
                    case 0: {
                        SimpleChooserBean.this._textField.setText(SimpleChooserBean.this.getChooser().getText());
                        SimpleChooserBean.this.populateModel();
                        break;
                    }
                }
            }
            if (e.getSource() == SimpleChooserBean.this._selectButton) {
                String currentValue = SimpleChooserBean.this._chooser.getText();
                SimpleChooserBean.this._textField.setText(currentValue);
                SimpleChooserBean.this._textField.requestFocus();
                SimpleChooserBean.this._chooserPanel.setVisible(false);
            }
            if (e.getSource() == SimpleChooserBean.this._cancelButton) {
                SimpleChooserBean.this._chooserPanel.setVisible(false);
            }
            if (e.getSource() == SimpleChooserBean.this._textField) {
                // empty if block
            }
        }
    }
}

