/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.visualizers;

import com.jaxfront.core.type.Type;
import com.jaxfront.core.ui.Visualizer;
import com.jaxfront.swing.ui.visualizers.AbstractView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class TransparentVisualizer
extends AbstractView
implements Visualizer {
    private Visualizer _visualizer;
    private ImageIcon _icon;

    public TransparentVisualizer(Visualizer visualizer, ImageIcon icon) {
        this._visualizer = visualizer;
        this._icon = icon;
        this.setLayout(new BorderLayout());
        if (visualizer instanceof JComponent) {
            this.add((Component)((JComponent)this._visualizer), "Center");
            this.initialize();
        }
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this._icon != null) {
            this._icon.paintIcon((Component)this._visualizer, g, 0, 0);
        }
    }

    private void initialize() {
        this.initialize((JComponent)this._visualizer);
    }

    private void initialize(JComponent component) {
        component.setOpaque(false);
        Component[] subComponents = component.getComponents();
        for (int i = 0; i < subComponents.length; ++i) {
            Component subComponent = subComponents[i];
            if (!(subComponent instanceof JComponent)) continue;
            this.initialize((JComponent)subComponent);
        }
    }

    public String getLabelText() {
        return this._visualizer.getLabelText();
    }

    public Type getModel() {
        return this._visualizer.getModel();
    }

    public void markError() {
        this._visualizer.markError();
    }

    public void populateModel() {
        this._visualizer.populateModel();
    }

    public void populateView() {
        this._visualizer.populateView();
    }

    public void release() {
        this._visualizer.release();
    }

    public void removeLabel() {
        this._visualizer.removeLabel();
    }

    public void resetError() {
        this._visualizer.resetError();
    }

    public void setApplicationRequired(boolean required) {
        this._visualizer.setApplicationRequired(required);
    }

    public void setEditable(boolean enabled) {
        this._visualizer.setEditable(enabled);
    }

    public void setLabelColor(Color color) {
        this._visualizer.setLabelColor(color);
    }

    public void setModel(Type type) {
        this._visualizer.setModel(type);
    }

    public void setRequired(boolean required) {
        this._visualizer.setRequired(required);
    }

    public void showLabel(boolean show) {
        this._visualizer.showLabel(show);
    }

    protected JComponent createEditorComponent() {
        return null;
    }

    protected void defaultBuild() {
    }

    public void setChoosenKeyContextValue(String xpathRelativeToChoosenKeyContext, String newValue) {
    }

    public void setChoosenKeyValue(String xpathRelativeToChoosenKey, String newValue) {
    }
}

