/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.visualizers;

import com.jaxfront.core.type.Type;
import com.jaxfront.core.ui.Visualizer;
import com.jaxfront.swing.ui.visualizers.TabChangeListener;
import com.jaxfront.swing.ui.visualizers.TabChangedEvent;
import com.jaxfront.swing.ui.visualizers.TabChangedEventMulticaster;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class UIController
implements FocusListener,
ChangeListener {
    public static UIController _singleton;
    private TabChangeListener _tabChangeListener;

    private UIController() {
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        if (e.getSource() instanceof Visualizer) {
            ((Visualizer)e.getSource()).populateModel();
        }
    }

    public static UIController getInstance() {
        if (_singleton == null) {
            _singleton = new UIController();
        }
        return _singleton;
    }

    public void stateChanged(ChangeEvent e) {
        JTabbedPane pane = (JTabbedPane)e.getSource();
        Component component = pane.getSelectedComponent();
        if (component instanceof Visualizer) {
            Type model = ((Visualizer)component).getModel();
            this.fireTabChanged(new TabChangedEvent(model));
        }
    }

    public void addTabChangeListener(TabChangeListener newListener) {
        this._tabChangeListener = TabChangedEventMulticaster.add(this._tabChangeListener, newListener);
    }

    public void removeTabChangeListener(TabChangeListener newListener) {
        this._tabChangeListener = TabChangedEventMulticaster.remove(this._tabChangeListener, newListener);
    }

    private void fireTabChanged(TabChangedEvent event) {
        if (this._tabChangeListener == null) {
            return;
        }
        this._tabChangeListener.tabChanged(event);
    }
}

