/*
 * Decompiled with CFR 0.152.
 */
package groove.abstraction.neigh.gui.dialog;

import groove.abstraction.neigh.NeighAbstraction;
import groove.abstraction.neigh.gui.jgraph.ShapeJGraph;
import groove.abstraction.neigh.gui.jgraph.ShapeJModel;
import groove.abstraction.neigh.shape.Shape;
import groove.grammar.host.DefaultHostGraph;
import groove.grammar.host.HostGraph;
import groove.graph.Graph;
import groove.gui.Simulator;
import groove.gui.dialog.GraphPreviewDialog;
import groove.util.Groove;
import java.io.File;
import java.io.IOException;
import org.jgraph.graph.GraphModel;

public final class ShapePreviewDialog
extends GraphPreviewDialog<Shape> {
    private ShapePreviewDialog(Simulator simulator, Shape shape) {
        super(simulator, shape);
        this.setTitle(shape.getName());
    }

    public static void showShape(Shape shape) {
        ShapePreviewDialog.showShape(null, shape);
    }

    public static void showShape(Simulator simulator, Shape shape) {
        new ShapePreviewDialog(simulator, shape).setVisible(true);
    }

    protected ShapeJGraph createJGraph() {
        ShapeJGraph jGraph = new ShapeJGraph(this.simulator);
        ShapeJModel model = (ShapeJModel)jGraph.newModel();
        model.loadGraph((Shape)this.graph);
        model.setLayoutable(true);
        jGraph.setModel((GraphModel)model);
        return jGraph;
    }

    private static Shape createShape(File file) {
        HostGraph graph = ShapePreviewDialog.createHostGraph(file);
        return Shape.createShape(graph);
    }

    private static HostGraph createHostGraph(File file) {
        DefaultHostGraph result = null;
        try {
            result = new DefaultHostGraph((Graph)Groove.loadGraph(file));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static void main(String[] args) {
        NeighAbstraction.initialise();
        String DIRECTORY = "junit/abstraction/basic-tests.gps/";
        File file = new File(String.valueOf(DIRECTORY) + "shape-build-test-0.gst");
        Shape shape = ShapePreviewDialog.createShape(file);
        ShapePreviewDialog.showShape(shape);
    }
}

