/*
 * Decompiled with CFR 0.152.
 */
package groove.abstraction.neigh.gui.jgraph;

import groove.abstraction.neigh.gui.jgraph.ShapeJEdge;
import groove.abstraction.neigh.gui.jgraph.ShapeJPort;
import groove.abstraction.neigh.gui.jgraph.ShapeJVertex;
import groove.gui.jgraph.JEdgeView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import org.jgraph.JGraph;
import org.jgraph.graph.CellView;
import org.jgraph.graph.CellViewRenderer;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.PortRenderer;
import org.jgraph.graph.PortView;

public class ShapeJPortView
extends PortView {
    private static final float WIDTH = 8.0f;
    private static final float HEIGHT = 8.0f;
    private static EdgeSigPortRenderer renderer = new EdgeSigPortRenderer();
    private Shape geometricShape;

    public ShapeJPortView(Object cell) {
        super(cell);
        this.getGeometricShape();
    }

    private Shape getGeometricShape() {
        if (this.geometricShape == null) {
            this.geometricShape = new Ellipse2D.Float(0.0f, 0.0f, 8.0f, 8.0f);
        }
        return this.geometricShape;
    }

    public ShapeJPort getCell() {
        return (ShapeJPort)((Object)super.getCell());
    }

    public String toString() {
        return "ShapeJPortView for " + this.getCell().toString();
    }

    public Rectangle2D getBounds() {
        if (this.geometricShape != null) {
            Point2D pt = (Point2D)this.getLocation().clone();
            Rectangle2D.Double bounds = new Rectangle2D.Double();
            bounds.setFrame(pt.getX() - 4.0, pt.getY() - 4.0, 8.0, 8.0);
            return bounds;
        }
        return super.getBounds();
    }

    public CellViewRenderer getRenderer() {
        return renderer;
    }

    public Point2D getLocation(EdgeView edge, Point2D nearest) {
        CellView vertex = this.getParentView();
        Rectangle2D r = vertex.getBounds();
        Point2D pos = this.getPortPosition(r);
        if (edge != null) {
            assert (edge instanceof JEdgeView);
            JEdgeView edgeView = (JEdgeView)edge;
            if (nearest != null && this.shouldMovePort(edgeView, vertex)) {
                pos = vertex.getPerimeterPoint(edge, null, nearest);
                Point2D newOffset = this.computeNewOffset(r, pos);
                GraphConstants.setOffset((Map)this.allAttributes, (Point2D)newOffset);
            }
        }
        return pos;
    }

    private boolean shouldMovePort(JEdgeView edgeView, CellView vertex) {
        boolean isTgtVertex;
        boolean result = false;
        ShapeJEdge jEdge = (ShapeJEdge)edgeView.getCell();
        if (((Object)((Object)this.getCell())).equals(jEdge.getSource())) {
            boolean isSrcVertex = ((ShapeJVertex)jEdge.getSourceVertex()).equals(vertex.getCell());
            if (isSrcVertex && (jEdge.isMainSrc() || this.getCell().isAlwaysMovable())) {
                result = true;
            }
        } else if (((Object)((Object)this.getCell())).equals(jEdge.getTarget()) && (isTgtVertex = ((ShapeJVertex)jEdge.getTargetVertex()).equals(vertex.getCell())) && (jEdge.isMainTgt() || this.getCell().isAlwaysMovable())) {
            result = true;
        }
        return result;
    }

    private Point2D getPortPosition(Rectangle2D r) {
        Point2D offset = GraphConstants.getOffset((Map)this.allAttributes);
        double x = offset.getX();
        double y = offset.getY();
        x = x * (r.getWidth() - 1.0) / 1000.0;
        y = y * (r.getHeight() - 1.0) / 1000.0;
        return new Point2D.Double(r.getX() + x, r.getY() + y);
    }

    private Point2D computeNewOffset(Rectangle2D r, Point2D pos) {
        double x = pos.getX() - r.getX();
        double y = pos.getY() - r.getY();
        x = x * 1000.0 / (r.getWidth() - 1.0);
        y = y * 1000.0 / (r.getHeight() - 1.0);
        return new Point2D.Double(x, y);
    }

    public static class EdgeSigPortRenderer
    extends PortRenderer {
        private ShapeJPortView view;

        public Component getRendererComponent(JGraph graph, CellView view, boolean sel, boolean focus, boolean preview) {
            assert (view instanceof ShapeJPortView);
            this.view = (ShapeJPortView)view;
            return this;
        }

        public void paint(Graphics g) {
            assert (g instanceof Graphics2D);
            g.setColor(Color.BLACK);
            ((Graphics2D)g).fill(this.view.getGeometricShape());
        }
    }
}

