/*
 * Decompiled with CFR 0.152.
 */
package groove.abstraction.neigh.shape;

import groove.abstraction.Multiplicity;
import groove.abstraction.neigh.EdgeMultDir;
import groove.abstraction.neigh.equiv.EquivClass;
import groove.abstraction.neigh.equiv.EquivRelation;
import groove.abstraction.neigh.shape.EdgeSignature;
import groove.abstraction.neigh.shape.EdgeSignatureStore;
import groove.abstraction.neigh.shape.ShapeCache;
import groove.abstraction.neigh.shape.ShapeEdge;
import groove.abstraction.neigh.shape.ShapeFactory;
import groove.abstraction.neigh.shape.ShapeNode;
import groove.abstraction.neigh.shape.ShapeStore;
import groove.algebra.Algebra;
import groove.algebra.AlgebraFamily;
import groove.grammar.host.HostEdge;
import groove.grammar.host.HostGraph;
import groove.grammar.host.HostNode;
import groove.grammar.host.ValueNode;
import groove.grammar.model.FormatException;
import groove.grammar.type.TypeGraph;
import groove.grammar.type.TypeLabel;
import groove.graph.AGraph;
import groove.graph.Edge;
import groove.graph.GraphInfo;
import groove.graph.GraphRole;
import groove.graph.Label;
import groove.graph.Node;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class ShapeGraph
extends AGraph<HostNode, HostEdge>
implements HostGraph {
    ShapeStore store;
    private final ShapeFactory factory;
    private static final boolean COMPACT = true;

    public ShapeGraph(String name) {
        this(name, ShapeFactory.newInstance());
    }

    public ShapeGraph(String name, ShapeFactory factory) {
        super("shape graph");
        assert (factory != null);
        this.factory = factory;
    }

    @Override
    public boolean addNode(HostNode node) {
        assert (!this.isFixed()) : "Trying to add " + node + " to unmodifiable graph";
        boolean result = this.nodeSet().add((ShapeNode)node);
        return result;
    }

    @Override
    public boolean removeEdge(HostEdge edge) {
        assert (!this.isFixed()) : "Trying to remove " + edge + " from unmodifiable graph";
        return this.edgeSet().remove(edge);
    }

    @Override
    public boolean addEdge(HostEdge edge) {
        assert (!this.isFixed());
        assert (this.isTypeCorrect(edge));
        boolean result = this.edgeSet().add((ShapeEdge)edge);
        return result;
    }

    @Override
    public boolean removeNode(HostNode node) {
        assert (!this.isFixed());
        assert (this.isTypeCorrect(node));
        boolean result = this.nodeSet().remove(node);
        return result;
    }

    @Override
    public boolean removeNodeSet(Collection<? extends HostNode> nodeSet) {
        return this.nodeSet().removeAll(nodeSet);
    }

    @Override
    public Set<ShapeEdge> edgeSet() {
        return this.getCache().getEdgeSet();
    }

    @Override
    public Set<ShapeNode> nodeSet() {
        return this.getCache().getNodeSet();
    }

    public ValueNode addNode(Algebra<?> algebra, Object value) {
        ValueNode result = this.getFactory().createValueNode(algebra, value);
        this.addNode(result);
        return result;
    }

    @Override
    public Set<ShapeEdge> edgeSet(Node node) {
        return super.edgeSet(node);
    }

    @Override
    public Set<ShapeEdge> outEdgeSet(Node node) {
        return super.outEdgeSet(node);
    }

    @Override
    public Set<ShapeEdge> inEdgeSet(Node node) {
        return super.inEdgeSet(node);
    }

    @Override
    public ShapeEdge createEdge(HostNode source, Label label, HostNode target) {
        return (ShapeEdge)super.createEdge(source, label, target);
    }

    @Override
    public ShapeGraph clone() {
        ShapeGraph result = this.newGraph(this.getName());
        result.getCache().copyFrom(this);
        GraphInfo.transfer(this, result, null);
        return result;
    }

    @Override
    public ShapeGraph clone(AlgebraFamily family) {
        throw new UnsupportedOperationException();
    }

    @Override
    public GraphRole getRole() {
        return GraphRole.SHAPE;
    }

    @Override
    public ShapeGraph newGraph(String name) {
        return new ShapeGraph(name, this.getFactory());
    }

    @Override
    protected boolean isTypeCorrect(Node node) {
        return node instanceof ShapeNode;
    }

    @Override
    protected boolean isTypeCorrect(Edge edge) {
        return edge instanceof ShapeEdge;
    }

    @Override
    public ShapeFactory getFactory() {
        return this.factory;
    }

    @Override
    public TypeGraph getTypeGraph() {
        return this.getFactory().getTypeFactory().getGraph();
    }

    @Override
    public ShapeGraph retype(TypeGraph typeGraph) throws FormatException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean setFixed() {
        boolean result;
        boolean bl = result = !this.isFixed();
        if (result) {
            this.getCache().flatten();
            super.setFixed();
        }
        return result;
    }

    @Override
    public ShapeCache getCache() {
        return (ShapeCache)super.getCache();
    }

    @Override
    protected ShapeCache createCache() {
        return new ShapeCache(this);
    }

    public void clearStructuresForLoading() {
        this.getEquivRelation().clear();
        this.getNodeMultMap().clear();
        this.getEdgeSigStore().clear();
    }

    public Map<ShapeNode, Multiplicity> getNodeMultMap() {
        return this.getCache().getNodeMultMap();
    }

    public Map<EdgeSignature, Multiplicity> getEdgeMultMap() {
        return this.getEdgeSigStore().getMultMap();
    }

    public Set<EdgeSignature> getEdgeSigSet() {
        return this.getEdgeMultMap().keySet();
    }

    public EquivRelation<ShapeNode> getEquivRelation() {
        return this.getCache().getEquivRel();
    }

    public EquivClass<ShapeNode> getEquivClassOf(ShapeNode node) {
        assert (this.nodeSet().contains(node)) : "Node " + node + " is not in the shape!";
        return this.getEquivRelation().getEquivClassOf(node);
    }

    public EdgeSignatureStore getEdgeSigStore() {
        return this.getCache().getEdgeSigStore();
    }

    EdgeSignatureStore createEdgeSigStore() {
        return new EdgeSignatureStore(this);
    }

    EdgeSignature createEdgeSignature(EdgeMultDir direction, ShapeNode node, TypeLabel label, EquivClass<ShapeNode> ec) {
        return new EdgeSignature(direction, node, label, ec);
    }

    EdgeSignature createEdgeSignature(EdgeMultDir direction, ShapeEdge edge) {
        ShapeNode node = direction.incident(edge);
        TypeLabel label = (TypeLabel)edge.label();
        EquivClass<ShapeNode> ec = this.getEquivClassOf(direction.opposite(edge));
        return this.createEdgeSignature(direction, node, label, ec);
    }
}

