/*
 * Decompiled with CFR 0.152.
 */
package groove.abstraction.neigh.shape;

import groove.abstraction.Multiplicity;
import groove.abstraction.neigh.EdgeMultDir;
import groove.abstraction.neigh.equiv.EquivClass;
import groove.abstraction.neigh.equiv.EquivRelation;
import groove.abstraction.neigh.gui.dialog.ShapePreviewDialog;
import groove.abstraction.neigh.shape.EdgeSignature;
import groove.abstraction.neigh.shape.EdgeSignatureStore;
import groove.abstraction.neigh.shape.Shape;
import groove.abstraction.neigh.shape.ShapeEdge;
import groove.abstraction.neigh.shape.ShapeFactory;
import groove.abstraction.neigh.shape.ShapeNode;
import groove.grammar.host.HostEdge;
import groove.grammar.host.HostGraphMorphism;
import groove.grammar.host.HostNode;
import groove.grammar.type.TypeLabel;
import groove.graph.Edge;
import groove.graph.Morphism;
import groove.graph.Node;
import java.awt.GraphicsEnvironment;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class ShapeMorphism
extends HostGraphMorphism {
    ShapeMorphism(ShapeFactory factory) {
        super(factory);
    }

    @Override
    public ShapeMorphism clone() {
        return (ShapeMorphism)super.clone();
    }

    @Override
    protected ShapeMorphism newMap() {
        return new ShapeMorphism(this.getFactory());
    }

    @Override
    public ShapeMorphism then(Morphism<HostNode, HostEdge> other) {
        return (ShapeMorphism)super.then((Morphism)other);
    }

    @Override
    public ShapeMorphism inverseThen(Morphism<HostNode, HostEdge> other) {
        return (ShapeMorphism)super.inverseThen((Morphism)other);
    }

    @Override
    public ShapeNode getNode(Node key) {
        return (ShapeNode)super.getNode(key);
    }

    @Override
    public ShapeEdge getEdge(Edge key) {
        return (ShapeEdge)super.getEdge(key);
    }

    @Override
    public ShapeNode putNode(HostNode key, HostNode layout) {
        return (ShapeNode)super.putNode(key, layout);
    }

    @Override
    public ShapeEdge putEdge(HostEdge key, HostEdge layout) {
        return (ShapeEdge)super.putEdge(key, layout);
    }

    @Override
    public ShapeNode removeNode(HostNode key) {
        Iterator iter = this.edgeMap().keySet().iterator();
        while (iter.hasNext()) {
            HostEdge edge = (HostEdge)iter.next();
            if (!edge.source().equals(key) && !edge.target().equals(key)) continue;
            iter.remove();
        }
        return (ShapeNode)super.removeNode(key);
    }

    @Override
    public ShapeEdge removeEdge(HostEdge key) {
        return (ShapeEdge)super.removeEdge(key);
    }

    @Override
    public ShapeFactory getFactory() {
        return (ShapeFactory)super.getFactory();
    }

    @Override
    public Set<ShapeNode> getPreImages(Node node) {
        assert (node instanceof ShapeNode);
        return super.getPreImages(node);
    }

    @Override
    public Set<ShapeEdge> getPreImages(Edge edge) {
        assert (edge instanceof ShapeEdge);
        return super.getPreImages(edge);
    }

    public static ShapeMorphism createIdentityMorphism(Shape from, Shape to) {
        ShapeMorphism result = from.getFactory().createMorphism();
        for (ShapeNode node : from.nodeSet()) {
            assert (to.containsNode(node));
            result.putNode(node, node);
        }
        for (ShapeEdge edge : from.edgeSet()) {
            assert (to.containsEdge(edge));
            result.putEdge(edge, edge);
        }
        return result;
    }

    public Multiplicity getPreImagesMult(Shape from, ShapeNode nodeS, EdgeSignature esT) {
        Multiplicity result = Multiplicity.ZERO_EDGE_MULT;
        EdgeMultDir direction = esT.getDirection();
        TypeLabel label = esT.getLabel();
        EdgeSignatureStore fromStore = from.getEdgeSigStore();
        EquivRelation<ShapeNode> fromEquivRelation = from.getEquivRelation();
        HashSet<EquivClass<ShapeNode>> ecSS = new HashSet<EquivClass<ShapeNode>>();
        for (ShapeNode shapeNode : esT.getEquivClass()) {
            Set<ShapeNode> esEcNodesS = this.getPreImages(shapeNode);
            for (ShapeNode esEcNodeS : esEcNodesS) {
                ecSS.add(fromEquivRelation.getEquivClassOf(esEcNodeS));
            }
        }
        for (EquivClass equivClass : ecSS) {
            Multiplicity esMult;
            EdgeSignature esS = fromStore.getSig(direction, nodeS, label, equivClass);
            if (esS == null || (esMult = fromStore.getMult(esS)) == null) continue;
            result = result.add(esMult);
        }
        return result;
    }

    public EdgeSignature getEdgeSignature(Shape to, EdgeSignature esFrom) {
        return to.getEdgeSignature(esFrom.getDirection(), this.getNode(esFrom.getNode()), esFrom.getLabel(), to.getEquivClassOf(this.getNode((Node)esFrom.getEquivClass().iterator().next())));
    }

    public boolean isValid(Shape from, Shape to) {
        for (Map.Entry entry : this.nodeMap().entrySet()) {
            if (from.containsNode((Node)entry.getKey()) && to.containsNode((Node)entry.getValue())) continue;
            return false;
        }
        for (Map.Entry<Object, Object> entry : this.edgeMap().entrySet()) {
            if (from.containsEdge((Edge)entry.getKey()) && to.containsEdge((Edge)entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public boolean isConsistent(Shape from, Shape to) {
        boolean bl;
        boolean complyToEquivClass = true;
        block0: for (EquivClass equivClass : from.getEquivRelation()) {
            if (equivClass.size() <= 1) continue;
            Object ecT = null;
            for (ShapeNode nodeS : equivClass) {
                EquivClass<ShapeNode> otherEcT = to.getEquivClassOf(this.getNode(nodeS));
                if (ecT == null) {
                    ecT = otherEcT;
                }
                if (ecT.equals(otherEcT)) continue;
                complyToEquivClass = false;
                break block0;
            }
        }
        boolean bl2 = true;
        if (complyToEquivClass) {
            for (ShapeNode nodeT : to.nodeSet()) {
                Set<ShapeNode> nodesS;
                Multiplicity sum;
                Multiplicity nodeTMult = to.getNodeMult(nodeT);
                if (nodeTMult.subsumes(sum = from.getNodeSetMultSum(nodesS = this.getPreImages(nodeT)))) continue;
                bl = false;
                break;
            }
        }
        boolean complyToEdgeMult = true;
        if (complyToEquivClass && bl) {
            block3: for (EdgeSignature esT : to.getEdgeSigSet()) {
                Multiplicity esTMult = to.getEdgeSigMult(esT);
                Set<ShapeNode> nodesS = this.getPreImages(esT.getNode());
                for (ShapeNode nodeS : nodesS) {
                    Multiplicity sum = this.getPreImagesMult(from, nodeS, esT);
                    if (esTMult.subsumes(sum)) continue;
                    complyToEdgeMult = false;
                    break block3;
                }
            }
        }
        if (!(complyToEquivClass && bl && complyToEdgeMult)) {
            System.out.println("\n\nInconsistent shape morphism!");
            System.out.println("From shape:");
            System.out.println(from);
            System.out.println("To shape:");
            System.out.println(to);
            System.out.println("Morphism:");
            System.out.println(this);
            System.out.println("EC test: " + complyToEquivClass + ", Node mult test: " + bl + ", Edge mult test: " + complyToEdgeMult);
            if (!GraphicsEnvironment.isHeadless()) {
                ShapePreviewDialog.showShape(from.clone());
                ShapePreviewDialog.showShape(to.clone());
            }
        }
        return complyToEquivClass && bl && complyToEdgeMult;
    }
}

