/*
 * Decompiled with CFR 0.152.
 */
package groove.abstraction.pattern;

import groove.abstraction.MyHashSet;
import groove.grammar.host.HostEdge;
import groove.grammar.host.HostGraph;
import groove.grammar.rule.RuleEdge;
import groove.grammar.type.TypeLabel;
import groove.graph.Edge;
import groove.graph.EdgeRole;
import groove.graph.Graph;
import groove.graph.Node;
import groove.util.collect.UnmodifiableSetView;
import java.util.Set;

public final class Util {
    private Util() {
    }

    public static int getBinaryEdgesCount(HostGraph graph) {
        int result = 0;
        for (HostEdge edge : graph.edgeSet()) {
            if (edge.getRole() != EdgeRole.BINARY) continue;
            ++result;
        }
        return result;
    }

    public static Set<HostEdge> getBinaryEdges(HostGraph graph) {
        return new UnmodifiableSetView<HostEdge>(graph.edgeSet()){

            @Override
            public boolean approves(Object obj) {
                if (!(obj instanceof HostEdge)) {
                    return false;
                }
                HostEdge edge = (HostEdge)obj;
                return edge.getRole() == EdgeRole.BINARY;
            }
        };
    }

    public static Set<TypeLabel> getNodeLabels(Graph graph, Node node) {
        MyHashSet<TypeLabel> nodeLabels = new MyHashSet<TypeLabel>();
        for (Edge edge : graph.edgeSet(node)) {
            if (edge.getRole() == EdgeRole.BINARY) continue;
            if (edge instanceof HostEdge) {
                nodeLabels.add(((HostEdge)edge).label());
                continue;
            }
            if (edge instanceof RuleEdge) {
                nodeLabels.add((TypeLabel)((RuleEdge)edge).getType().label());
                continue;
            }
            assert (false);
        }
        return nodeLabels;
    }
}

