/*
 * Decompiled with CFR 0.152.
 */
package groove.abstraction.pattern.gui.jgraph;

import com.jgraph.layout.JGraphFacade;
import com.jgraph.layout.hierarchical.JGraphHierarchicalLayout;
import com.jgraph.layout.tree.JGraphCompactTreeLayout;
import groove.abstraction.MyHashSet;
import groove.abstraction.pattern.gui.jgraph.PatternJCell;
import groove.abstraction.pattern.gui.jgraph.PatternJEdge;
import groove.abstraction.pattern.gui.jgraph.PatternJModel;
import groove.abstraction.pattern.gui.jgraph.PatternJVertex;
import groove.abstraction.pattern.gui.look.PatternAdornmentValue;
import groove.abstraction.pattern.gui.look.PatternLabelValue;
import groove.abstraction.pattern.shape.AbstractPatternEdge;
import groove.abstraction.pattern.shape.AbstractPatternGraph;
import groove.abstraction.pattern.shape.AbstractPatternNode;
import groove.graph.Edge;
import groove.graph.GraphRole;
import groove.graph.Node;
import groove.gui.Simulator;
import groove.gui.jgraph.JCell;
import groove.gui.jgraph.JGraphFactory;
import groove.gui.jgraph.JVertex;
import groove.gui.layout.AbstractLayouter;
import groove.gui.layout.Layouter;
import groove.gui.look.VisualKey;
import groove.gui.look.VisualValue;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jgraph.JGraph;

public final class PatternJGraph
extends groove.gui.jgraph.JGraph<AbstractPatternGraph<?, ?>> {
    public PatternJGraph(Simulator simulator) {
        super(simulator);
    }

    @Override
    public GraphRole getGraphRole() {
        return GraphRole.PATTERN;
    }

    @Override
    public boolean isShowBidirectionalEdges() {
        return false;
    }

    public PatternJModel getModel() {
        return (PatternJModel)this.graphModel;
    }

    @Override
    protected Layouter createLayouter() {
        return new MyLayouter();
    }

    @Override
    protected JGraphFactory<AbstractPatternGraph<?, ?>> createFactory() {
        return new MyFactory();
    }

    private static class LineLayout {
        private LineLayout() {
        }

        void run(JGraphFacade facade, Set<PatternJVertex> vertices) {
            int x = 0;
            boolean y = false;
            int hSpace = 70;
            for (PatternJVertex vertex : vertices) {
                facade.setLocation((Object)vertex, (double)x, (double)y);
                x += hSpace;
            }
        }
    }

    private class MyFactory
    extends JGraphFactory<AbstractPatternGraph<?, ?>> {
        public MyFactory() {
            super(PatternJGraph.this);
        }

        public PatternJGraph getJGraph() {
            return (PatternJGraph)super.getJGraph();
        }

        public PatternJModel newModel() {
            return new PatternJModel(this.getJGraph());
        }

        public PatternJVertex newJVertex(Node node) {
            return PatternJVertex.newInstance(node instanceof AbstractPatternNode);
        }

        public PatternJEdge newJEdge(Edge edge) {
            return PatternJEdge.newInstance(edge instanceof AbstractPatternEdge);
        }

        @Override
        public VisualValue<?> newVisualValue(VisualKey key) {
            switch (key) {
                case ADORNMENT: {
                    return new PatternAdornmentValue();
                }
                case LABEL: {
                    return new PatternLabelValue(this.getJGraph());
                }
            }
            return super.newVisualValue(key);
        }
    }

    private static class MyLayouter
    extends AbstractLayouter {
        JGraphFacade facade;
        JGraphCompactTreeLayout treeLayout;
        LineLayout lineLayout;

        MyLayouter() {
            super("PatternJGraph Layouter");
        }

        MyLayouter(String name, PatternJGraph jgraph) {
            super(name, jgraph);
        }

        @Override
        public Layouter newInstance(groove.gui.jgraph.JGraph<?> jgraph) {
            return new MyLayouter(this.getName(), (PatternJGraph)jgraph);
        }

        @Override
        public void start() {
            this.prepareLayouting();
            this.run();
            this.finishLayouting();
        }

        PatternJGraph getJGraph() {
            return (PatternJGraph)this.jgraph;
        }

        void prepareLayouting() {
            this.getJGraph().setLayouting(true);
            this.facade = new JGraphFacade((JGraph)this.getJGraph());
            this.treeLayout = new JGraphCompactTreeLayout();
            this.treeLayout.setOrientation(7);
            this.lineLayout = new LineLayout();
        }

        void run() {
            List<JCell<AbstractPatternGraph<?, ?>>> roots2;
            for (List<JCell<AbstractPatternGraph<?, ?>>> roots2 : this.getJGraph().getModel().getReverseParentMap().values()) {
                this.layoutPattern(roots2);
            }
            this.facade.setVerticesFilter(null);
            roots2 = this.getJGraph().getModel().getPatternRoots();
            this.facade.setRoots(roots2);
            this.facade.setIgnoresCellsInGroups(true);
            JGraphHierarchicalLayout hLayout = new JGraphHierarchicalLayout();
            hLayout.setLayoutFromSinks(false);
            hLayout.run(this.facade);
        }

        void layoutPattern(List<PatternJCell> roots) {
            MyHashSet<PatternJVertex> verticesFilter = new MyHashSet<PatternJVertex>();
            for (PatternJCell jCell : roots) {
                if (!(jCell instanceof JVertex)) continue;
                verticesFilter.add((PatternJVertex)jCell);
            }
            if (this.lineLayout == null) {
                this.facade.setVerticesFilter(verticesFilter);
                this.facade.findTreeRoots();
                this.treeLayout.run(this.facade);
            } else {
                this.lineLayout.run(this.facade, verticesFilter);
            }
        }

        void finishLayouting() {
            Map nested = this.facade.createNestedMap(true, true);
            this.getJGraph().getGraphLayoutCache().edit(nested);
            this.getJGraph().setLayouting(false);
            this.getJGraph().refreshAllCells();
        }
    }
}

