/*
 * Decompiled with CFR 0.152.
 */
package groove.abstraction.pattern.lts;

import groove.abstraction.MyHashSet;
import groove.abstraction.pattern.explore.util.PatternGraphMatchApplier;
import groove.abstraction.pattern.explore.util.PatternGraphMatchSetCollector;
import groove.abstraction.pattern.explore.util.PatternRuleEventApplier;
import groove.abstraction.pattern.lts.PGTSListener;
import groove.abstraction.pattern.lts.PatternGraphState;
import groove.abstraction.pattern.lts.PatternState;
import groove.abstraction.pattern.lts.PatternTransition;
import groove.abstraction.pattern.shape.PatternFactory;
import groove.abstraction.pattern.shape.PatternGraph;
import groove.abstraction.pattern.trans.PatternGraphGrammar;
import groove.control.CtrlState;
import groove.graph.AGraph;
import groove.graph.ElementFactory;
import groove.graph.GGraph;
import groove.graph.GraphRole;
import groove.graph.Node;
import groove.graph.iso.CertificateStrategy;
import groove.graph.iso.IsoChecker;
import groove.graph.plain.PlainGraph;
import groove.graph.plain.PlainNode;
import groove.lts.LTSFactory;
import groove.util.collect.NestedIterator;
import groove.util.collect.TransformIterator;
import groove.util.collect.TreeHashSet;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class PGTS
extends AGraph<PatternState, PatternTransition> {
    private static final int STATE_SET_RESOLUTION = 2;
    private static final int STATE_SET_ROOT_RESOLUTION = 10;
    private static final int INITIAL_STATE_SET_SIZE = 10000;
    private final PatternGraphGrammar grammar;
    protected PatternState startState;
    private PatternFactory hostFactory;
    private StateSet stateSet;
    private TransitionSet transitionSet;
    private int transitionCount = 0;
    private int closedStateCount = 0;
    private Set<PGTSListener> listeners = new MyHashSet<PGTSListener>();

    public PGTS(PatternGraphGrammar grammar) {
        super(String.valueOf(grammar.getName()) + "-pgts");
        this.grammar = grammar;
    }

    protected void initialise() {
        assert (this.hostFactory == null && this.startState == null);
        PatternGraph startGraph = this.createStartGraph(this.grammar.getStartGraph());
        this.hostFactory = startGraph.getFactory();
        this.startState = this.createStartState(startGraph);
        this.addState(this.startState);
    }

    protected PatternGraph createStartGraph(PatternGraph startGraph) {
        return startGraph.clone();
    }

    protected PatternState createStartState(PatternGraph startGraph) {
        return new PatternGraphState(startGraph, this.grammar.getCtrlAut().getStart(), 0, this);
    }

    public PatternState startState() {
        if (this.startState == null) {
            this.initialise();
        }
        return this.startState;
    }

    public PatternGraphGrammar getGrammar() {
        return this.grammar;
    }

    public PatternFactory getHostFactory() {
        if (this.hostFactory == null) {
            this.initialise();
        }
        return this.hostFactory;
    }

    @Override
    public int nodeCount() {
        return this.getStateSet().size();
    }

    public final int getStateCount() {
        return this.nodeCount();
    }

    @Override
    public int edgeCount() {
        return this.transitionCount;
    }

    public final int getTransitionCount() {
        return this.transitionCount;
    }

    @Override
    public Set<? extends PatternTransition> outEdgeSet(Node node) {
        return ((PatternState)node).getTransitionSet();
    }

    @Override
    public Set<? extends PatternState> nodeSet() {
        return this.getStateSet();
    }

    @Override
    public Set<? extends PatternTransition> edgeSet() {
        if (this.transitionSet == null) {
            this.transitionSet = new TransitionSet();
        }
        return this.transitionSet;
    }

    @Override
    public boolean addNode(PatternState node) {
        return this.addState(node) == null;
    }

    @Override
    public boolean addEdge(PatternTransition edge) {
        this.addTransition(edge);
        return true;
    }

    @Override
    public GraphRole getRole() {
        return GraphRole.LTS;
    }

    public int getNextStateNr() {
        return this.nodeCount();
    }

    protected TreeHashSet<PatternState> getStateSet() {
        if (this.stateSet == null) {
            this.stateSet = this.createStateSet();
        }
        return this.stateSet;
    }

    protected StateSet createStateSet() {
        return new StateSet(null);
    }

    public void addTransition(PatternTransition transition) {
        if (transition.source().addTransition(transition)) {
            ++this.transitionCount;
            this.fireAddEdge(transition);
        }
    }

    public PatternState addState(PatternState newState) {
        PatternState result = this.getStateSet().put(newState);
        if (result == null) {
            this.fireAddNode(newState);
        }
        return result;
    }

    public Set<PGTSListener> getGraphListeners() {
        if (this.isFixed()) {
            return Collections.emptySet();
        }
        return this.listeners;
    }

    public void addLTSListener(PGTSListener listener) {
        if (this.listeners != null) {
            this.listeners.add(listener);
        }
    }

    public void removeLTSListener(PGTSListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    @Override
    protected void fireAddNode(PatternState node) {
        super.fireAddNode(node);
        for (PGTSListener listener : this.getGraphListeners()) {
            listener.addUpdate(this, node);
        }
    }

    @Override
    protected void fireAddEdge(PatternTransition edge) {
        super.fireAddEdge(edge);
        for (PGTSListener listener : this.getGraphListeners()) {
            listener.addUpdate(this, edge);
        }
    }

    @Override
    public ElementFactory<PatternState, PatternTransition> getFactory() {
        return new LTSFactory<PatternState, PatternTransition>(this);
    }

    public PlainGraph toPlainGraph() {
        PlainGraph result = new PlainGraph(this.getName());
        HashMap<PatternState, PlainNode> nodeMap = new HashMap<PatternState, PlainNode>();
        for (PatternState patternState : this.nodeSet()) {
            PlainNode image = (PlainNode)result.addNode(patternState.getNumber());
            nodeMap.put(patternState, image);
        }
        for (PatternTransition patternTransition : this.edgeSet()) {
            result.addEdge((PlainNode)nodeMap.get(patternTransition.source()), patternTransition.label().text(), (PlainNode)nodeMap.get(patternTransition.target()));
        }
        return result;
    }

    public PatternRuleEventApplier createMatchApplier() {
        return new PatternGraphMatchApplier(this);
    }

    public PatternGraphMatchSetCollector createMatchCollector(PatternState state) {
        return new PatternGraphMatchSetCollector(state);
    }

    public int openStateCount() {
        return this.nodeCount() - this.closedStateCount;
    }

    public void notifyClosure(PatternState state) {
        assert (state.isClosed());
        ++this.closedStateCount;
    }

    @Override
    public AGraph<PatternState, PatternTransition> clone() {
        throw new UnsupportedOperationException();
    }

    @Override
    public GGraph<PatternState, PatternTransition> newGraph(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeEdge(PatternTransition edge) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeNode(PatternState node) {
        throw new UnsupportedOperationException();
    }

    public static class StateSet
    extends TreeHashSet<PatternState> {
        protected final IsoChecker checker;

        public StateSet(IsoChecker checker) {
            super(10000, 2, 10);
            this.checker = checker == null ? IsoChecker.getInstance(true) : checker;
        }

        @Override
        protected boolean areEqual(PatternState myState, PatternState otherState) {
            if (myState.getCtrlState() != otherState.getCtrlState()) {
                return false;
            }
            return this.checker.areIsomorphic(myState.getGraph(), otherState.getGraph());
        }

        @Override
        protected int getCode(PatternState stateKey) {
            CertificateStrategy certifier = this.checker.getCertifier(stateKey.getGraph(), true);
            Object certificate = certifier.getGraphCertificate();
            int result = certificate.hashCode();
            CtrlState ctrlState = stateKey.getCtrlState();
            if (ctrlState != null) {
                result += ctrlState.hashCode();
            }
            return result;
        }
    }

    private class TransitionSet
    extends AbstractSet<PatternTransition> {
        TransitionSet() {
        }

        @Override
        public boolean contains(Object o) {
            boolean result = false;
            if (o instanceof PatternTransition) {
                PatternTransition transition = (PatternTransition)o;
                PatternState source = transition.source();
                result = PGTS.this.containsNode(source) && PGTS.this.outEdgeSet(source).contains(transition);
            }
            return result;
        }

        @Override
        public Iterator<PatternTransition> iterator() {
            TransformIterator<PatternState, Iterator<? extends PatternTransition>> stateOutTransitionIter = new TransformIterator<PatternState, Iterator<? extends PatternTransition>>(PGTS.this.nodeSet().iterator()){

                @Override
                public Iterator<? extends PatternTransition> toOuter(PatternState state) {
                    return PGTS.this.outEdgeSet(state).iterator();
                }
            };
            return new NestedIterator<PatternTransition>(stateOutTransitionIter);
        }

        @Override
        public int size() {
            return PGTS.this.getTransitionCount();
        }
    }
}

