/*
 * Decompiled with CFR 0.152.
 */
package groove.abstraction.pattern.shape;

import groove.abstraction.pattern.shape.AbstractPatternNode;
import groove.abstraction.pattern.shape.SimpleMorphism;
import groove.grammar.host.HostEdge;
import groove.grammar.host.HostNode;
import groove.graph.AEdge;
import groove.graph.EdgeRole;
import groove.graph.plain.PlainLabel;
import groove.util.Fixable;

public abstract class AbstractPatternEdge<N extends AbstractPatternNode>
extends AEdge<N, PlainLabel>
implements Fixable {
    private final int nr;

    public AbstractPatternEdge(int nr, N source, PlainLabel label, N target) {
        super(source, label, target);
        this.nr = nr;
    }

    @Override
    public EdgeRole getRole() {
        return EdgeRole.BINARY;
    }

    @Override
    public String toString() {
        return String.valueOf(((AbstractPatternNode)this.source()).toString()) + "--" + this.getIdStr() + "-->" + ((AbstractPatternNode)this.target()).toString();
    }

    @Override
    public abstract boolean setFixed();

    @Override
    public abstract boolean isFixed();

    @Override
    public void testFixed(boolean fixed) {
        if (this.isFixed() != fixed) {
            throw new IllegalStateException();
        }
    }

    protected abstract String getToStringPrefix();

    public abstract String getPrintableLabel();

    public abstract SimpleMorphism getMorphism();

    public int getNumber() {
        return this.nr;
    }

    public String getIdStr() {
        return String.valueOf(this.getToStringPrefix()) + this.nr;
    }

    public HostNode getImage(HostNode node) {
        return this.getMorphism().getImage(node);
    }

    public HostEdge getImage(HostEdge edge) {
        return this.getMorphism().getImage(edge);
    }

    public HostNode getPreImage(HostNode node) {
        return this.getMorphism().getPreImage(node);
    }

    public HostEdge getPreImage(HostEdge edge) {
        return this.getMorphism().getPreImage(edge);
    }

    public boolean isDom(HostNode node) {
        return this.getMorphism().isDom(node);
    }

    public boolean isDom(HostEdge edge) {
        return this.getMorphism().isDom(edge);
    }

    public boolean isCod(HostNode node) {
        return this.getMorphism().isCod(node);
    }

    public boolean isCod(HostEdge edge) {
        return this.getMorphism().isCod(edge);
    }
}

