/*
 * Decompiled with CFR 0.152.
 */
package groove.abstraction.pattern.shape;

import groove.abstraction.pattern.shape.PatternEdge;
import groove.abstraction.pattern.shape.PatternGraph;
import groove.abstraction.pattern.shape.PatternNode;
import groove.abstraction.pattern.shape.TypeEdge;
import groove.abstraction.pattern.shape.TypeGraph;
import groove.abstraction.pattern.shape.TypeNode;
import groove.graph.ElementFactory;
import groove.graph.Label;
import groove.graph.Morphism;
import groove.graph.plain.PlainLabel;
import groove.util.FreeNumberDispenser;
import groove.util.collect.TreeHashSet;
import java.util.Collection;

public final class PatternFactory
implements ElementFactory<PatternNode, PatternEdge> {
    private static final int NODES_INIT_CAPACITY = 100;
    private static final float NODES_GROWTH_FACTOR = 2.0f;
    private final TypeGraph typeGraph;
    private PatternNode[] nodes = new PatternNode[100];
    private final TreeHashSet<PatternEdge> edges;
    private int maxNodeNr;

    public PatternFactory(TypeGraph typeGraph) {
        this.typeGraph = typeGraph;
        this.edges = this.createEdgeStore();
        this.maxNodeNr = -1;
    }

    @Override
    public Morphism<PatternNode, PatternEdge> createMorphism() {
        return new Morphism<PatternNode, PatternEdge>(this);
    }

    public PatternGraph newPatternGraph() {
        return new PatternGraph(this.typeGraph, this);
    }

    @Override
    public int getMaxNodeNr() {
        return this.maxNodeNr;
    }

    public int getNextNodeNr() {
        return this.maxNodeNr + 1;
    }

    private PatternNode getNode(int nr) {
        assert (nr >= 0 && nr < this.nodes.length);
        PatternNode result = this.nodes[nr];
        assert (result != null);
        return result;
    }

    private PatternNode newNode(int nr, TypeNode type) {
        return new PatternNode(nr, type);
    }

    public PatternNode createNode(int nr, TypeNode type) {
        PatternNode result;
        assert (nr >= 0);
        if (nr >= this.maxNodeNr || this.nodes[nr] == null) {
            result = this.newNode(nr, type);
            this.addNode(result);
        } else {
            result = this.nodes[nr];
        }
        assert (result != null);
        return result;
    }

    public PatternNode createNode(TypeNode type) {
        return this.createNode(this.getNextNodeNr(), type);
    }

    public PatternNode createNode(TypeNode type, Collection<PatternNode> usedNodes) {
        FreeNumberDispenser dispenser = new FreeNumberDispenser(usedNodes);
        return this.createNode(type, dispenser);
    }

    public PatternNode createNode(TypeNode type, int[] usedNodes) {
        FreeNumberDispenser dispenser = new FreeNumberDispenser(usedNodes);
        return this.createNode(type, dispenser);
    }

    private PatternNode createNode(TypeNode type, FreeNumberDispenser dispenser) {
        int freeNr = dispenser.getNext();
        PatternNode result = null;
        while (freeNr != -1) {
            result = this.retrieveNode(freeNr, type);
            if (result.getType() == type) {
                return result;
            }
            freeNr = dispenser.getNext();
        }
        int i = dispenser.getMaxNumber() + 1;
        while (i < this.getMaxNodeNr()) {
            result = this.getNode(i);
            if (result.getType() == type) {
                return result;
            }
            ++i;
        }
        result = this.createNode(type);
        return result;
    }

    private PatternNode retrieveNode(int nodeNr, TypeNode type) {
        PatternNode result = this.nodes[nodeNr];
        if (result == null) {
            result = this.createNode(nodeNr, type);
        }
        return result;
    }

    public boolean addNode(PatternNode node) throws IllegalArgumentException {
        int nr = node.getNumber();
        if (nr < this.nodes.length && this.nodes[nr] != null && node != this.nodes[nr]) {
            throw new IllegalArgumentException(String.format("Duplicate nodes %s and %s with the same number %d", node, this.nodes[nr], nr));
        }
        if (nr >= this.nodes.length) {
            int newSize = Math.max((int)((float)this.nodes.length * 2.0f), nr + 1);
            PatternNode[] newNodes = new PatternNode[newSize];
            System.arraycopy(this.nodes, 0, newNodes, 0, this.nodes.length);
            this.nodes = newNodes;
        }
        if (this.nodes[nr] == null) {
            this.nodes[nr] = node;
            this.maxNodeNr = Math.max(this.maxNodeNr, nr);
            return true;
        }
        return false;
    }

    public int getEdgeCount() {
        return this.edges.size();
    }

    private TreeHashSet<PatternEdge> createEdgeStore() {
        return new TreeHashSet<PatternEdge>(){

            @Override
            protected final boolean areEqual(PatternEdge o1, PatternEdge o2) {
                return ((PatternNode)o1.source()).equals(o2.source()) && ((PatternNode)o1.target()).equals(o2.target()) && ((PlainLabel)o1.label()).equals(o2.label());
            }

            @Override
            protected final boolean allEqual() {
                return false;
            }
        };
    }

    public PatternEdge createEdge(PatternNode source, TypeEdge type, PatternNode target) {
        assert (source != null) : "Source node of pattern edge should not be null";
        assert (target != null) : "Target node of pattern edge should not be null";
        PatternEdge edge = this.newEdge(source, type, target, this.getEdgeCount());
        return this.storeEdge(edge);
    }

    private PatternEdge newEdge(PatternNode source, TypeEdge type, PatternNode target, int nr) {
        return new PatternEdge(nr, source, target, type);
    }

    private PatternEdge storeEdge(PatternEdge edge) {
        PatternEdge result = this.edges.put(edge);
        if (result == null) {
            result = edge;
        }
        return result;
    }

    @Override
    public PatternNode createNode(int nr) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Label createLabel(String text) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PatternEdge createEdge(PatternNode source, String text, PatternNode target) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PatternEdge createEdge(PatternNode source, Label label, PatternNode target) {
        throw new UnsupportedOperationException();
    }
}

