/*
 * Decompiled with CFR 0.152.
 */
package groove.abstraction.pattern.shape;

import groove.abstraction.Multiplicity;
import groove.abstraction.MyHashMap;
import groove.abstraction.MyHashSet;
import groove.abstraction.pattern.shape.PatternEdge;
import groove.abstraction.pattern.shape.PatternFactory;
import groove.abstraction.pattern.shape.PatternNode;
import groove.abstraction.pattern.shape.PatternShape;
import groove.graph.Edge;
import groove.graph.Morphism;
import groove.graph.Node;
import java.util.Map;
import java.util.Set;

public final class PatternShapeMorphism
extends Morphism<PatternNode, PatternEdge> {
    public static PatternShapeMorphism createIdentityMorphism(PatternShape from, PatternShape to) {
        PatternShapeMorphism result = new PatternShapeMorphism(from.getFactory());
        for (PatternNode node : from.nodeSet()) {
            assert (to.containsNode(node));
            result.putNode(node, node);
        }
        for (PatternEdge edge : from.edgeSet()) {
            assert (to.containsEdge(edge));
            result.putEdge(edge, edge);
        }
        return result;
    }

    public PatternShapeMorphism(PatternFactory factory) {
        super(factory);
    }

    @Override
    public PatternShapeMorphism clone() {
        return (PatternShapeMorphism)super.clone();
    }

    protected PatternShapeMorphism newMap() {
        return new PatternShapeMorphism(this.getFactory());
    }

    public PatternFactory getFactory() {
        return (PatternFactory)super.getFactory();
    }

    @Override
    public Set<PatternNode> getPreImages(Node node) {
        return super.getPreImages(node);
    }

    @Override
    public Set<PatternEdge> getPreImages(Edge edge) {
        return super.getPreImages(edge);
    }

    private Map<PatternNode, Set<PatternEdge>> getPreImagesMap(PatternEdge edge) {
        MyHashMap<PatternNode, Set<PatternEdge>> result = new MyHashMap<PatternNode, Set<PatternEdge>>();
        for (PatternEdge newEdge : this.getPreImages(edge)) {
            MyHashSet edgeSet = (MyHashSet)result.get(newEdge.source());
            if (edgeSet == null) {
                edgeSet = new MyHashSet();
                result.put((PatternNode)newEdge.source(), edgeSet);
            }
            edgeSet.add(newEdge);
        }
        return result;
    }

    public boolean isConsistent(PatternShape from, PatternShape to) {
        for (Map.Entry entry : this.nodeMap().entrySet()) {
            if (from.containsNode((Node)entry.getKey()) && to.containsNode((Node)entry.getValue())) continue;
            return false;
        }
        for (Map.Entry<Object, Object> entry : this.edgeMap().entrySet()) {
            if (from.containsEdge((Edge)entry.getKey()) && to.containsEdge((Edge)entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public boolean isValid(PatternShape from, PatternShape to) {
        for (PatternNode nodeT : to.nodeSet()) {
            Set<PatternNode> nodesS;
            Multiplicity sum;
            Multiplicity nodeTMult = to.getMult(nodeT);
            if (nodeTMult.subsumes(sum = from.getNodeSetMultSum(nodesS = this.getPreImages(nodeT)))) continue;
            return false;
        }
        for (PatternEdge edgeT : to.edgeSet()) {
            Multiplicity edgeTMult = to.getMult(edgeT);
            for (Set<PatternEdge> edgesS : this.getPreImagesMap(edgeT).values()) {
                Multiplicity sum = from.getEdgeSetMultSum(edgesS);
                if (edgeTMult.subsumes(sum)) continue;
                return false;
            }
        }
        return true;
    }
}

