/*
 * Decompiled with CFR 0.152.
 */
package groove.abstraction.pattern.shape;

import groove.abstraction.pattern.shape.AbstractPatternEdge;
import groove.abstraction.pattern.shape.SimpleMorphism;
import groove.abstraction.pattern.shape.TypeNode;
import groove.grammar.host.HostEdge;
import groove.grammar.host.HostGraph;
import groove.grammar.host.HostNode;
import groove.graph.plain.PlainLabel;

public final class TypeEdge
extends AbstractPatternEdge<TypeNode> {
    static final String PREFIX = "m";
    private final SimpleMorphism morph;

    public TypeEdge(int nr, TypeNode source, TypeNode target, SimpleMorphism morph) {
        super(nr, source, PlainLabel.createLabel(PREFIX + nr), target);
        assert (morph.getSource().equals(source) && morph.getTarget().equals(target));
        this.morph = morph;
    }

    @Override
    public boolean setFixed() {
        return this.getMorphism().setFixed();
    }

    @Override
    public boolean isFixed() {
        return this.getMorphism().isFixed();
    }

    @Override
    protected String getToStringPrefix() {
        return PREFIX;
    }

    @Override
    public SimpleMorphism getMorphism() {
        return this.morph;
    }

    @Override
    public String getPrintableLabel() {
        return this.getIdStr();
    }

    public void extendMorphism() {
        HostGraph srcPattern = ((TypeNode)this.source()).getPattern();
        HostGraph tgtPattern = ((TypeNode)this.target()).getPattern();
        for (HostEdge edge1 : srcPattern.edgeSet()) {
            HostNode src2 = this.getImage(edge1.source());
            HostNode tgt2 = this.getImage(edge1.target());
            for (HostEdge edge2 : tgtPattern.edgeSet(edge1.label())) {
                if (!edge2.source().equals(src2) || !edge2.target().equals(tgt2)) continue;
                this.getMorphism().putEdge(edge1, edge2);
            }
        }
    }
}

