/*
 * Decompiled with CFR 0.152.
 */
package groove.abstraction.pattern.trans;

import groove.abstraction.Multiplicity;
import groove.abstraction.pattern.match.Match;
import groove.abstraction.pattern.match.PreMatch;
import groove.abstraction.pattern.shape.PatternEdge;
import groove.abstraction.pattern.shape.PatternNode;
import groove.abstraction.pattern.shape.PatternShape;
import groove.abstraction.pattern.shape.TypeEdge;
import groove.abstraction.pattern.shape.TypeNode;
import groove.abstraction.pattern.trans.PatternRule;
import groove.abstraction.pattern.trans.PatternRuleGraph;
import groove.abstraction.pattern.trans.QuasiShape;
import groove.abstraction.pattern.trans.RuleEdge;
import groove.abstraction.pattern.trans.RuleNode;
import groove.graph.Node;
import groove.util.Duo;
import groove.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;

public final class Materialisation {
    private final PatternShape origShape;
    private final PatternShape pShape;
    private final PreMatch preMatch;
    private final PatternRule rule;
    private QuasiShape qShape;
    private Match match;

    public static Collection<PatternShape> getMaterialisations(PatternShape pShape, PreMatch preMatch) {
        ArrayList<PatternShape> result = new ArrayList<PatternShape>();
        if (preMatch.getRule().isModifying()) {
            Materialisation initialMat = new Materialisation(pShape, preMatch);
            initialMat.getSolutions(result);
        } else {
            result.add(pShape);
        }
        return result;
    }

    private Materialisation(PatternShape pShape, PreMatch preMatch) {
        assert (pShape.isFixed());
        assert (preMatch.isFixed());
        this.origShape = pShape;
        this.pShape = pShape.clone();
        this.preMatch = preMatch;
        this.rule = preMatch.getRule();
    }

    private void getSolutions(Collection<PatternShape> result) {
        this.pullMatchAndDevolveShape();
        this.disambiguate();
        this.deletePatterns();
        this.addPatterns();
        this.close();
        this.split();
        this.branch(result);
    }

    private PatternNode createNode(TypeNode type) {
        PatternNode newNode = this.pShape.createNode(type);
        this.pShape.addNode(newNode);
        return newNode;
    }

    private PatternEdge createEdge(PatternNode source, TypeEdge type, PatternNode target) {
        PatternEdge newEdge = this.pShape.createEdge(source, type, target);
        this.pShape.addEdgeContext(newEdge);
        return newEdge;
    }

    private void pullMatchAndDevolveShape() {
        PatternNode origNode;
        this.match = new Match(this.rule, this.pShape);
        PatternRuleGraph lhs = this.rule.lhs();
        for (RuleNode rNode : lhs.nodeSet()) {
            origNode = (PatternNode)this.preMatch.getNode(rNode);
            this.materialiseNode(rNode, origNode);
        }
        for (RuleEdge rEdge : lhs.edgeSet()) {
            PatternEdge origEdge = (PatternEdge)this.preMatch.getEdge(rEdge);
            this.materialiseEdge(rEdge, origEdge);
        }
        for (RuleNode rNode : lhs.nodeSet()) {
            origNode = (PatternNode)this.preMatch.getNode(rNode);
            PatternNode matNode = (PatternNode)this.match.getNode(rNode);
            for (PatternEdge origEdge : this.origShape.outEdgeSet(origNode)) {
                this.copyEdge(origEdge, matNode);
            }
        }
        assert (this.pShape.isWellDefined());
        this.qShape = QuasiShape.devolve(this.pShape);
        Match tempMatch = this.match;
        this.match = new Match(this.rule, this.qShape);
        this.match.putAll(tempMatch);
        this.match.setFixed();
    }

    private void materialiseNode(RuleNode rNode, PatternNode origNode) {
        PatternNode newNode;
        Multiplicity origMult = this.pShape.getMult(origNode);
        if (origMult.isOne()) {
            newNode = origNode;
        } else {
            newNode = this.createNode(origNode.getType());
            this.pShape.setMult(newNode, Multiplicity.ONE_NODE_MULT);
            this.pShape.setMult(origNode, origMult.sub(1));
        }
        this.match.putNode(rNode, newNode);
    }

    private void materialiseEdge(RuleEdge rEdge, PatternEdge origEdge) {
        PatternEdge newEdge;
        PatternNode origSrc = (PatternNode)origEdge.source();
        PatternNode origTgt = (PatternNode)origEdge.target();
        PatternNode newSrc = (PatternNode)this.match.getNode((Node)rEdge.source());
        PatternNode newTgt = (PatternNode)this.match.getNode((Node)rEdge.target());
        boolean sameSrc = origSrc.equals(newSrc);
        boolean sameTgt = origTgt.equals(newTgt);
        Multiplicity origMult = this.pShape.getMult(origEdge);
        TypeEdge edgeType = origEdge.getType();
        if (sameSrc && sameTgt) {
            assert (origMult.isOne());
            newEdge = origEdge;
        } else {
            newEdge = this.createEdge(newSrc, edgeType, newTgt);
            this.pShape.setMult(newEdge, Multiplicity.ONE_EDGE_MULT);
            if (sameSrc && !sameTgt) {
                this.pShape.setMult(origEdge, origMult.sub(1));
            }
        }
        this.match.putEdge(rEdge, newEdge);
    }

    private void copyEdge(PatternEdge origEdge, PatternNode newSrc) {
        int preImageCount;
        Multiplicity origMult = this.origShape.getMult(origEdge);
        Multiplicity adjustedMult = origMult.sub(preImageCount = this.preMatch.getPreImages(origEdge).size());
        if (adjustedMult.isZero()) {
            return;
        }
        PatternNode newTgt = (PatternNode)origEdge.target();
        PatternEdge newEdge = this.createEdge(newSrc, origEdge.getType(), newTgt);
        this.pShape.setMult(newEdge, adjustedMult);
    }

    private void disambiguate() {
        LinkedList<PatternNode> toTraverse = new LinkedList<PatternNode>();
        RuleNode[] ruleNodeArray = this.rule.getEraserNodes();
        int n = ruleNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            RuleNode ruleNode = ruleNodeArray[n2];
            toTraverse.add((PatternNode)this.match.getNode(ruleNode));
            ++n2;
        }
        for (PatternNode patternNode : this.qShape.getDownwardTraversal(toTraverse)) {
            if (patternNode.getLayer() <= 0) continue;
            this.qShape.disambiguate(patternNode);
        }
    }

    private void deletePatterns() {
        RuleNode[] ruleNodeArray = this.rule.getEraserNodes();
        int n = ruleNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            RuleNode rNode = ruleNodeArray[n2];
            this.qShape.deletePattern((PatternNode)this.match.getNode(rNode));
            ++n2;
        }
    }

    private void addPatterns() {
        RuleNode rNode;
        RuleNode[] ruleNodeArray = this.rule.getCreatorNodes();
        int n = ruleNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            rNode = ruleNodeArray[n2];
            if (rNode.isNodePattern()) {
                this.addNodePattern(rNode);
            }
            ++n2;
        }
        ruleNodeArray = this.rule.getCreatorNodes();
        n = ruleNodeArray.length;
        n2 = 0;
        while (n2 < n) {
            rNode = ruleNodeArray[n2];
            if (rNode.isEdgePattern()) {
                this.addEdgePattern(rNode);
            }
            ++n2;
        }
    }

    private void addNodePattern(RuleNode rNode) {
        PatternNode newNode = this.qShape.addNodePattern(rNode.getType());
        this.match.putNode(rNode, newNode);
    }

    private void addEdgePattern(RuleNode rNode) {
        Duo inEdges = this.rule.rhs().getIncomingEdges(rNode);
        RuleEdge r1 = (RuleEdge)inEdges.one();
        RuleEdge r2 = (RuleEdge)inEdges.two();
        TypeEdge m1 = r1.getType();
        TypeEdge m2 = r2.getType();
        PatternNode p1 = (PatternNode)this.match.getNode((Node)r1.source());
        PatternNode p2 = (PatternNode)this.match.getNode((Node)r2.source());
        Pair<PatternNode, Duo<PatternEdge>> pair = this.qShape.addEdgePattern(m1, m2, p1, p2);
        PatternNode newNode = pair.one();
        PatternEdge d1 = (PatternEdge)pair.two().one();
        PatternEdge d2 = (PatternEdge)pair.two().two();
        this.match.putNode(rNode, newNode);
        this.match.putEdge(r1, d1);
        this.match.putEdge(r2, d2);
    }

    private void close() {
        this.origShape.getTypeGraph().close(this.qShape);
    }

    private void split() {
    }

    private void branch(Collection<PatternShape> result) {
        this.qShape.getMaterialisations(result);
    }
}

