/*
 * Decompiled with CFR 0.152.
 */
package groove.abstraction.pattern.trans;

import groove.abstraction.MyHashMap;
import groove.abstraction.MyHashSet;
import groove.abstraction.pattern.shape.TypeEdge;
import groove.abstraction.pattern.shape.TypeGraph;
import groove.abstraction.pattern.shape.TypeNode;
import groove.abstraction.pattern.trans.PatternRuleGraph;
import groove.abstraction.pattern.trans.RuleEdge;
import groove.abstraction.pattern.trans.RuleFactory;
import groove.abstraction.pattern.trans.RuleNode;
import groove.grammar.Rule;
import groove.grammar.host.HostNode;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class PatternRule {
    private final String name;
    private final Rule sRule;
    private final TypeGraph type;
    private final boolean closure;
    private final boolean modifying;
    private final PatternRuleGraph lhs;
    private final PatternRuleGraph rhs;
    private int maxNodeNr;
    private int maxEdgeNr;
    private RuleNode[] eraserNodes;
    private RuleEdge[] eraserEdges;
    private RuleNode[] creatorNodes;
    private RuleEdge[] creatorEdges;

    public PatternRule(String name, TypeGraph type) {
        this.name = name;
        this.sRule = null;
        this.type = type;
        this.closure = true;
        this.modifying = true;
        this.lhs = new PatternRuleGraph(String.valueOf(name) + "-lhs");
        this.rhs = new PatternRuleGraph(String.valueOf(name) + "-rhs");
    }

    public PatternRule(Rule sRule, TypeGraph type) {
        this.name = sRule.getLastName();
        this.sRule = sRule;
        this.type = type;
        this.closure = false;
        this.modifying = sRule.isModifying();
        this.lhs = new PatternRuleGraph(String.valueOf(this.name) + "-lhs");
        this.rhs = new PatternRuleGraph(String.valueOf(this.name) + "-rhs");
    }

    public String toString() {
        return "Pattern rule: " + this.name + "\n" + this.lhs + this.rhs;
    }

    public boolean isClosure() {
        return this.closure;
    }

    public boolean isModifying() {
        return this.modifying;
    }

    public PatternRuleGraph lhs() {
        return this.lhs;
    }

    public PatternRuleGraph rhs() {
        return this.rhs;
    }

    public RuleNode addCreatorNode(TypeNode tNode) {
        RuleNode result = this.createNode(tNode);
        this.addToRhs(result);
        return result;
    }

    public RuleEdge addCreatorEdge(RuleNode rSrc, TypeEdge tEdge, RuleNode rTgt) {
        RuleEdge result = this.createEdge(rSrc, tEdge, rTgt);
        this.addToRhs(result);
        return result;
    }

    public RuleNode addEraserNode(TypeNode tNode) {
        RuleNode result = this.createNode(tNode);
        this.addToLhs(result);
        return result;
    }

    public RuleEdge addEraserEdge(RuleNode rSrc, TypeEdge tEdge, RuleNode rTgt) {
        RuleEdge result = this.createEdge(rSrc, tEdge, rTgt);
        this.addToLhs(result);
        return result;
    }

    public RuleNode addReaderNode(TypeNode tNode) {
        RuleNode result = this.createNode(tNode);
        this.addToLhs(result);
        this.addToRhs(result);
        return result;
    }

    public RuleEdge addReaderEdge(RuleNode rSrc, TypeEdge tEdge, RuleNode rTgt) {
        RuleEdge result = this.createEdge(rSrc, tEdge, rTgt);
        this.addToLhs(result);
        this.addToRhs(result);
        return result;
    }

    public RuleNode addRhsAsReader(PatternRule pRule) {
        assert (this.isClosure());
        PatternRuleGraph rGraph = pRule.rhs();
        MyHashMap<RuleNode, RuleNode> newNodeMap = new MyHashMap<RuleNode, RuleNode>();
        for (RuleNode rNode : rGraph.nodeSet()) {
            RuleNode addedNode = this.addReaderNode(rNode.getType());
            newNodeMap.put(rNode, addedNode);
        }
        for (RuleEdge rEdge : rGraph.edgeSet()) {
            this.addReaderEdge((RuleNode)newNodeMap.get(rEdge.source()), rEdge.getType(), (RuleNode)newNodeMap.get(rEdge.target()));
        }
        return (RuleNode)newNodeMap.get(pRule.getCreatorNodes()[0]);
    }

    private void addToLhs(RuleNode rNode) {
        this.lhs.addNode(rNode);
    }

    private void addToLhs(RuleEdge rEdge) {
        this.lhs.addEdgeContext(rEdge);
    }

    private void addToRhs(RuleNode rNode) {
        this.rhs.addNode(rNode);
    }

    private void addToRhs(RuleEdge rEdge) {
        this.rhs.addEdgeContext(rEdge);
    }

    private RuleNode createNode(TypeNode tNode) {
        return this.getFactory().createNode(this.maxNodeNr++, tNode);
    }

    private RuleEdge createEdge(RuleNode rSrc, TypeEdge tEdge, RuleNode rTgt) {
        return this.getFactory().createEdge(this.maxEdgeNr++, rSrc, tEdge, rTgt);
    }

    private RuleFactory getFactory() {
        return this.type.getRuleFactory();
    }

    public TypeGraph getTypeGraph() {
        return this.type;
    }

    public RuleNode[] getEraserNodes() {
        if (this.eraserNodes == null) {
            this.eraserNodes = this.computeEraserNodes();
        }
        return this.eraserNodes;
    }

    public RuleEdge[] getEraserEdges() {
        if (this.eraserEdges == null) {
            this.eraserEdges = this.computeEraserEdges();
        }
        return this.eraserEdges;
    }

    public RuleNode[] getCreatorNodes() {
        if (this.creatorNodes == null) {
            this.creatorNodes = this.computeCreatorNodes();
        }
        return this.creatorNodes;
    }

    public RuleEdge[] getCreatorEdges() {
        if (this.creatorEdges == null) {
            this.creatorEdges = this.computeCreatorEdges();
        }
        return this.creatorEdges;
    }

    public boolean isEraser(RuleNode rNode) {
        return this.lhs().nodeSet().contains(rNode) && !this.rhs().nodeSet().contains(rNode);
    }

    public boolean isCreator(RuleNode rNode) {
        return !this.lhs().nodeSet().contains(rNode) && this.rhs().nodeSet().contains(rNode);
    }

    private RuleNode[] computeEraserNodes() {
        MyHashSet<RuleNode> result = new MyHashSet<RuleNode>();
        result.addAll(this.lhs().nodeSet());
        result.removeAll(this.rhs().nodeSet());
        return result.toArray(new RuleNode[result.size()]);
    }

    private RuleEdge[] computeEraserEdges() {
        MyHashSet<RuleEdge> result = new MyHashSet<RuleEdge>();
        result.addAll(this.lhs().edgeSet());
        result.removeAll(this.rhs().edgeSet());
        return result.toArray(new RuleEdge[result.size()]);
    }

    private RuleNode[] computeCreatorNodes() {
        MyHashSet<RuleNode> result = new MyHashSet<RuleNode>();
        result.addAll(this.rhs().nodeSet());
        result.removeAll(this.lhs().nodeSet());
        return result.toArray(new RuleNode[result.size()]);
    }

    private RuleEdge[] computeCreatorEdges() {
        MyHashSet<RuleEdge> result = new MyHashSet<RuleEdge>();
        result.addAll(this.rhs().edgeSet());
        result.removeAll(this.lhs().edgeSet());
        return result.toArray(new RuleEdge[result.size()]);
    }

    public void fixCommutativity() {
        assert (this.isClosure());
        if (this.rhs().depth() <= 1) {
            return;
        }
        RuleNode creatorNode = (RuleNode)this.rhs().getLayerNodes(this.rhs().depth()).iterator().next();
        MyHashMap<RuleNode, RuleNode> replacementMap = new MyHashMap<RuleNode, RuleNode>();
        for (HostNode hostNode : creatorNode.getPattern().nodeSet()) {
            Set<RuleNode> ancestors = this.rhs().getAncestors(creatorNode, hostNode);
            if (ancestors.size() <= 1) continue;
            Iterator<RuleNode> it = ancestors.iterator();
            RuleNode toKeep = it.next();
            while (it.hasNext()) {
                replacementMap.put(it.next(), toKeep);
            }
        }
        for (Map.Entry entry : replacementMap.entrySet()) {
            this.mergeNodes((RuleNode)entry.getKey(), (RuleNode)entry.getValue());
        }
        assert (this.lhs().isWellFormed());
        assert (this.lhs().isCommuting());
        assert (this.rhs().isWellFormed());
        assert (this.rhs().isCommuting());
    }

    private void mergeNodes(RuleNode from, RuleNode to) {
        assert (from.isNodePattern());
        assert (to.isNodePattern());
        for (RuleEdge rEdge : this.rhs().outEdgeSet(from)) {
            this.addReaderEdge(to, rEdge.getType(), (RuleNode)rEdge.target());
        }
        this.lhs().removeNodeContext(from);
        this.rhs().removeNodeContext(from);
    }

    public Rule getSimpleRule() {
        return this.sRule;
    }

    public String getName() {
        return this.name;
    }
}

