/*
 * Decompiled with CFR 0.152.
 */
package groove.algebra;

import groove.algebra.Algebra;
import groove.algebra.Algebras;
import groove.algebra.BigBoolAlgebra;
import groove.algebra.BigDoubleAlgebra;
import groove.algebra.BigIntAlgebra;
import groove.algebra.BigStringAlgebra;
import groove.algebra.Constant;
import groove.algebra.JavaBoolAlgebra;
import groove.algebra.JavaDoubleAlgebra;
import groove.algebra.JavaIntAlgebra;
import groove.algebra.JavaStringAlgebra;
import groove.algebra.Operator;
import groove.algebra.PointAlgebra;
import groove.algebra.PointBoolAlgebra;
import groove.algebra.PointIntAlgebra;
import groove.algebra.PointRealAlgebra;
import groove.algebra.PointStringAlgebra;
import groove.algebra.SignatureKind;
import groove.algebra.Term;
import groove.algebra.TermBoolAlgebra;
import groove.algebra.TermIntAlgebra;
import groove.algebra.TermRealAlgebra;
import groove.algebra.TermStringAlgebra;
import groove.algebra.Variable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public final class AlgebraFamily
extends Enum<AlgebraFamily> {
    public static final /* enum */ AlgebraFamily DEFAULT = new AlgebraFamily("default", JavaIntAlgebra.instance, JavaBoolAlgebra.instance, JavaStringAlgebra.instance, JavaDoubleAlgebra.instance);
    public static final /* enum */ AlgebraFamily POINT = new AlgebraFamily("point", PointIntAlgebra.instance, PointBoolAlgebra.instance, PointStringAlgebra.instance, PointRealAlgebra.instance);
    public static final /* enum */ AlgebraFamily BIG = new AlgebraFamily("big", BigIntAlgebra.instance, BigBoolAlgebra.instance, BigStringAlgebra.instance, BigDoubleAlgebra.instance);
    public static final /* enum */ AlgebraFamily TERM = new AlgebraFamily("term", TermIntAlgebra.instance, TermBoolAlgebra.instance, TermStringAlgebra.instance, TermRealAlgebra.instance);
    private final String name;
    private final Map<SignatureKind, Algebra<?>> algebraMap = new EnumMap(SignatureKind.class);
    private final Map<Algebra<?>, Map<String, Operation>> operationsMap = new HashMap();
    private static Map<String, AlgebraFamily> familyMap;
    private static final /* synthetic */ AlgebraFamily[] ENUM$VALUES;

    static {
        ENUM$VALUES = new AlgebraFamily[]{DEFAULT, POINT, BIG, TERM};
        familyMap = new HashMap<String, AlgebraFamily>();
        AlgebraFamily[] algebraFamilyArray = AlgebraFamily.values();
        int n = algebraFamilyArray.length;
        int n2 = 0;
        while (n2 < n) {
            AlgebraFamily family = algebraFamilyArray[n2];
            familyMap.put(family.getName(), family);
            ++n2;
        }
    }

    private AlgebraFamily(String name, Algebra<?> ... algebras) throws IllegalArgumentException, IllegalStateException {
        this.name = name;
        Algebra<?>[] algebraArray = algebras;
        int n2 = algebras.length;
        int n3 = 0;
        while (n3 < n2) {
            Algebra<?> algebra = algebraArray[n3];
            this.setImplementation(algebra);
            ++n3;
        }
        this.checkCompleteness();
    }

    private void setImplementation(Algebra<?> algebra) {
        SignatureKind sigKind = algebra.getKind();
        Algebra<?> oldAlgebra = this.algebraMap.put(sigKind, algebra);
        if (oldAlgebra != null) {
            throw new IllegalArgumentException(String.format("Signature '%s' already implemented by '%s'", new Object[]{sigKind, oldAlgebra.getName()}));
        }
    }

    private void checkCompleteness() throws IllegalStateException {
        SignatureKind[] signatureKindArray = SignatureKind.values();
        int n = signatureKindArray.length;
        int n2 = 0;
        while (n2 < n) {
            SignatureKind sigKind = signatureKindArray[n2];
            if (!this.algebraMap.containsKey((Object)sigKind)) {
                throw new IllegalStateException(String.format("Implementation of signature '%s' is missing", new Object[]{sigKind}));
            }
            ++n2;
        }
    }

    public final String getName() {
        return this.name;
    }

    public Algebra<?> getAlgebra(SignatureKind sigKind) {
        return this.algebraMap.get((Object)sigKind);
    }

    public Object getValue(SignatureKind signature, String constant) {
        return this.getAlgebra(signature).getValueFromSymbol(constant);
    }

    public boolean supportsSymbolic() {
        return this == POINT;
    }

    public Object getValue(SignatureKind signature, Variable variable) {
        if (this == POINT) {
            return ((PointAlgebra)this.getAlgebra(signature)).getPointValue();
        }
        throw new UnsupportedOperationException(String.format("Algebra family %s cannot assign value to variable %s", this.getName(), variable.getName()));
    }

    public Object getValue(Term term) {
        if (term instanceof Constant) {
            return this.getValue(term.getSignature(), ((Constant)term).getSymbol());
        }
        if (term instanceof Variable) {
            assert (this == POINT);
            return this.getValue(term.getSignature(), (Variable)term);
        }
        assert (false);
        return null;
    }

    public Operation getOperation(Operator operator) {
        Algebra<?> algebra = this.getAlgebra(operator.getSignature());
        assert (algebra != null);
        return this.getOperations(algebra).get(operator.getName());
    }

    private Map<String, Operation> getOperations(Algebra<?> algebra) {
        Map<String, Operation> result = this.operationsMap.get(algebra);
        if (result == null) {
            result = this.createOperationsMap(algebra);
            this.operationsMap.put(algebra, result);
        }
        return result;
    }

    public Algebra<?> getAlgebraFor(String constant) {
        for (Algebra<?> algebra : this.algebraMap.values()) {
            if (!algebra.isValue(constant)) continue;
            return algebra;
        }
        return null;
    }

    private Map<String, Operation> createOperationsMap(Algebra<?> algebra) {
        Method[] signatureMethods;
        HashMap<String, Operation> result = new HashMap<String, Operation>();
        HashSet<String> methodNames = new HashSet<String>();
        Method[] methodArray = signatureMethods = Algebras.getSignature(algebra).getDeclaredMethods();
        int n = signatureMethods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (Modifier.isAbstract(method.getModifiers()) && Modifier.isPublic(method.getModifiers())) {
                methodNames.add(method.getName());
            }
            ++n2;
        }
        Class<?> myClass = algebra.getClass();
        while (!methodNames.isEmpty()) {
            Method[] methodArray2 = myClass.getDeclaredMethods();
            int n3 = methodArray2.length;
            n = 0;
            while (n < n3) {
                Method method = methodArray2[n];
                if (methodNames.remove(method.getName())) {
                    result.put(method.getName(), this.createOperation(algebra, method));
                }
                ++n;
            }
            myClass = myClass.getSuperclass();
        }
        return result;
    }

    private Operation createOperation(Algebra<?> algebra, Method method) {
        return new Operation(this, algebra, method);
    }

    public String toString() {
        return this.algebraMap.toString();
    }

    public static AlgebraFamily getInstance() {
        return DEFAULT;
    }

    public static AlgebraFamily getInstance(String instanceName) {
        AlgebraFamily result = familyMap.get(instanceName);
        return result;
    }

    public static AlgebraFamily[] values() {
        AlgebraFamily[] algebraFamilyArray = ENUM$VALUES;
        int n = algebraFamilyArray.length;
        AlgebraFamily[] algebraFamilyArray2 = new AlgebraFamily[n];
        System.arraycopy(ENUM$VALUES, 0, algebraFamilyArray2, 0, n);
        return algebraFamilyArray2;
    }

    public static AlgebraFamily valueOf(String string) {
        return Enum.valueOf(AlgebraFamily.class, string);
    }

    private static class Operation
    implements groove.algebra.Operation {
        private final Algebra<?> algebra;
        private final Algebra<?> returnType;
        private final Method method;

        Operation(AlgebraFamily register, Algebra<?> algebra, Method method) {
            this.algebra = algebra;
            this.method = method;
            SignatureKind returnType = Algebras.getOperator(algebra.getKind(), method.getName()).getResultType();
            this.returnType = register.getAlgebra(returnType);
        }

        @Override
        public Object apply(List<Object> args) throws IllegalArgumentException {
            try {
                return this.method.invoke(this.algebra, args.toArray());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IllegalArgumentException();
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new IllegalArgumentException();
            }
        }

        @Override
        public Algebra<?> getAlgebra() {
            return this.algebra;
        }

        @Override
        public int getArity() {
            return this.method.getParameterTypes().length;
        }

        @Override
        public Algebra<?> getResultAlgebra() {
            return this.returnType;
        }

        @Override
        public String getName() {
            return this.method.getName();
        }

        public String toString() {
            return this.getName();
        }
    }
}

