/*
 * Decompiled with CFR 0.152.
 */
package groove.algebra;

import groove.algebra.Precedence;
import groove.algebra.Signature;
import groove.algebra.SignatureKind;
import groove.annotation.InfixSymbol;
import groove.annotation.PrefixSymbol;
import groove.annotation.Syntax;
import groove.annotation.ToolTipBody;
import groove.annotation.ToolTipHeader;
import java.math.BigInteger;

public abstract class IntSignature<Int, Bool, String>
implements Signature {
    @Syntax(value="Q%s.LPAR.i.RPAR")
    @ToolTipHeader(value="Absolute integer value")
    @ToolTipBody(value={"Returns the absolute value of %s"})
    public abstract Int abs(Int var1);

    @Syntax(value="Q%s.LPAR.i1.COMMA.i2.RPAR")
    @ToolTipHeader(value="Integer addition")
    @ToolTipBody(value={"Returns the sum of %s and %s"})
    @InfixSymbol(symbol="+", precedence=Precedence.ADD)
    public abstract Int add(Int var1, Int var2);

    @Syntax(value="Q%s.LPAR.i1.COMMA.i2.RPAR")
    @ToolTipHeader(value="Integer division")
    @ToolTipBody(value={"Returns the integer quotient of %s and %s"})
    @InfixSymbol(symbol="/", precedence=Precedence.MULT)
    public abstract Int div(Int var1, Int var2);

    @ToolTipHeader(value="Integer equality test")
    @Syntax(value="Q%s.LPAR.i1.COMMA.i2.RPAR")
    @ToolTipBody(value={"Yields TRUE if integer %s equals integer %s"})
    @InfixSymbol(symbol="==", precedence=Precedence.EQUAL)
    public abstract Bool eq(Int var1, Int var2);

    @ToolTipHeader(value="Integer greater-or-equal test")
    @Syntax(value="Q%s.LPAR.i1.COMMA.i2.RPAR")
    @ToolTipBody(value={"Yields TRUE if integer %s is larger than integer %s"})
    @InfixSymbol(symbol=">=", precedence=Precedence.COMPARE)
    public abstract Bool ge(Int var1, Int var2);

    @ToolTipHeader(value="Integer greater-than test")
    @Syntax(value="Q%s.LPAR.i1.COMMA.i2.RPAR")
    @ToolTipBody(value={"Yields TRUE if integer %2$s is properly larger than integer %1$s"})
    @InfixSymbol(symbol=">", precedence=Precedence.COMPARE)
    public abstract Bool gt(Int var1, Int var2);

    @ToolTipHeader(value="Integer lesser-or-equal test")
    @Syntax(value="Q%s.LPAR.i1.COMMA.i2.RPAR")
    @ToolTipBody(value={"Yields TRUE if integer %s is smaller than integer %s"})
    @InfixSymbol(symbol="<=", precedence=Precedence.COMPARE)
    public abstract Bool le(Int var1, Int var2);

    @ToolTipHeader(value="Integer lesser-than test")
    @Syntax(value="Q%s.LPAR.i1.COMMA.i2.RPAR")
    @ToolTipBody(value={"Yields TRUE if integer %s is properly smaller than integer %s"})
    @InfixSymbol(symbol="<", precedence=Precedence.COMPARE)
    public abstract Bool lt(Int var1, Int var2);

    @Syntax(value="Q%s.LPAR.i1.COMMA.i2.RPAR")
    @ToolTipHeader(value="Integer minimum")
    @ToolTipBody(value={"Returns the maximum of %s and %s"})
    public abstract Int max(Int var1, Int var2);

    @Syntax(value="Q%s.LPAR.i1.COMMA.i2.RPAR")
    @ToolTipHeader(value="Integer minimum")
    @ToolTipBody(value={"Returns the minimum of %s and %s"})
    public abstract Int min(Int var1, Int var2);

    @Syntax(value="Q%s.LPAR.i1.COMMA.i2.RPAR")
    @ToolTipHeader(value="Modulo")
    @ToolTipBody(value={"Returns the remainder after dividing %s by %s"})
    @InfixSymbol(symbol="%", precedence=Precedence.MULT)
    public abstract Int mod(Int var1, Int var2);

    @Syntax(value="Q%s.LPAR.i1.COMMA.i2.RPAR")
    @ToolTipHeader(value="Integer multiplication")
    @ToolTipBody(value={"Returns the product of %s and %s"})
    @InfixSymbol(symbol="*", precedence=Precedence.MULT)
    public abstract Int mul(Int var1, Int var2);

    @ToolTipHeader(value="Integer inequality test")
    @Syntax(value="Q%s.LPAR.i1.COMMA.i2.RPAR")
    @ToolTipBody(value={"Yields TRUE if integer %s does not equal integer %s"})
    @InfixSymbol(symbol="!=", precedence=Precedence.EQUAL)
    public abstract Bool neq(Int var1, Int var2);

    @ToolTipHeader(value="Integer inversion")
    @Syntax(value="Q%s.LPAR.i1.RPAR")
    @ToolTipBody(value={"Yields the inverse of %s"})
    @PrefixSymbol(symbol="-")
    public abstract Int neg(Int var1);

    @Syntax(value="Q%s.LPAR.i1.COMMA.i2.RPAR")
    @ToolTipHeader(value="Integer subtraction")
    @ToolTipBody(value={"Returns the difference between %s and %s"})
    @InfixSymbol(symbol="-", precedence=Precedence.ADD)
    public abstract Int sub(Int var1, Int var2);

    @ToolTipHeader(value="Integer-to-string conversion")
    @Syntax(value="Q%s.LPAR.i1.RPAR")
    @ToolTipBody(value={"Yields a string representation of %s"})
    public abstract String toString(Int var1);

    @Override
    public SignatureKind getKind() {
        return SignatureKind.INT;
    }

    @Override
    public final boolean isValue(String value) {
        try {
            new BigInteger(value);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public final Int getValueFromJava(Object constant) {
        if (!(constant instanceof Integer)) {
            throw new IllegalArgumentException(String.format("Native int type is %s, not %s", Integer.class.getSimpleName(), constant.getClass().getSimpleName()));
        }
        return this.toValue((Integer)constant);
    }

    protected abstract Int toValue(Integer var1);
}

