/*
 * Decompiled with CFR 0.152.
 */
package groove.automaton;

import groove.automaton.DFAState;
import groove.automaton.Direction;
import groove.automaton.Recogniser;
import groove.automaton.RegNode;
import groove.grammar.host.HostGraph;
import groove.grammar.type.TypeLabel;
import groove.util.Duo;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class DFA {
    private final Direction dir;
    private final DFAState startState;
    private final Map<Set<RegNode>, DFAState> stateMap = new LinkedHashMap<Set<RegNode>, DFAState>();
    private Recogniser recogniser;

    public DFA(Direction dir, Set<RegNode> startNodes, boolean isFinal) {
        this.dir = dir;
        this.startState = new DFAState(0, startNodes, true, isFinal);
        this.stateMap.put(startNodes, this.startState);
    }

    public DFA(Direction dir, RegNode startNode, boolean isFinal) {
        this(dir, Collections.singleton(startNode), isFinal);
    }

    public DFAState getState(Set<RegNode> nodes) {
        return this.stateMap.get(nodes);
    }

    public Direction getDirection() {
        return this.dir;
    }

    public Collection<DFAState> getStates() {
        return this.stateMap.values();
    }

    public DFAState addState(Set<RegNode> nodes, boolean isFinal) {
        DFAState result = new DFAState(this.stateMap.size(), nodes, false, isFinal);
        DFAState oldState = this.stateMap.put(nodes, result);
        assert (oldState == null);
        return result;
    }

    public DFAState getStartState() {
        return this.startState;
    }

    public DFA toMinimised() {
        Set<Set<DFAState>> equivalence = this.computeEquivalence();
        Map<DFAState, Set<DFAState>> partition = this.computePartition(equivalence);
        return this.computeQuotient(partition);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (DFAState state : this.getStates()) {
            result.append(String.format("%s%n", state));
            Direction[] directionArray = Direction.values();
            int n = directionArray.length;
            int n2 = 0;
            while (n2 < n) {
                Direction dir = directionArray[n2];
                for (Map.Entry<TypeLabel, DFAState> labelEntry : state.getLabelMap().get((Object)dir).entrySet()) {
                    result.append(dir == Direction.FORWARD ? "   " : "  -");
                    result.append(labelEntry.getKey());
                    result.append(" --> ");
                    result.append(labelEntry.getValue());
                    result.append('\n');
                }
                ++n2;
            }
        }
        return result.toString();
    }

    public boolean isEmpty() {
        return this.getStartState().getLabelMap().get((Object)Direction.FORWARD).isEmpty() && this.getStartState().getLabelMap().get((Object)Direction.BACKWARD).isEmpty() && !this.getStartState().isFinal();
    }

    public boolean isEquivalent(DFA other) {
        if (this.getStates().size() != other.getStates().size()) {
            return false;
        }
        boolean result = true;
        HashMap<DFAState, DFAState> isoMap = new HashMap<DFAState, DFAState>();
        HashSet<Duo<DFAState>> newPairs = new HashSet<Duo<DFAState>>();
        isoMap.put(this.getStartState(), other.getStartState());
        newPairs.add(Duo.newDuo(this.getStartState(), other.getStartState()));
        do {
            Iterator newIter = newPairs.iterator();
            Duo current = (Duo)newIter.next();
            newIter.remove();
            Set<Duo<DFAState>> targetPairs = this.compareStates(current);
            if (targetPairs == null) {
                result = false;
                continue;
            }
            for (Duo<DFAState> pair : targetPairs) {
                DFAState old = isoMap.put((DFAState)pair.one(), (DFAState)pair.two());
                if (old == null) {
                    newPairs.add(pair);
                    continue;
                }
                boolean bl = result = old == pair.two();
            }
        } while (result && !newPairs.isEmpty());
        return result;
    }

    public Recogniser getRecogniser(HostGraph graph) {
        if (this.recogniser == null || this.recogniser.getGraph() != graph) {
            this.recogniser = new Recogniser(this, graph);
        }
        return this.recogniser;
    }

    private Set<Duo<DFAState>> compareStates(Duo<DFAState> statePair) {
        HashSet<Duo<DFAState>> result = new HashSet<Duo<DFAState>>();
        DFAState one = (DFAState)statePair.one();
        DFAState two = (DFAState)statePair.two();
        if (one.isFinal() != two.isFinal()) {
            return null;
        }
        Direction[] directionArray = Direction.values();
        int n = directionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Direction dir = directionArray[n2];
            Map<TypeLabel, DFAState> oneLabelMap = one.getLabelMap().get((Object)dir);
            Map<TypeLabel, DFAState> twoLabelMap = two.getLabelMap().get((Object)dir);
            if (oneLabelMap.size() != twoLabelMap.size()) {
                return null;
            }
            for (Map.Entry<TypeLabel, DFAState> oneEntry : oneLabelMap.entrySet()) {
                TypeLabel key = oneEntry.getKey();
                DFAState twoTarget = twoLabelMap.get(key);
                if (twoTarget == null) {
                    return null;
                }
                result.add(Duo.newDuo(oneEntry.getValue(), twoTarget));
            }
            ++n2;
        }
        return result;
    }

    private Set<Set<DFAState>> computeEquivalence() {
        HashSet<Set<DFAState>> depSet;
        HashSet<DFAState> ijPair;
        HashSet<Set<DFAState>> result = new HashSet<Set<DFAState>>();
        HashMap<Set<DFAState>, Set<Set<DFAState>>> depMap = new HashMap<Set<DFAState>, Set<Set<DFAState>>>();
        for (DFAState i : this.getStates()) {
            for (DFAState j : this.getStates()) {
                if (i.getNumber() >= j.getNumber()) continue;
                ijPair = new HashSet<DFAState>(Arrays.asList(i, j));
                depSet = new HashSet<HashSet<DFAState>>();
                depSet.add(ijPair);
                depMap.put(ijPair, depSet);
                result.add(ijPair);
            }
        }
        for (DFAState i : this.getStates()) {
            for (DFAState j : this.getStates()) {
                if (i.getNumber() >= j.getNumber()) continue;
                ijPair = new HashSet<DFAState>(Arrays.asList(i, j));
                depSet = (Set)depMap.remove(ijPair);
                assert (depSet != null);
                boolean distinct = i.isFinal() ^ j.isFinal();
                if (!distinct) {
                    Direction[] directionArray = Direction.values();
                    int n = directionArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Direction dir = directionArray[n2];
                        if (this.areDistinct(i.getLabelMap().get((Object)dir), j.getLabelMap().get((Object)dir), depSet, depMap)) {
                            distinct = true;
                            break;
                        }
                        ++n2;
                    }
                }
                if (!distinct) continue;
                result.removeAll(depSet);
            }
        }
        return result;
    }

    private <K> boolean areDistinct(Map<K, DFAState> iMap, Map<K, DFAState> jMap, Set<Set<DFAState>> ijDepSet, Map<Set<DFAState>, Set<Set<DFAState>>> depMap) {
        boolean result = false;
        if (!iMap.keySet().equals(jMap.keySet())) {
            result = true;
        } else {
            for (Map.Entry<K, DFAState> iEntry : iMap.entrySet()) {
                DFAState iSucc = iEntry.getValue();
                DFAState jSucc = iMap.get(iEntry.getKey());
                HashSet<DFAState> ijTargetPair = new HashSet<DFAState>(Arrays.asList(iSucc, jSucc));
                Set<Set<DFAState>> ijTargetDep = depMap.get(ijTargetPair);
                if (ijTargetDep == null) {
                    result = true;
                    break;
                }
                ijTargetDep.addAll(ijDepSet);
            }
        }
        return result;
    }

    private Map<DFAState, Set<DFAState>> computePartition(Set<Set<DFAState>> equivalence) {
        HashMap<DFAState, Set<DFAState>> result = new HashMap<DFAState, Set<DFAState>>();
        for (DFAState dFAState : this.getStates()) {
            HashSet<DFAState> cell = new HashSet<DFAState>();
            cell.add(dFAState);
            result.put(dFAState, cell);
        }
        for (Set set : equivalence) {
            Set s2Cell;
            assert (set.size() == 2);
            Iterator distIter = set.iterator();
            DFAState s1 = (DFAState)distIter.next();
            DFAState s2 = (DFAState)distIter.next();
            Set s1Cell = (Set)result.get(s1);
            if (s1Cell == (s2Cell = (Set)result.get(s2))) continue;
            s1Cell.addAll(s2Cell);
            for (DFAState s2Sib : s2Cell) {
                result.put(s2Sib, s1Cell);
            }
        }
        return result;
    }

    private DFA computeQuotient(Map<DFAState, Set<DFAState>> partition) {
        HashMap<Set<DFAState>, DFAState> newStateMap = new HashMap<Set<DFAState>, DFAState>();
        Set<DFAState> startCell = partition.remove(this.getStartState());
        Set<RegNode> startNodes = this.flatten(startCell);
        DFA result = new DFA(this.dir, startNodes, this.getStartState().isFinal());
        newStateMap.put(startCell, result.getStartState());
        for (Map.Entry<DFAState, Set<DFAState>> entry : partition.entrySet()) {
            Set<DFAState> cell = entry.getValue();
            if (newStateMap.containsKey(cell)) continue;
            newStateMap.put(cell, result.addState(this.flatten(cell), entry.getKey().isFinal()));
        }
        for (Map.Entry<DFAState, Set<DFAState>> entry : newStateMap.entrySet()) {
            DFAState oldState = (DFAState)((Set)((Object)entry.getKey())).iterator().next();
            DFAState newState = (DFAState)((Object)entry.getValue());
            Direction[] directionArray = Direction.values();
            int n = directionArray.length;
            int n2 = 0;
            while (n2 < n) {
                Direction dir = directionArray[n2];
                for (Map.Entry<TypeLabel, DFAState> entry2 : oldState.getLabelMap().get((Object)dir).entrySet()) {
                    DFAState newSucc = (DFAState)newStateMap.get(partition.get(entry2.getValue()));
                    newState.addSuccessor(dir, entry2.getKey(), newSucc);
                }
                ++n2;
            }
        }
        return result;
    }

    private Set<RegNode> flatten(Set<DFAState> stateSet) {
        HashSet<RegNode> result = new HashSet<RegNode>();
        for (DFAState state : stateSet) {
            result.addAll(state.getNodes());
        }
        return result;
    }
}

