/*
 * Decompiled with CFR 0.152.
 */
package groove.automaton;

import groove.automaton.DFA;
import groove.automaton.DFAState;
import groove.automaton.Direction;
import groove.automaton.RegAut;
import groove.grammar.host.HostEdge;
import groove.grammar.host.HostGraph;
import groove.grammar.host.HostNode;
import groove.grammar.host.HostNodeSet;
import groove.grammar.type.TypeLabel;
import groove.util.Pair;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class Recogniser {
    private final DFA aut;
    private final HostGraph graph;
    private final Map<Tuple, TupleSet> nextMap;
    private final Map<Tuple, HostNodeSet> reachMap;

    public Recogniser(DFA aut, HostGraph graph) {
        this.aut = aut;
        this.graph = graph;
        this.nextMap = new HashMap<Tuple, TupleSet>();
        this.reachMap = new HashMap<Tuple, HostNodeSet>();
    }

    public HostGraph getGraph() {
        return this.graph;
    }

    public Set<RegAut.Result> getMatches(HostNode from, HostNode to) {
        assert (to == null || from != null);
        HashSet<RegAut.Result> result = new HashSet<RegAut.Result>();
        if (from == null) {
            for (HostNode hn : this.graph.nodeSet()) {
                this.augmentReachMap(hn);
                this.addResults(result, hn);
            }
        } else {
            this.augmentReachMap(from);
            if (to == null) {
                this.addResults(result, from);
            } else if (this.getRelated(from).contains(to)) {
                result.add(this.createResult(from, to));
            }
        }
        return result;
    }

    private void augmentReachMap(HostNode fromNode) {
        Tuple from = this.createStartTuple(fromNode);
        HashSet<Tuple> fresh = new HashSet<Tuple>();
        HashMap<Tuple, TupleSet> predMap = new HashMap<Tuple, TupleSet>();
        fresh.add(from);
        predMap.put(from, new TupleSet());
        while (!fresh.isEmpty()) {
            Iterator pi = fresh.iterator();
            Tuple p = (Tuple)pi.next();
            pi.remove();
            if (this.reachMap.containsKey(p)) continue;
            for (Tuple np : this.getNext(p)) {
                TupleSet npPreds = (TupleSet)predMap.get(np);
                if (npPreds == null) {
                    fresh.add(np);
                    npPreds = new TupleSet();
                    predMap.put(np, npPreds);
                }
                npPreds.add(p);
            }
        }
        HashMap<Tuple, HostNodeSet> newReachMap = new HashMap<Tuple, HostNodeSet>();
        for (Tuple p : predMap.keySet()) {
            HostNodeSet ns = this.reachMap.get(p);
            if (ns == null) {
                ns = new HostNodeSet();
                this.reachMap.put(p, ns);
                if (((DFAState)p.two()).isFinal()) {
                    ns.add((HostNode)p.one());
                }
            }
            newReachMap.put(p, ns);
        }
        this.propagateBackwards(predMap, newReachMap);
    }

    private TupleSet getNext(Tuple from) {
        TupleSet result = this.nextMap.get(from);
        if (result == null) {
            result = new TupleSet();
            this.nextMap.put(from, result);
            HostNode fromNode = (HostNode)from.one();
            Map<Direction, Map<TypeLabel, DFAState>> succMaps = ((DFAState)from.two()).getLabelMap();
            DFAState ns = succMaps.get((Object)Direction.FORWARD).get(fromNode.getType().label());
            if (ns != null) {
                result.add(new Tuple(fromNode, ns));
            }
            Direction[] directionArray = Direction.values();
            int n = directionArray.length;
            int n2 = 0;
            while (n2 < n) {
                Direction d = directionArray[n2];
                Map<TypeLabel, DFAState> succMap = succMaps.get((Object)d);
                if (!succMap.isEmpty()) {
                    for (HostEdge hostEdge : d.edges(this.graph, fromNode)) {
                        DFAState s = succMap.get(hostEdge.label());
                        if (s == null) continue;
                        result.add(new Tuple(d.opposite(hostEdge), s));
                    }
                }
                ++n2;
            }
        }
        return result;
    }

    private void addResults(Set<RegAut.Result> result, HostNode from) {
        for (HostNode to : this.reachMap.get(this.createStartTuple(from))) {
            result.add(this.createResult(from, to));
        }
    }

    private HostNodeSet getRelated(HostNode from) {
        return this.reachMap.get(this.createStartTuple(from));
    }

    private void propagateBackwards(Map<Tuple, TupleSet> predMap, Map<Tuple, HostNodeSet> newReachMap) {
        while (!newReachMap.isEmpty()) {
            Iterator<Map.Entry<Tuple, HostNodeSet>> newReachIter = newReachMap.entrySet().iterator();
            Map.Entry<Tuple, HostNodeSet> newReachEntry = newReachIter.next();
            newReachIter.remove();
            HostNodeSet toSet = newReachEntry.getValue();
            for (Tuple tp : predMap.get(newReachEntry.getKey())) {
                boolean tpFresh;
                HostNodeSet tpToSet = newReachMap.get(tp);
                boolean bl = tpFresh = tpToSet == null;
                if (tpFresh) {
                    tpToSet = new HostNodeSet();
                }
                for (HostNode hn : toSet) {
                    if (!this.reachMap.get(tp).add(hn)) continue;
                    tpToSet.add(hn);
                }
                if (!tpFresh || tpToSet.isEmpty()) continue;
                newReachMap.put(tp, tpToSet);
            }
        }
    }

    private Tuple createStartTuple(HostNode node) {
        return new Tuple(node, this.aut.getStartState());
    }

    private RegAut.Result createResult(HostNode from, HostNode to) {
        return this.aut.getDirection() == Direction.FORWARD ? new RegAut.Result(from, to) : new RegAut.Result(to, from);
    }

    private static class Tuple
    extends Pair<HostNode, DFAState> {
        public Tuple(HostNode node, DFAState state) {
            super(node, state);
        }
    }

    private static class TupleSet
    extends HashSet<Tuple> {
        private TupleSet() {
        }
    }
}

