/*
 * Decompiled with CFR 0.152.
 */
package groove.automaton;

import groove.automaton.NodeRelation;
import groove.automaton.RegExpr;
import groove.automaton.RegExprCalculator;
import groove.graph.Edge;
import groove.graph.Graph;
import groove.graph.Node;
import groove.lts.GTS;
import groove.lts.GTSAdapter;
import groove.lts.GraphTransition;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RelationCalculator
extends GTSAdapter
implements RegExprCalculator<NodeRelation> {
    private Map<String, Set<Edge>> labelEdgeMap;
    private final Graph graph;
    private final NodeRelation factory;

    public RelationCalculator(Graph graph, NodeRelation factory) {
        this.factory = factory;
        this.graph = graph;
    }

    @Override
    public NodeRelation computeAtom(RegExpr.Atom expr) {
        return this.createRelation(expr.text());
    }

    @Override
    public NodeRelation computeChoice(RegExpr.Choice expr, List<NodeRelation> args) {
        Iterator<NodeRelation> argsIter = args.iterator();
        NodeRelation result = argsIter.next();
        while (argsIter.hasNext()) {
            NodeRelation operand = argsIter.next();
            result.doOr(operand);
        }
        return result;
    }

    @Override
    public NodeRelation computeEmpty(RegExpr.Empty expr) {
        NodeRelation result = this.getFactory().newInstance();
        for (Node node : this.graph.nodeSet()) {
            result.addSelfRelated(node);
        }
        return result;
    }

    @Override
    public NodeRelation computeInv(RegExpr.Inv expr, NodeRelation arg) {
        arg.doInverse();
        return arg;
    }

    @Override
    public NodeRelation computeNeg(RegExpr.Neg expr, NodeRelation arg) {
        throw new UnsupportedOperationException();
    }

    @Override
    public NodeRelation computePlus(RegExpr.Plus expr, NodeRelation arg) {
        arg.doTransitiveClosure();
        return arg;
    }

    @Override
    public NodeRelation computeSeq(RegExpr.Seq expr, List<NodeRelation> argList) {
        Iterator<NodeRelation> argsIter = argList.iterator();
        NodeRelation result = argsIter.next();
        while (argsIter.hasNext()) {
            NodeRelation operand = argsIter.next();
            result.doThen(operand);
        }
        return result;
    }

    @Override
    public NodeRelation computeStar(RegExpr.Star expr, NodeRelation arg) {
        arg.doTransitiveClosure();
        for (Node node : this.graph.nodeSet()) {
            arg.addSelfRelated(node);
        }
        return arg;
    }

    @Override
    public NodeRelation computeSharp(RegExpr.Sharp expr) {
        return this.createRelation(expr.getAtomText());
    }

    @Override
    public NodeRelation computeWildcard(RegExpr.Wildcard expr) {
        NodeRelation result = this.getFactory().newInstance();
        for (Edge edge : this.graph.edgeSet()) {
            result.addRelated(edge);
        }
        return result;
    }

    public Graph getGraph() {
        return this.graph;
    }

    public NodeRelation getFactory() {
        return this.factory;
    }

    @Override
    public void addUpdate(GTS gts, GraphTransition transition) {
        if (this.labelEdgeMap != null) {
            this.addToLabelEdgeMap(transition, this.labelEdgeMap);
        }
    }

    public void startListening() {
        if (this.graph instanceof GTS) {
            ((GTS)this.graph).addLTSListener(this);
        }
    }

    public void stopListening() {
        if (this.graph instanceof GTS) {
            ((GTS)this.graph).removeLTSListener(this);
        }
    }

    private NodeRelation createRelation(String text) {
        NodeRelation result = this.getFactory().newInstance();
        Set<Edge> edges = this.getEdgeSet(text);
        if (edges != null) {
            for (Edge edge : edges) {
                result.addRelated(edge);
            }
        }
        return result;
    }

    private Set<Edge> getEdgeSet(String text) {
        if (this.labelEdgeMap == null) {
            this.labelEdgeMap = this.computeLabelEdgeMap();
        }
        return this.labelEdgeMap.get(text);
    }

    private Map<String, Set<Edge>> computeLabelEdgeMap() {
        HashMap<String, Set<Edge>> result = new HashMap<String, Set<Edge>>();
        for (Edge edge : this.graph.edgeSet()) {
            this.addToLabelEdgeMap(edge, result);
        }
        return result;
    }

    private void addToLabelEdgeMap(Edge edge, Map<String, Set<Edge>> result) {
        String text = edge.label().text();
        Set<Edge> edges = result.get(text);
        if (edges == null) {
            edges = new HashSet<Edge>();
            result.put(text, edges);
        }
        edges.add(edge);
    }
}

