/*
 * Decompiled with CFR 0.152.
 */
package groove.control;

import groove.algebra.AlgebraFamily;
import groove.control.CtrlAut;
import groove.control.CtrlCall;
import groove.control.CtrlGuard;
import groove.control.CtrlLabel;
import groove.control.CtrlMorphism;
import groove.control.CtrlPar;
import groove.control.CtrlState;
import groove.control.CtrlTransition;
import groove.control.CtrlType;
import groove.control.parse.Namespace;
import groove.grammar.Action;
import groove.grammar.Recipe;
import groove.grammar.Rule;
import groove.grammar.model.FormatErrorSet;
import groove.grammar.model.FormatException;
import groove.graph.GraphInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class CtrlFactory {
    private static final CtrlFactory INSTANCE = new CtrlFactory();
    private static final CtrlGuard EMPTY_GUARD = new CtrlGuard();

    private CtrlFactory() {
    }

    public CtrlAut buildAlap(CtrlAut aut) {
        return this.buildLoop(aut, aut.getInitGuard());
    }

    public CtrlAut buildStar(CtrlAut aut) {
        return this.buildLoop(aut, EMPTY_GUARD);
    }

    public CtrlAut buildCall(CtrlCall call, Namespace namespace) {
        if (call.getKind() == CtrlCall.Kind.RULE) {
            return this.buildRuleCall(call);
        }
        assert (!call.isOmega());
        return this.buildBodyCall(call, namespace);
    }

    private CtrlAut buildRuleCall(CtrlCall call) {
        CtrlAut result = this.createCtrlAut(call.getName());
        CtrlState middle = result.addState();
        result.getStart().addTransition(this.createLabel(call), middle);
        middle.addTransition(this.createOmegaLabel(), result.getFinal());
        return result;
    }

    private CtrlAut buildBodyCall(CtrlCall call, Namespace namespace) {
        CtrlAut body = namespace.getBody(call.getName());
        assert (call.getArgs() == null || call.getArgs().isEmpty()) : "Function and recipe parameters not yet implemented";
        return body.clone(call.getKind() == CtrlCall.Kind.RECIPE ? namespace.getRecipe(call.getName()) : null);
    }

    public CtrlAut buildDoUntil(CtrlAut first, CtrlAut second) {
        this.buildUntilDo(second, first);
        return this.buildSeq(first, second);
    }

    public CtrlAut buildDoWhile(CtrlAut first, CtrlAut second) {
        this.buildWhileDo(second, first);
        return this.buildSeq(first, second);
    }

    public CtrlAut buildIfThenElse(CtrlAut first, CtrlAut second, CtrlAut third) {
        CtrlGuard guard = first.getInitGuard();
        this.buildSeq(first, second);
        if (third == null) {
            third = this.buildTrue();
        }
        return this.buildOr(first, third, guard);
    }

    public CtrlAut buildAny(Namespace namespace) {
        return this.buildGroupCall(namespace.getTopNames(), namespace);
    }

    public CtrlAut buildOther(Namespace namespace) {
        HashSet<String> unusedRules = new HashSet<String>(namespace.getTopNames());
        unusedRules.removeAll(namespace.getUsedNames());
        return this.buildGroupCall(unusedRules, namespace);
    }

    private CtrlAut buildGroupCall(Set<String> ruleNames, Namespace namespace) {
        CtrlAut result = null;
        for (String ruleName : ruleNames) {
            CtrlCall call;
            switch (namespace.getKind(ruleName)) {
                case RULE: {
                    call = new CtrlCall(namespace.getRule(ruleName), null);
                    break;
                }
                case RECIPE: {
                    call = new CtrlCall(CtrlCall.Kind.RECIPE, ruleName, null);
                    break;
                }
                default: {
                    call = null;
                    assert (false);
                    break;
                }
            }
            CtrlAut callAut = this.buildCall(call, namespace);
            result = result == null ? callAut : this.buildOr(result, callAut);
        }
        if (result == null) {
            result = this.buildTrue();
        }
        return result;
    }

    public CtrlAut buildSeq(CtrlAut first, CtrlAut second) {
        CtrlMorphism secondToFirstMap = this.copyStates(second, first, false);
        Set<CtrlTransition> firstOmega = this.removeOmegas(first);
        for (CtrlState state : second.nodeSet()) {
            if (state.equals(second.getStart())) {
                HashMap<CtrlState, CtrlState> stateMap = new HashMap<CtrlState, CtrlState>(secondToFirstMap.nodeMap());
                for (CtrlTransition omega : firstOmega) {
                    stateMap.put(state, (CtrlState)omega.source());
                    state.copyTransitions(stateMap, omega.getGuard());
                }
                continue;
            }
            state.copyTransitions(secondToFirstMap.nodeMap(), null);
        }
        first.addErrors(second);
        return first;
    }

    public CtrlAut buildOr(CtrlAut first, CtrlAut second) {
        return this.buildOr(first, second, EMPTY_GUARD);
    }

    public CtrlAut buildTrue() {
        CtrlAut result = this.createCtrlAut("true");
        return this.addOmega(result);
    }

    public CtrlAut addOmega(CtrlAut result) {
        result.getStart().addTransition(this.createOmegaLabel(), result.getFinal());
        return result;
    }

    public CtrlAut buildTryElse(CtrlAut first, CtrlAut second) {
        if (second == null) {
            second = this.buildTrue();
        }
        return this.buildOr(first, second, first.getInitGuard());
    }

    public CtrlAut buildUntilDo(CtrlAut first, CtrlAut second) {
        CtrlGuard firstGuard = first.getInitGuard();
        if (firstGuard != null) {
            Set<CtrlTransition> firstOmega = this.removeOmegas(first);
            this.buildOr(first, second, firstGuard);
            this.buildLoop(first, null);
            for (CtrlTransition omega : firstOmega) {
                ((CtrlState)omega.source()).addTransition((CtrlLabel)omega.label(), (CtrlState)omega.target());
            }
        }
        return first;
    }

    public CtrlAut buildWhileDo(CtrlAut first, CtrlAut second) {
        CtrlGuard firstGuard = first.getInitGuard();
        this.buildSeq(first, second);
        return this.buildLoop(first, firstGuard);
    }

    private CtrlAut buildLoop(CtrlAut aut, CtrlGuard guard) {
        Set<CtrlTransition> omegas = this.removeOmegas(aut);
        HashMap<CtrlState, CtrlState> id = new HashMap<CtrlState, CtrlState>();
        for (CtrlState state : aut.nodeSet()) {
            id.put(state, state);
        }
        if (guard != null) {
            CtrlLabel newLabel = this.createLabel(CtrlCall.OMEGA, guard);
            aut.getStart().addTransition(newLabel, aut.getFinal());
        }
        for (CtrlTransition omega : omegas) {
            id.put(aut.getStart(), (CtrlState)omega.source());
            aut.getStart().copyTransitions(id, omega.getGuard());
        }
        return aut;
    }

    private CtrlAut buildOr(CtrlAut first, CtrlAut second, CtrlGuard guard) {
        if (guard != null) {
            CtrlMorphism secondToFirstMap = this.copyStates(second, first, true);
            Map<CtrlState, CtrlState> stateMap = secondToFirstMap.nodeMap();
            for (CtrlState state : second.nodeSet()) {
                if (state.isOmegaOnly() && ((CtrlState)stateMap.get(state)).isOmegaOnly()) continue;
                boolean isInit = state.equals(second.getStart());
                state.copyTransitions(stateMap, isInit ? guard : null);
            }
        }
        first.addErrors(second);
        return first;
    }

    private CtrlMorphism copyStates(CtrlAut fromAut, CtrlAut toAut, boolean shareOmegaOnlyState) {
        CtrlMorphism secondToFirstMap = new CtrlMorphism();
        CtrlState toAutOmegaOnlyState = toAut.getOmegaOnlyState();
        for (CtrlState state : fromAut.nodeSet()) {
            CtrlState image = state.equals(fromAut.getStart()) ? toAut.getStart() : (state.equals(fromAut.getFinal()) ? toAut.getFinal() : (shareOmegaOnlyState && state.isOmegaOnly() && toAutOmegaOnlyState != null ? toAutOmegaOnlyState : toAut.addState(state, null)));
            secondToFirstMap.putNode(state, image);
        }
        return secondToFirstMap;
    }

    private Set<CtrlTransition> removeOmegas(CtrlAut aut) {
        HashSet<CtrlTransition> omegas = new HashSet<CtrlTransition>(aut.getOmegas());
        for (CtrlTransition o : omegas) {
            ((CtrlState)o.source()).removeOmega(o);
        }
        return omegas;
    }

    private CtrlLabel createLabel(CtrlCall call) {
        return this.createLabel(call, EMPTY_GUARD);
    }

    private CtrlLabel createLabel(CtrlCall call, CtrlGuard guard) {
        return new CtrlLabel(call, guard, true);
    }

    private CtrlLabel createOmegaLabel() {
        return this.createLabel(CtrlCall.OMEGA);
    }

    public CtrlAut buildDefault(Collection<? extends Action> actions, boolean symbolic) throws FormatException {
        CtrlAut result = new CtrlAut("control");
        FormatErrorSet errors = new FormatErrorSet();
        TreeMap<Integer, HashSet<Action>> priorityMap = new TreeMap<Integer, HashSet<Action>>();
        Namespace namespace = new Namespace();
        for (Action action : actions) {
            boolean needsInput = false;
            for (CtrlPar.Var var : action.getSignature()) {
                if (!var.isInOnly() || var.getType() != CtrlType.NODE && symbolic) continue;
                needsInput = true;
                break;
            }
            if (needsInput) {
                errors.add("Error in %s %s: input parameters require explicit control (use %s algebra for symbolic exploration)", new Object[]{action.getKind(), action.getFullName(), AlgebraFamily.POINT.getName(), action});
                continue;
            }
            switch (action.getKind()) {
                case RULE: {
                    namespace.addRule((Rule)action);
                    break;
                }
                case RECIPE: {
                    Recipe recipe = (Recipe)action;
                    namespace.addRecipe(action.getFullName(), action.getPriority(), action.getSignature(), recipe.getControlName(), recipe.getStartLine());
                    namespace.addBody(action.getFullName(), recipe.getBody());
                }
            }
            int priority = action.getPriority();
            HashSet<Action> priorityActions = (HashSet<Action>)priorityMap.get(priority);
            if (priorityActions == null) {
                priorityActions = new HashSet<Action>();
                priorityMap.put(priority, priorityActions);
            }
            priorityActions.add(action);
        }
        if (!errors.isEmpty()) {
            GraphInfo.addErrors(result, errors);
        }
        ArrayList<CtrlAut> arrayList = new ArrayList<CtrlAut>();
        for (Set priorityActions : priorityMap.values()) {
            HashSet<String> actionNames = new HashSet<String>();
            for (Action action : priorityActions) {
                actionNames.add(action.getFullName());
            }
            arrayList.add(this.buildGroupCall(actionNames, namespace));
        }
        if (arrayList.isEmpty()) {
            this.addOmega(result);
        } else {
            ListIterator levelIter = arrayList.listIterator(arrayList.size());
            while (levelIter.hasPrevious()) {
                result = this.buildTryElse(result, (CtrlAut)levelIter.previous());
            }
            result = this.buildAlap(result);
        }
        GraphInfo.throwException(result);
        result = result.normalise();
        result.setDefault();
        return result;
    }

    private CtrlAut createCtrlAut(String name) {
        return new CtrlAut(name);
    }

    public static CtrlFactory instance() {
        return INSTANCE;
    }
}

