/*
 * Decompiled with CFR 0.152.
 */
package groove.control;

import groove.control.CtrlCall;
import groove.control.CtrlState;
import groove.control.CtrlTransition;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CtrlSchedule {
    private final CtrlState state;
    private final List<CtrlTransition> transitions;
    private final Set<CtrlTransition> triedTransitions;
    private final Set<CtrlCall> triedCalls;
    private final Set<String> triedRules;
    private final boolean tried;
    private CtrlSchedule succNext;
    private CtrlSchedule failNext;
    private final boolean success;
    private final boolean isTransient;
    private CtrlSchedule triedSchedule;

    public CtrlSchedule(CtrlState state, List<CtrlTransition> trans, Set<CtrlTransition> previous, boolean success, boolean isTransient) {
        this.state = state;
        this.transitions = trans;
        this.triedCalls = new HashSet<CtrlCall>();
        this.triedRules = new HashSet<String>();
        this.triedTransitions = new HashSet<CtrlTransition>();
        for (CtrlTransition t : previous) {
            CtrlCall call = t.getCall();
            this.triedCalls.add(call);
            this.triedRules.add(call.getRule().getFullName());
            this.triedTransitions.add(t);
        }
        this.success = success;
        assert (!isTransient || state.isTransient());
        this.isTransient = isTransient;
        this.tried = false;
    }

    private CtrlSchedule(CtrlSchedule origin) {
        this.state = origin.state;
        this.transitions = origin.transitions;
        HashSet<CtrlCall> triedCalls = new HashSet<CtrlCall>();
        HashSet<CtrlTransition> triedTransitions = new HashSet<CtrlTransition>();
        HashSet<String> triedRules = new HashSet<String>();
        for (CtrlTransition t : this.transitions) {
            CtrlCall call = t.getCall();
            triedCalls.addAll(origin.triedCalls);
            triedCalls.add(call);
            triedTransitions.addAll(origin.triedTransitions);
            triedTransitions.add(t);
            triedRules.addAll(origin.triedRules);
            triedRules.add(call.getRule().getFullName());
        }
        this.triedCalls = triedCalls;
        this.triedTransitions = triedTransitions;
        this.triedRules = triedRules;
        this.success = origin.success;
        this.isTransient = origin.isTransient;
        this.tried = true;
        this.succNext = origin.succNext;
        this.failNext = origin.failNext;
        this.triedSchedule = this;
    }

    public boolean isInitial() {
        return this == this.state.getSchedule();
    }

    public boolean isFinished() {
        return this.transitions == null;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    public boolean isTried() {
        return this.tried;
    }

    public CtrlSchedule toTriedSchedule() {
        if (this.triedSchedule == null) {
            this.triedSchedule = new CtrlSchedule(this);
        }
        return this.triedSchedule;
    }

    public List<CtrlTransition> getTransitions() {
        return this.transitions;
    }

    public final CtrlState getState() {
        return this.state;
    }

    public Set<CtrlCall> getTriedCalls() {
        return this.triedCalls;
    }

    public Set<String> getTriedRules() {
        return this.triedRules;
    }

    public Set<CtrlTransition> getTriedTransitions() {
        return this.triedTransitions;
    }

    public void setNext(CtrlSchedule success, CtrlSchedule failure) {
        this.succNext = success;
        this.failNext = failure;
    }

    public CtrlSchedule next(boolean success) {
        return success ? this.succNext : this.failNext;
    }

    public String toString() {
        return this.toString(0, "");
    }

    private String toString(int depth, String prefix) {
        StringBuilder result = new StringBuilder();
        StringBuilder spaces = new StringBuilder();
        int i = 0;
        while (i <= depth) {
            spaces.append("    ");
            ++i;
        }
        result.append((CharSequence)spaces);
        result.append(prefix);
        if (this.transitions == null) {
            result.append("No transitions");
            if (this.isSuccess()) {
                result.append("; success");
            }
            result.append("\n");
        } else {
            boolean first = true;
            for (CtrlTransition t : this.getTransitions()) {
                if (first) {
                    first = false;
                } else {
                    result.append('\n');
                    result.append((CharSequence)spaces);
                }
                result.append("Call ");
                result.append(t);
                if (t.getParBinding().length > 0) {
                    result.append(", parameter binding: ");
                    result.append(Arrays.toString(t.getParBinding()));
                }
                if (t.getTargetVarBinding().length <= 0) continue;
                result.append(", target variable binding: ");
                result.append(Arrays.toString(t.getTargetVarBinding()));
            }
            if (this.isSuccess()) {
                result.append("; success");
            }
            if (this.isTransient()) {
                result.append("; transient");
            }
            result.append("\n");
            if (this.succNext == this.failNext) {
                if (!this.succNext.isFinished() || this.succNext.isSuccess()) {
                    result.append(this.succNext.toString(depth + 1, ""));
                }
            } else {
                if (!this.failNext.isFinished() || this.failNext.isSuccess()) {
                    result.append(this.failNext.toString(depth + 1, "Failed:  "));
                }
                if (!this.succNext.isFinished() || this.succNext.isSuccess()) {
                    result.append(this.succNext.toString(depth + 1, "Applied: "));
                }
            }
        }
        return result.toString();
    }
}

