/*
 * Decompiled with CFR 0.152.
 */
package groove.control;

import groove.control.CtrlCall;
import groove.control.CtrlGuard;
import groove.control.CtrlLabel;
import groove.control.CtrlPar;
import groove.control.CtrlState;
import groove.control.CtrlVar;
import groove.grammar.Recipe;
import groove.grammar.Rule;
import groove.graph.AEdge;
import groove.graph.Label;
import java.util.List;
import java.util.Set;

public class CtrlTransition
extends AEdge<CtrlState, CtrlLabel>
implements Comparable<CtrlTransition> {
    private int[] targetVarBinding;
    private int[] parBinding;
    private final CtrlCall call = ((CtrlLabel)this.label()).getCall();
    private final CtrlGuard guard = ((CtrlLabel)this.label()).getGuard();
    private final Recipe recipe = ((CtrlLabel)this.label()).getRecipe();
    private final boolean start = ((CtrlLabel)this.label()).isStart();
    private final int number = ((CtrlLabel)this.label()).getNumber();
    private static final int[] EMPTY_BINDING = new int[0];

    public CtrlTransition(CtrlState source, CtrlLabel label, CtrlState target) {
        super(source, label.newLabel(source.getTransitions().size()), target);
        assert (source.getAut() == target.getAut());
        assert (this.guardsCorrect());
    }

    @Override
    public int compareTo(CtrlTransition o) {
        assert (this.source() == o.source());
        int result = ((CtrlLabel)this.label()).compareTo((Label)o.label());
        if (result == 0) {
            result = ((CtrlState)this.target()).getNumber() - ((CtrlState)o.target()).getNumber();
        }
        return result;
    }

    private boolean guardsCorrect() {
        boolean result = true;
        for (CtrlTransition t : this.getGuard()) {
            if (((CtrlState)t.source()).equals(this.source())) continue;
            result = false;
            break;
        }
        return result;
    }

    public int[] getTargetVarBinding() {
        if (this.targetVarBinding == null) {
            this.targetVarBinding = this.computeTargetVarBinding();
        }
        return this.targetVarBinding;
    }

    private int[] computeTargetVarBinding() {
        int[] result;
        List<CtrlVar> targetVars = ((CtrlState)this.target()).getBoundVars();
        int targetVarCount = targetVars.size();
        if (targetVarCount == 0) {
            result = EMPTY_BINDING;
        } else {
            result = new int[targetVarCount];
            List<CtrlVar> sourceVars = ((CtrlState)this.source()).getBoundVars();
            int sourceVarCount = sourceVars.size();
            int i = 0;
            while (i < targetVarCount) {
                CtrlVar targetVar = targetVars.get(i);
                int index = sourceVars.indexOf(targetVar);
                if (index < 0) {
                    assert (this.getOutVars().contains(targetVar)) : String.format("Neither source vars %s nor out-parameters %s contain variable %s", sourceVars, this.getOutVars(), targetVar);
                    index = this.getCall().getOutVars().get(targetVar) + sourceVarCount;
                }
                result[i] = index;
                ++i;
            }
        }
        return result;
    }

    public int[] getParBinding() {
        if (this.parBinding == null) {
            this.parBinding = this.computeParBinding();
        }
        return this.parBinding;
    }

    private int[] computeParBinding() {
        List<CtrlPar> args = this.getCall().getArgs();
        int size = args == null ? 0 : args.size();
        int[] result = new int[size];
        List<CtrlVar> sourceVars = ((CtrlState)this.source()).getBoundVars();
        int i = 0;
        while (i < size) {
            CtrlPar arg = args.get(i);
            if (arg instanceof CtrlPar.Var) {
                CtrlPar.Var varArg = (CtrlPar.Var)arg;
                if (arg.isInOnly()) {
                    int index = sourceVars.indexOf(varArg.getVar());
                    assert (index >= 0);
                    result[i] = index;
                } else if (arg.isOutOnly()) {
                    result[i] = this.getRule().getParBinding(i);
                } else {
                    assert (arg.isDontCare());
                    result[i] = -1;
                }
            }
            ++i;
        }
        return result;
    }

    public Set<CtrlVar> getInVars() {
        return this.getCall().getInVars().keySet();
    }

    public boolean hasOutVars() {
        return !this.getCall().getOutVars().isEmpty();
    }

    public Set<CtrlVar> getOutVars() {
        return this.getCall().getOutVars().keySet();
    }

    public boolean isModifying() {
        return this.source() != this.target() || this.hasOutVars();
    }

    public final CtrlCall getCall() {
        return this.call;
    }

    public CtrlGuard getGuard() {
        return this.guard;
    }

    public Rule getRule() {
        return this.getCall().getRule();
    }

    public boolean isStart() {
        return this.start;
    }

    public Recipe getRecipe() {
        return this.recipe;
    }

    public boolean hasRecipe() {
        return this.getRecipe() != null;
    }

    public int getNumber() {
        return this.number;
    }
}

