/*
 * Decompiled with CFR 0.152.
 */
package groove.control.parse;

import groove.control.CtrlAut;
import groove.control.CtrlCall;
import groove.control.CtrlPar;
import groove.grammar.Action;
import groove.grammar.QualName;
import groove.grammar.Recipe;
import groove.grammar.Rule;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Namespace {
    private String fullName;
    private String parentName;
    private final Map<String, List<CtrlPar.Var>> sigMap = new HashMap<String, List<CtrlPar.Var>>();
    private final Map<String, CtrlCall.Kind> kindMap = new HashMap<String, CtrlCall.Kind>();
    private final Map<String, Rule> ruleMap = new HashMap<String, Rule>();
    private final Map<String, CtrlAut> bodyMap = new HashMap<String, CtrlAut>();
    private final Map<String, Recipe> recipeMap = new HashMap<String, Recipe>();
    private final Set<String> allNames = new HashSet<String>();
    private final Set<String> usedNames = new HashSet<String>();

    public boolean addFunction(String name, List<CtrlPar.Var> sig) {
        boolean result;
        boolean bl = result = !this.kindMap.containsKey(name);
        if (result) {
            this.kindMap.put(name, CtrlCall.Kind.FUNCTION);
            this.sigMap.put(name, sig);
        }
        return result;
    }

    public boolean addRecipe(String name, int priority, List<CtrlPar.Var> sig, String controlName, int startLine) {
        boolean result;
        boolean bl = result = !this.kindMap.containsKey(name);
        if (result) {
            this.kindMap.put(name, CtrlCall.Kind.RECIPE);
            this.sigMap.put(name, sig);
            this.allNames.add(name);
            this.recipeMap.put(name, new Recipe(name, priority, sig, controlName, startLine));
        }
        return result;
    }

    public boolean addRule(Rule rule) {
        boolean result;
        String ruleName = rule.getFullName();
        boolean bl = result = !this.kindMap.containsKey(ruleName);
        if (result) {
            this.kindMap.put(ruleName, CtrlCall.Kind.RULE);
            this.ruleMap.put(ruleName, rule);
            this.allNames.add(ruleName);
            this.sigMap.put(ruleName, rule.getSignature());
        }
        return result;
    }

    public void addBody(String name, CtrlAut body) {
        assert (this.hasName(name) && this.getKind(name).hasBody()) : String.format("Unknown or inappropriate name %s", name);
        if (this.getKind(name) == CtrlCall.Kind.RECIPE) {
            body = body.clone(this.getRecipe(name));
            for (Rule rule : body.getRules()) {
                this.allNames.remove(rule.getFullName());
            }
            this.getRecipe(name).setBody(body);
        }
        this.bodyMap.put(name, body);
    }

    public Set<String> getNames() {
        return this.kindMap.keySet();
    }

    public boolean hasName(String name) {
        return this.getKind(name) != null;
    }

    public CtrlCall.Kind getKind(String name) {
        return this.kindMap.get(name);
    }

    public CtrlAut getBody(String name) {
        assert (this.hasName(name) && this.getKind(name).hasBody()) : String.format("Unknown or inappropriate name %s", name);
        CtrlAut result = this.bodyMap.get(name);
        return result;
    }

    public Rule getRule(String name) {
        return this.ruleMap.get(name);
    }

    public Set<String> getTopNames() {
        return this.allNames;
    }

    public void useName(String name) {
        assert (this.getKind(name) != CtrlCall.Kind.OMEGA);
        this.usedNames.add(name);
    }

    public Set<String> getUsedNames() {
        return this.usedNames;
    }

    public List<CtrlPar.Var> getSig(String name) {
        return this.sigMap.get(name);
    }

    public Recipe getRecipe(String name) {
        return this.recipeMap.get(name);
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
        this.parentName = QualName.getParent(fullName);
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getParentName() {
        return this.parentName;
    }

    public Collection<Action> getActions() {
        HashSet<Action> result = new HashSet<Action>();
        result.addAll(this.ruleMap.values());
        for (Recipe recipe : this.recipeMap.values()) {
            result.add(recipe);
            result.removeAll(recipe.getRules());
        }
        return result;
    }

    public Collection<Recipe> getRecipes() {
        return this.recipeMap.values();
    }

    public String toString() {
        return String.format("Namespace for %s, defining %s", this.getFullName(), this.allNames);
    }
}

