/*
 * Decompiled with CFR 0.152.
 */
package groove.explore;

import groove.explore.AcceptorEnumerator;
import groove.explore.AcceptorValue;
import groove.explore.StrategyEnumerator;
import groove.explore.StrategyValue;
import groove.explore.encode.Serialized;
import groove.explore.result.Acceptor;
import groove.explore.result.CycleAcceptor;
import groove.explore.result.Result;
import groove.explore.strategy.LTLStrategy;
import groove.explore.strategy.Strategy;
import groove.grammar.Grammar;
import groove.grammar.model.FormatErrorSet;
import groove.grammar.model.FormatException;
import groove.lts.GTS;
import groove.lts.GraphState;
import groove.util.Reporter;

public class Exploration {
    private final Serialized strategy;
    private final Serialized acceptor;
    private final int nrResults;
    private Result lastResult;
    private String lastMessage;
    private GraphState lastState;
    private boolean interrupted;
    public static final String SYNTAX_MESSAGE = "Exploration syntax: \"<strategy> <acceptor> [<resultcount>]\"";
    private static final StrategyEnumerator strategies = StrategyEnumerator.newInstance();
    private static final AcceptorEnumerator acceptors = AcceptorEnumerator.newInstance();
    private static final Reporter reporter = Reporter.register(Exploration.class);
    static final Reporter playReporter = reporter.register("playScenario()");

    public Exploration(Serialized strategy, Serialized acceptor, int nrResults) {
        this.strategy = strategy;
        this.acceptor = acceptor;
        this.nrResults = nrResults;
        this.lastResult = new Result(0);
    }

    public Exploration(String strategy, String acceptor, int nrResults) {
        this(new Serialized(strategy), new Serialized(acceptor), nrResults);
    }

    public Exploration(StrategyValue strategy, AcceptorValue acceptor, int nrResults) {
        this(strategy.toSerialized(), acceptor.toSerialized(), nrResults);
    }

    public Exploration() {
        this("bfs", "final", 0);
    }

    public Serialized getStrategy() {
        return this.strategy;
    }

    public Strategy getParsedStrategy(Grammar grammar) throws FormatException {
        return StrategyEnumerator.parseStrategy(grammar, this.strategy);
    }

    public Serialized getAcceptor() {
        return this.acceptor;
    }

    public Acceptor getParsedAcceptor(Grammar grammar) throws FormatException {
        if (this.getParsedStrategy(grammar) instanceof LTLStrategy) {
            return new CycleAcceptor();
        }
        return AcceptorEnumerator.parseAcceptor(grammar, this.acceptor);
    }

    public int getNrResults() {
        return this.nrResults;
    }

    public Result getLastResult() {
        return this.lastResult;
    }

    public GraphState getLastState() {
        return this.lastState;
    }

    public String getLastMessage() {
        return this.lastMessage;
    }

    public boolean isInterrupted() {
        return this.interrupted;
    }

    public String getIdentifier() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("");
        buffer.append(this.strategy.toString());
        buffer.append(" / ");
        buffer.append(this.acceptor.toString());
        buffer.append(" / ");
        if (this.nrResults == 0) {
            buffer.append("infinite");
        } else {
            buffer.append(this.nrResults);
        }
        return buffer.toString();
    }

    public void test(Grammar grammar) throws FormatException {
        FormatErrorSet errors = new FormatErrorSet();
        try {
            this.getParsedStrategy(grammar);
        }
        catch (FormatException exc) {
            errors.addAll(exc.getErrors());
        }
        try {
            this.getParsedAcceptor(grammar);
        }
        catch (FormatException exc) {
            errors.addAll(exc.getErrors());
        }
        errors.throwException();
    }

    public final void play(GTS gts, GraphState state) throws FormatException {
        Grammar grammar = gts.getGrammar();
        Strategy parsedStrategy = this.getParsedStrategy(grammar);
        final Acceptor parsedAcceptor = this.getParsedAcceptor(grammar);
        parsedAcceptor.setResult(new Result(this.nrResults));
        parsedStrategy.setGTS(gts);
        parsedStrategy.setState(state);
        playReporter.start();
        parsedStrategy.setAcceptor(parsedAcceptor);
        parsedStrategy.play(new Strategy.Halter(){

            @Override
            public boolean halt() {
                return parsedAcceptor.getResult().done();
            }
        });
        this.interrupted = parsedStrategy.isInterrupted();
        playReporter.stop();
        this.lastResult = parsedAcceptor.getResult();
        this.lastState = parsedStrategy.getLastState();
        this.lastMessage = parsedStrategy.getMessage();
    }

    public String toParsableString() {
        String result = String.valueOf(this.strategy.toParsableString()) + " " + this.acceptor.toParsableString() + " " + this.nrResults;
        return result;
    }

    public String toString() {
        return this.toParsableString();
    }

    public static Exploration parse(String description) throws FormatException {
        String[] parts = description.split("\\s");
        if (parts.length < 2 || parts.length > 3) {
            throw new FormatException(SYNTAX_MESSAGE, new Object[0]);
        }
        Serialized strategy = strategies.parseCommandline(parts[0]);
        if (strategy == null) {
            throw new FormatException("Unknown strategy '%s'", parts[0]);
        }
        Serialized acceptor = acceptors.parseCommandline(parts[1]);
        if (acceptor == null) {
            throw new FormatException("Unknown acceptor '%s'", parts[1]);
        }
        int resultCount = 0;
        if (parts.length == 3) {
            String countMessage = String.format("Result count '%s' must be a non-negative number", parts[2]);
            try {
                resultCount = Integer.parseInt(parts[2]);
            }
            catch (NumberFormatException numberFormatException) {
                throw new FormatException(countMessage, new Object[0]);
            }
            if (resultCount < 0) {
                throw new FormatException(countMessage, new Object[0]);
            }
        }
        return new Exploration(strategy, acceptor, resultCount);
    }

    public static long getRunningTime() {
        return playReporter.getTotalTime();
    }
}

