/*
 * Decompiled with CFR 0.152.
 */
package groove.explore.encode;

import groove.explore.encode.EncodedType;
import groove.explore.encode.EncodedTypeEditor;
import groove.grammar.model.GrammarModel;
import groove.gui.dialog.ExplorationDialog;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.JComboBox;

public abstract class EncodedEnumeratedType<A>
implements EncodedType<A, String> {
    @Override
    public EncodedTypeEditor<A, String> createEditor(GrammarModel grammar) {
        return new EnumeratedEditor(grammar, this.generateOptions(grammar));
    }

    public abstract Map<String, String> generateOptions(GrammarModel var1);

    private class EnumeratedEditor<X>
    extends EncodedTypeEditor<X, String> {
        private final JComboBox selector;
        private String[] keys;
        private int nrKeys;

        public EnumeratedEditor(GrammarModel grammar, Map<String, String> options) {
            super(grammar, new FlowLayout(0, 0, 0));
            this.setBackground(ExplorationDialog.INFO_BG_COLOR);
            this.selector = new JComboBox();
            this.selector.setBackground(ExplorationDialog.INFO_BOX_BG_COLOR);
            this.selector.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EnumeratedEditor.this.notifyTemplateListeners();
                }
            });
            this.keys = new String[options.size()];
            this.nrKeys = 0;
            if (this.nrKeys == 0) {
                this.selector.addItem("<HTML><FONT color=red>Error! No valid options available.</FONT></HTML>");
            }
            this.refresh();
            this.add(this.selector);
        }

        @Override
        public void refresh() {
            this.nrKeys = 0;
            int selected = this.selector.getSelectedIndex();
            this.selector.removeAllItems();
            for (Map.Entry<String, String> optionEntry : EncodedEnumeratedType.this.generateOptions(this.getGrammar()).entrySet()) {
                this.selector.addItem("<HTML><FONT color=#005050>" + optionEntry.getValue() + "</FONT></HTML>");
                this.keys[this.nrKeys] = optionEntry.getKey();
                ++this.nrKeys;
            }
            this.selector.setSelectedIndex(selected < 0 ? 0 : selected);
        }

        @Override
        public String getCurrentValue() {
            if (this.nrKeys == 0) {
                return null;
            }
            return this.keys[this.selector.getSelectedIndex()];
        }

        @Override
        public void setCurrentValue(String value) {
            int i = 0;
            while (i < this.nrKeys) {
                if (this.keys[i].equals(value)) {
                    this.selector.setSelectedIndex(i);
                }
                ++i;
            }
        }
    }
}

