/*
 * Decompiled with CFR 0.152.
 */
package groove.explore.prettyparse;

public class StringConsumer {
    private String text;
    private String lastConsumed;

    public StringConsumer(String text) {
        this.text = text;
    }

    public String getLastConsumed() {
        return this.lastConsumed;
    }

    public boolean consumeAll() {
        this.lastConsumed = this.text;
        this.text = "";
        return true;
    }

    public boolean consumeLiteral(String literal) {
        if (this.text.startsWith(literal)) {
            this.text = this.text.substring(literal.length());
            this.lastConsumed = literal;
            return true;
        }
        return false;
    }

    public boolean consumeIdentifier() {
        if (this.text.length() == 0) {
            return false;
        }
        if (Character.isLetter(this.text.charAt(0))) {
            int endOfIdentifier = 0;
            while (endOfIdentifier + 1 < this.text.length() && this.isIdentChar(this.text.charAt(endOfIdentifier + 1))) {
                ++endOfIdentifier;
            }
            this.lastConsumed = this.text.substring(0, endOfIdentifier + 1);
            this.text = this.text.substring(this.lastConsumed.length());
            return true;
        }
        if (this.text.charAt(0) == '\'') {
            int secondQuote = this.text.substring(1).indexOf("'");
            if (secondQuote < 1) {
                return false;
            }
            this.lastConsumed = this.text.substring(1, secondQuote + 1);
            this.text = this.text.substring(this.lastConsumed.length() + 2);
            return true;
        }
        return false;
    }

    private boolean isIdentChar(char c) {
        return Character.isLetterOrDigit(c) || c == '_' || c == '$' || c == '-';
    }

    public boolean isEmpty() {
        return this.text.isEmpty();
    }

    public boolean consumeNumber() {
        if (this.text.length() == 0) {
            return false;
        }
        if (Character.isDigit(this.text.charAt(0))) {
            int endOfNumber = 0;
            while (endOfNumber + 1 < this.text.length() && Character.isDigit(this.text.charAt(endOfNumber + 1))) {
                ++endOfNumber;
            }
            this.lastConsumed = this.text.substring(0, endOfNumber + 1);
            this.text = this.text.substring(this.lastConsumed.length());
            return true;
        }
        return false;
    }
}

