/*
 * Decompiled with CFR 0.152.
 */
package groove.explore.result;

import groove.lts.GraphState;
import java.util.Collection;
import java.util.LinkedHashSet;

public class Result {
    private final Collection<GraphState> elements;
    private final int bound;

    public Result() {
        this(0);
    }

    public Result(int bound) {
        assert (bound >= 0);
        this.elements = this.createResultSet();
        this.bound = bound;
    }

    public void add(GraphState t) {
        this.elements.add(t);
    }

    public Collection<GraphState> getValue() {
        return this.elements;
    }

    public int getBound() {
        return this.bound;
    }

    public Result newInstance() {
        return new Result(this.bound);
    }

    public boolean done() {
        return this.bound > 0 && this.elements.size() >= this.bound;
    }

    protected Collection<GraphState> createResultSet() {
        return new LinkedHashSet<GraphState>();
    }
}

