/*
 * Decompiled with CFR 0.152.
 */
package groove.explore.strategy;

import groove.explore.strategy.Boundary;
import groove.grammar.host.HostGraph;
import groove.verify.ModelChecking;
import groove.verify.ProductTransition;

public class GraphNodeSizeBoundary
extends Boundary {
    private int size;
    private final int step;

    public GraphNodeSizeBoundary(int size, int step) {
        this(size, step, null);
    }

    private GraphNodeSizeBoundary(int size, int step, ModelChecking.Record record) {
        super(record);
        assert (step > 0);
        this.size = size;
        this.step = step;
    }

    @Override
    public Boundary instantiate(ModelChecking.Record record) {
        return new GraphNodeSizeBoundary(this.size, this.step, record);
    }

    @Override
    public boolean crossingBoundary(ProductTransition transition, boolean traverse) {
        boolean result = transition.target().getGraphState().getGraph().nodeCount() > this.size;
        return result;
    }

    public boolean crossingBoundary(HostGraph graph) {
        return graph.nodeCount() > this.size;
    }

    @Override
    public void increase() {
        this.size += this.step;
    }

    @Override
    public void increaseDepth() {
    }

    @Override
    public void decreaseDepth() {
    }

    @Override
    public int currentDepth() {
        return this.getRecord().getIteration();
    }

    public String toString() {
        return this.size + "," + this.step;
    }
}

