/*
 * Decompiled with CFR 0.152.
 */
package groove.explore.strategy;

import gov.nasa.ltl.trans.Formula;
import groove.explore.result.Acceptor;
import groove.explore.result.CycleAcceptor;
import groove.explore.result.Result;
import groove.explore.strategy.ExploreIterator;
import groove.explore.strategy.ExploreStateStrategy;
import groove.explore.strategy.Strategy;
import groove.explore.util.RandomChooserInSequence;
import groove.explore.util.RandomNewStateChooser;
import groove.graph.EdgeRole;
import groove.lts.GTS;
import groove.lts.GraphState;
import groove.lts.GraphTransition;
import groove.match.MatcherFactory;
import groove.verify.BuchiGraph;
import groove.verify.BuchiLocation;
import groove.verify.BuchiTransition;
import groove.verify.FormulaParser;
import groove.verify.ModelChecking;
import groove.verify.ParseException;
import groove.verify.ProductState;
import groove.verify.ProductStateSet;
import groove.verify.ProductTransition;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;

public class LTLStrategy
extends Strategy
implements ExploreIterator {
    private String property;
    private ModelChecking.Record record = new ModelChecking.Record();
    private final Strategy stateStrategy = new ExploreStateStrategy();
    private ProductStateSet stateSet;
    private ProductState nextState;
    private ProductState startState;
    private CycleAcceptor acceptor;
    private RandomNewStateChooser collector = new RandomNewStateChooser();
    private BuchiLocation startLocation;
    private Stack<ProductState> stateStack;
    private Result result;

    @Override
    public void prepare(GTS gts, GraphState state, Acceptor acceptor) {
        ProductState startState;
        MatcherFactory.instance().setDefaultEngine();
        this.stateSet = new ProductStateSet();
        this.stateSet.addListener(this.collector);
        assert (acceptor instanceof CycleAcceptor);
        this.acceptor = (CycleAcceptor)acceptor;
        this.acceptor.setStrategy(this);
        this.result = acceptor.getResult();
        this.stateSet.addListener(this.acceptor);
        this.stateStack = new Stack();
        assert (this.startLocation != null) : "The property automaton should have an initial state";
        this.startState = startState = this.createState(gts.startState(), null, this.startLocation);
        this.nextState = startState;
        this.stateSet.addState(startState);
        this.stateStrategy.setGTS(gts);
    }

    @Override
    public void finish() {
        this.getStateSet().removeListener(this.collector);
        this.getStateSet().removeListener(this.acceptor);
    }

    @Override
    public boolean hasNext() {
        return this.getNextState() != null;
    }

    @Override
    public GraphState doNext() {
        ProductState prodState = this.getNextState();
        assert (prodState != null);
        this.pushState(prodState);
        prodState.setColour(this.getRecord().cyan());
        this.exploreGraphState(prodState.getGraphState());
        this.collector.reset();
        if (!this.exploreState(prodState)) {
            this.setNextState();
        }
        return prodState.getGraphState();
    }

    public void setProperty(String property) {
        assert (property != null);
        this.property = property;
        try {
            Formula<String> formula = FormulaParser.parse(property).toLtlFormula();
            BuchiGraph buchiGraph = BuchiGraph.getPrototype().newBuchiGraph((Formula<String>)Formula.Not(formula));
            this.startLocation = buchiGraph.getInitial();
        }
        catch (ParseException e) {
            throw new IllegalStateException(String.format("Error in property '%s'", property), e);
        }
    }

    public String getProperty() {
        return this.property;
    }

    protected final void setNextState() {
        this.nextState = this.computeNextState();
    }

    protected final ProductState getNextState() {
        return this.nextState;
    }

    protected void pushState(ProductState state) {
        this.getStateStack().push(state);
    }

    protected ProductState rollbackState() {
        ProductState previous = this.getStateStack().pop();
        this.getStateSet().setClosed(previous);
        this.colourState(previous);
        return this.getStateStack().isEmpty() ? null : this.getStateStack().peek();
    }

    protected boolean exploreState(ProductState prodState) {
        boolean result = false;
        Set<? extends GraphTransition> outTransitions = prodState.getGraphState().getTransitions();
        Set<String> applicableRules = this.getLabels(outTransitions);
        block0: for (BuchiTransition buchiTrans : prodState.getBuchiLocation().outTransitions()) {
            if (!buchiTrans.isEnabled(applicableRules)) continue;
            boolean finalState = true;
            for (GraphTransition graphTransition : outTransitions) {
                if (graphTransition.getRole() != EdgeRole.BINARY) continue;
                finalState = false;
                ProductTransition prodTrans = this.addTransition(prodState, graphTransition, (BuchiLocation)buchiTrans.target());
                result = this.findCounterExample(prodState, prodTrans.target());
                if (result) break block0;
            }
            if (!finalState) continue;
            this.addTransition(prodState, null, (BuchiLocation)buchiTrans.target());
        }
        return result;
    }

    protected ProductState computeNextState() {
        ProductState result = this.getFreshState();
        if (result == null) {
            result = this.backtrack();
        }
        return result;
    }

    protected ProductState backtrack() {
        ProductState result = null;
        ProductState parent = null;
        do {
            if ((parent = this.rollbackState()) == null) continue;
            result = this.getNextSuccessor(parent);
        } while (parent != null && result == null);
        return result;
    }

    protected ProductState getFreshState() {
        return this.collector.pickRandomNewState();
    }

    protected void colourState(ProductState state) {
        state.setColour(this.getRecord().blue());
    }

    protected final boolean findCounterExample(ProductState source, ProductState target) {
        boolean result;
        boolean bl = result = target.colour() == this.getRecord().cyan() && (source.getBuchiLocation().isAccepting() || target.getBuchiLocation().isAccepting());
        if (result) {
            for (ProductState state : this.getStateStack()) {
                this.result.add(state.getGraphState());
            }
        }
        return result;
    }

    protected final ProductState getStartState() {
        return this.startState;
    }

    protected ProductState getNextSuccessor(ProductState state) {
        RandomChooserInSequence<ProductState> chooser = new RandomChooserInSequence<ProductState>();
        for (ProductTransition trans : state.outTransitions()) {
            ProductState s = trans.target();
            if (s.isClosed()) continue;
            chooser.show(s);
        }
        return (ProductState)chooser.pickRandom();
    }

    private Set<String> getLabels(Set<? extends GraphTransition> transitions) {
        HashSet<String> result = new HashSet<String>();
        for (GraphTransition graphTransition : transitions) {
            result.add(graphTransition.label().toString());
        }
        return result;
    }

    private void exploreGraphState(GraphState state) {
        if (!state.isClosed()) {
            this.stateStrategy.setState(state);
            this.stateStrategy.play();
        }
    }

    private ProductTransition addTransition(ProductState source, GraphTransition transition, BuchiLocation targetLocation) {
        ProductTransition result = null;
        if (!source.isClosed()) {
            ProductState target = this.createState(source.getGraphState(), transition, targetLocation);
            ProductState isoTarget = this.getStateSet().addState(target);
            if (isoTarget == null) {
                result = this.createProductTransition(source, transition, target);
            } else {
                assert (isoTarget.iteration() <= this.getRecord().getIteration()) : "This state belongs to the next iteration and should not be explored now.";
                result = this.createProductTransition(source, transition, isoTarget);
            }
            source.addTransition(result);
        } else {
            for (ProductTransition nextTransition : source.outTransitions()) {
                if (!nextTransition.graphTransition().equals(transition) || !nextTransition.target().getBuchiLocation().equals(targetLocation)) continue;
                result = nextTransition;
                break;
            }
        }
        return result;
    }

    private ProductState createState(GraphState state, GraphTransition transition, BuchiLocation targetLocation) {
        if (transition == null) {
            return new ProductState(state, targetLocation);
        }
        return new ProductState(transition, targetLocation);
    }

    private ProductTransition createProductTransition(ProductState source, GraphTransition transition, ProductState target) {
        return new ProductTransition(source, transition, target);
    }

    protected final ProductStateSet getStateSet() {
        return this.stateSet;
    }

    public final Stack<ProductState> getStateStack() {
        return this.stateStack;
    }

    public final ModelChecking.Record getRecord() {
        return this.record;
    }
}

