/*
 * Decompiled with CFR 0.152.
 */
package groove.explore.strategy;

import groove.explore.result.Acceptor;
import groove.explore.strategy.GTSStrategy;
import groove.lts.DefaultGraphNextState;
import groove.lts.GTS;
import groove.lts.GTSAdapter;
import groove.lts.GraphState;
import groove.lts.MatchResult;
import groove.lts.RuleTransition;
import groove.match.MatcherFactory;
import groove.match.SearchEngine;
import groove.match.rete.ReteSearchEngine;
import groove.transform.DeltaStore;
import groove.util.Reporter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Stack;

public class ReteStrategy
extends GTSStrategy {
    DeltaStore deltaAccumulator;
    private final Collection<GraphState> newStates = new ArrayList<GraphState>();
    private final ExploreListener exploreListener = new ExploreListener();
    private final Stack<GraphState> stack = new Stack();
    private ReteSearchEngine rete;
    private SearchEngine oldEngine;
    public static final Reporter reporter = Reporter.register(ReteStrategy.class);
    public static final Reporter ReteStrategyNextReporter = reporter.register("ReteOptimized()");

    @Override
    public void prepare(GTS gts, GraphState state, Acceptor acceptor) {
        gts.getRecord().setCopyGraphs(false);
        super.prepare(gts, state, acceptor);
        gts.addLTSListener(this.exploreListener);
        this.clearPool();
        this.newStates.clear();
        this.rete = new ReteSearchEngine(gts.getGrammar());
        this.oldEngine = MatcherFactory.instance().getEngine();
        MatcherFactory.instance().setEngine(this.rete);
    }

    @Override
    public GraphState doNext() {
        GraphState state = this.getNextState();
        ReteStrategyNextReporter.start();
        List<MatchResult> ruleMatches = state.getMatches();
        ArrayList<GraphState> outTransitions = new ArrayList<GraphState>(ruleMatches.size());
        for (MatchResult nextMatch : ruleMatches) {
            RuleTransition trans = this.getNextState().applyMatch(nextMatch);
            outTransitions.add(trans.target());
        }
        this.addToPool(outTransitions);
        this.deltaAccumulator = new DeltaStore();
        this.setNextState();
        ReteStrategyNextReporter.stop();
        return state;
    }

    @Override
    public void finish() {
        super.finish();
        MatcherFactory.instance().setEngine(this.oldEngine);
        this.getGTS().removeLTSListener(this.exploreListener);
    }

    @Override
    protected GraphState computeNextState() {
        GraphState result = this.topOfPool();
        GraphState triedState = null;
        if (result == null) {
            return result;
        }
        if (this.getNextState() == result) {
            do {
                ((DefaultGraphNextState)result).getDelta().applyDelta(this.deltaAccumulator);
                triedState = result;
                this.popPool();
                result = this.topOfPool();
                if (result != null) continue;
                return result;
            } while (((DefaultGraphNextState)result).source() != ((DefaultGraphNextState)triedState).source());
        }
        this.deltaAccumulator = this.deltaAccumulator.invert();
        ((DefaultGraphNextState)result).getDelta().applyDelta(this.deltaAccumulator);
        this.rete.transitionOccurred(result.getGraph(), this.deltaAccumulator);
        return result;
    }

    private void addToPool(Collection<GraphState> newStates) {
        for (GraphState newState : this.newStates) {
            this.stack.push(newState);
        }
        this.newStates.clear();
    }

    protected void popPool() {
        if (!this.stack.isEmpty()) {
            this.stack.pop();
        }
    }

    protected GraphState topOfPool() {
        if (this.stack.isEmpty()) {
            return null;
        }
        return this.stack.peek();
    }

    protected void clearPool() {
        this.stack.clear();
    }

    private class ExploreListener
    extends GTSAdapter {
        private ExploreListener() {
        }

        @Override
        public void addUpdate(GTS gts, GraphState state) {
            if (!state.isClosed()) {
                ReteStrategy.this.newStates.add(state);
            }
        }
    }
}

