/*
 * Decompiled with CFR 0.152.
 */
package groove.grammar;

import groove.control.CtrlAut;
import groove.control.CtrlPar;
import groove.grammar.Action;
import groove.grammar.QualName;
import groove.grammar.Rule;
import java.util.List;
import java.util.Set;

public class Recipe
implements Action {
    private final String name;
    private final int priority;
    private final List<CtrlPar.Var> sig;
    private CtrlAut body;
    private Set<Rule> rules;
    private final String controlName;
    private final int startLine;

    public Recipe(String name, int priority, List<CtrlPar.Var> sig, String controlName, int startLine) {
        this.name = name;
        this.priority = priority;
        this.sig = sig;
        this.controlName = controlName;
        this.startLine = startLine;
    }

    @Override
    public String getFullName() {
        return this.name;
    }

    @Override
    public String getLastName() {
        return QualName.getLastName(this.getFullName());
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    public void setBody(CtrlAut body) {
        assert (this.body == null) : String.format("Recipe body of %s already set to %s", this.name, body);
        this.body = body;
    }

    public CtrlAut getBody() {
        return this.body;
    }

    public Set<Rule> getRules() {
        Set<Rule> result = this.rules;
        if (result == null && this.getBody() != null) {
            result = this.rules = this.getBody().getRules();
        }
        return result;
    }

    public String getControlName() {
        return this.controlName;
    }

    public int getStartLine() {
        return this.startLine;
    }

    @Override
    public List<CtrlPar.Var> getSignature() {
        return this.sig;
    }

    @Override
    public Action.Kind getKind() {
        return Action.Kind.RECIPE;
    }

    @Override
    public int compareTo(Action other) {
        return this.getFullName().compareTo(other.getFullName());
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Recipe)) {
            return false;
        }
        Recipe other = (Recipe)obj;
        return this.name.equals(other.name);
    }
}

