/*
 * Decompiled with CFR 0.152.
 */
package groove.grammar.aspect;

import groove.algebra.Constant;
import groove.grammar.aspect.AspectKind;
import groove.grammar.model.FormatException;
import groove.grammar.type.TypeLabel;
import groove.graph.GraphRole;
import java.util.HashMap;
import java.util.Map;

public class Aspect {
    private final boolean prototype;
    private final AspectKind aspectKind;
    private final AspectKind.ContentKind contentKind;
    private final Object content;
    private static final Map<String, Aspect> aspectNameMap = new HashMap<String, Aspect>();

    static {
        AspectKind[] aspectKindArray = AspectKind.values();
        int n = aspectKindArray.length;
        int n2 = 0;
        while (n2 < n) {
            AspectKind kind = aspectKindArray[n2];
            aspectNameMap.put(kind.getName(), kind.getAspect());
            ++n2;
        }
    }

    Aspect(AspectKind kind, AspectKind.ContentKind contentKind) {
        this.aspectKind = kind;
        this.contentKind = contentKind;
        this.prototype = true;
        this.content = null;
    }

    Aspect(AspectKind kind, AspectKind.ContentKind contentKind, Object content) {
        this.aspectKind = kind;
        this.contentKind = contentKind;
        this.content = content;
        this.prototype = false;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.aspectKind == null ? 0 : this.aspectKind.hashCode());
        result = 31 * result + (this.content == null ? 0 : this.content.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Aspect other = (Aspect)obj;
        if (this.aspectKind != other.aspectKind) {
            return false;
        }
        return !(this.content == null ? other.content != null : !this.content.equals(other.content));
    }

    public String toString() {
        return this.contentKind.toString(this.getKind(), this.getContent());
    }

    public Aspect newInstance(String text, GraphRole role) throws FormatException {
        if (!this.prototype) {
            throw new UnsupportedOperationException("New aspects can only be created from prototypes");
        }
        return new Aspect(this.getKind(), this.contentKind, this.contentKind.parseContent(text, role));
    }

    public Aspect relabel(TypeLabel oldLabel, TypeLabel newLabel) {
        Object newContent;
        Aspect result = this;
        if (this.hasContent() && (newContent = this.contentKind.relabel(this.getContent(), oldLabel, newLabel)) != this.getContent()) {
            result = new Aspect(this.getKind(), this.contentKind, newContent);
        }
        return result;
    }

    public AspectKind getKind() {
        return this.aspectKind;
    }

    public boolean hasContent() {
        return this.content != null;
    }

    public Object getContent() {
        return this.content;
    }

    public String getContentString() {
        return this.contentKind.toString(this.getContent());
    }

    public boolean isForEdge(GraphRole role) {
        boolean result = AspectKind.allowedEdgeKinds.get((Object)role).contains((Object)this.getKind());
        if (result && this.getKind().hasSignature()) {
            result = !(this.getContent() instanceof Constant);
        }
        return result;
    }

    public boolean isForNode(GraphRole role) {
        boolean result = AspectKind.allowedNodeKinds.get((Object)role).contains((Object)this.getKind());
        if (result && this.getKind().hasSignature()) {
            result = this.hasContent() ? this.getContent() instanceof Constant && role != GraphRole.TYPE : role != GraphRole.HOST;
        }
        return result;
    }

    public static Aspect getAspect(String name) {
        return aspectNameMap.get(name);
    }
}

