/*
 * Decompiled with CFR 0.152.
 */
package groove.grammar.aspect;

import groove.algebra.Algebras;
import groove.algebra.Constant;
import groove.algebra.Operator;
import groove.automaton.RegExpr;
import groove.grammar.aspect.Aspect;
import groove.grammar.aspect.AspectEdge;
import groove.grammar.aspect.AspectElement;
import groove.grammar.aspect.AspectKind;
import groove.grammar.aspect.AspectLabel;
import groove.grammar.aspect.AspectNode;
import groove.grammar.aspect.AspectParser;
import groove.grammar.aspect.Assignment;
import groove.grammar.aspect.Expression;
import groove.grammar.model.FormatError;
import groove.grammar.model.FormatErrorSet;
import groove.grammar.model.FormatException;
import groove.grammar.type.TypeLabel;
import groove.graph.AElementMap;
import groove.graph.Edge;
import groove.graph.EdgeRole;
import groove.graph.ElementFactory;
import groove.graph.Graph;
import groove.graph.GraphInfo;
import groove.graph.GraphRole;
import groove.graph.Label;
import groove.graph.Morphism;
import groove.graph.Node;
import groove.graph.NodeComparator;
import groove.graph.NodeSetEdgeSetGraph;
import groove.graph.plain.PlainEdge;
import groove.graph.plain.PlainFactory;
import groove.graph.plain.PlainGraph;
import groove.graph.plain.PlainLabel;
import groove.graph.plain.PlainNode;
import groove.gui.layout.JVertexLayout;
import groove.gui.layout.LayoutMap;
import groove.gui.list.SearchResult;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class AspectGraph
extends NodeSetEdgeSetGraph<AspectNode, AspectEdge> {
    private final GraphRole role;
    private boolean normal;
    private Map<String, AspectNode> nodeIdMap;
    private static final AspectParser parser = AspectParser.getInstance();

    public AspectGraph(String name, GraphRole graphRole) {
        super(name);
        assert (graphRole.inGrammar());
        this.role = graphRole;
        this.normal = true;
        this.getInfo();
    }

    private void addErrors(Collection<FormatError> errors) {
        GraphInfo.addErrors(this, errors);
    }

    public void getSearchResults(TypeLabel label, List<SearchResult> results) {
        String msg = String.valueOf(this.getRole().getDescription()) + " '%s' - Element '%s'";
        for (AspectEdge edge : this.edgeSet()) {
            if ((edge.getRuleLabel() == null || !label.equals(edge.getRuleLabel().getTypeLabel())) && !label.equals(edge.getTypeLabel())) continue;
            results.add(new SearchResult(msg, this.getName(), edge, this));
        }
    }

    @Deprecated
    public AspectGraph fromPlainGraph(Graph graph) {
        GraphToAspectMap elementMap = new GraphToAspectMap(graph.getRole());
        return this.fromPlainGraph(graph, elementMap);
    }

    @Deprecated
    private AspectGraph fromPlainGraph(Graph graph, GraphToAspectMap elementMap) {
        GraphRole role = graph.getRole();
        AspectGraph result = new AspectGraph(graph.getName(), role);
        FormatErrorSet errors = new FormatErrorSet();
        assert (elementMap != null && elementMap.isEmpty());
        for (Node node : graph.nodeSet()) {
            AspectNode nodeImage = (AspectNode)result.addNode(node.getNumber());
            elementMap.putNode(node, nodeImage);
        }
        HashMap<Edge, AspectLabel> hashMap = new HashMap<Edge, AspectLabel>();
        for (Edge edge : graph.edgeSet()) {
            AspectLabel label = parser.parse(edge.label().text(), role);
            if (label.isNodeOnly()) {
                AspectNode sourceImage = (AspectNode)elementMap.getNode(edge.source());
                sourceImage.setAspects(label);
                continue;
            }
            hashMap.put(edge, label);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            Edge edge = (Edge)entry.getKey();
            AspectLabel label = (AspectLabel)entry.getValue();
            AspectEdge edgeImage = (AspectEdge)result.addEdge((AspectNode)elementMap.getNode(edge.source()), label, (AspectNode)elementMap.getNode(edge.target()));
            elementMap.putEdge(edge, edgeImage);
            if (edge.source().equals(edge.target()) || edgeImage.getRole() == EdgeRole.BINARY) continue;
            errors.add("%s %s must be a node label", label.getRole().getDescription(true), label, edgeImage);
        }
        GraphInfo.transfer(graph, result, elementMap);
        result.addErrors(errors);
        result.setFixed();
        return result;
    }

    public PlainGraph toPlainGraph() {
        AspectToPlainMap elementMap = new AspectToPlainMap();
        PlainGraph result = this.createPlainGraph();
        for (AspectNode node : this.nodeSet()) {
            PlainNode nodeImage = (PlainNode)result.addNode(node.getNumber());
            elementMap.putNode(node, nodeImage);
            for (PlainLabel label : node.getPlainLabels()) {
                result.addEdge(nodeImage, label, nodeImage);
            }
        }
        for (AspectEdge edge : this.edgeSet()) {
            result.addEdgeContext((PlainEdge)elementMap.mapEdge(edge));
        }
        GraphInfo.transfer(this, result, elementMap);
        result.setFixed();
        return result;
    }

    private PlainGraph createPlainGraph() {
        PlainGraph result = new PlainGraph(this.getName());
        result.setRole(this.getRole());
        return result;
    }

    public AspectGraph normalise(AspectGraphMorphism map) {
        AspectGraph result;
        if (this.normal) {
            result = this;
        } else {
            result = this.clone();
            result.doNormalise(map);
            result.setFixed();
        }
        return result;
    }

    private void doNormalise(AspectGraphMorphism map) {
        assert (!this.isFixed());
        HashSet<AspectEdge> letEdges = new HashSet<AspectEdge>();
        HashSet<AspectEdge> predEdges = new HashSet<AspectEdge>();
        for (AspectEdge edge : this.edgeSet()) {
            edge.setFixed();
            if (edge.isPredicate()) {
                predEdges.add(edge);
                continue;
            }
            if (!edge.isAssign()) continue;
            letEdges.add(edge);
        }
        this.removeEdgeSet(letEdges);
        this.removeEdgeSet(predEdges);
        ArrayList<FormatError> errors = new ArrayList<FormatError>();
        for (AspectEdge edge : letEdges) {
            try {
                AspectEdge normalisedEdge = this.addAssignment((AspectNode)edge.source(), edge.getAssign());
                if (map == null) continue;
                map.putEdge(edge, normalisedEdge);
            }
            catch (FormatException e) {
                errors.addAll(e.getErrors());
            }
        }
        for (AspectEdge edge : predEdges) {
            try {
                AspectNode source = (AspectNode)edge.source();
                boolean nac = edge.getKind().inNAC() && !source.getKind().inNAC();
                Object predicate = edge.getPredicate();
                if (predicate instanceof Assignment) {
                    Assignment test = (Assignment)predicate;
                    AspectNode value = this.addExpression(source, test.getRhs());
                    String aspect = nac ? edge.getAspect().toString() : "";
                    AspectLabel idLabel = parser.parse(String.valueOf(aspect) + test.getLhs(), this.getRole());
                    ((AspectEdge)this.addEdge(source, idLabel, value)).setFixed();
                    continue;
                }
                AspectNode outcome = this.addExpression(source, (Expression)edge.getPredicate());
                Constant value = Algebras.getConstant(nac ? "false" : "true");
                outcome.setAspects(parser.parse(value.toString(), this.getRole()));
            }
            catch (FormatException e) {
                errors.addAll(e.getErrors());
            }
        }
        this.addErrors(errors);
    }

    private AspectEdge addAssignment(AspectNode source, Assignment assign) throws FormatException {
        AspectNode target = this.addExpression(source, assign.getRhs());
        String assignLabelText = this.getRole() == GraphRole.RULE ? String.valueOf(AspectKind.CREATOR.getPrefix()) + assign.getLhs() : assign.getLhs();
        AspectLabel assignLabel = parser.parse(assignLabelText, this.getRole());
        AspectEdge result = (AspectEdge)this.addEdge(source, assignLabel, target);
        if (this.getRole() == GraphRole.RULE && !source.getKind().isCreator()) {
            AspectNode oldTarget = this.findTarget(source, assign.getLhs(), target.getAttrKind());
            if (oldTarget == null) {
                oldTarget = this.addNestedNode(source);
                oldTarget.setAspects(this.createLabel(target.getAttrKind()));
            }
            assignLabel = AspectParser.getInstance().parse(String.valueOf(AspectKind.ERASER.getPrefix()) + assign.getLhs(), this.getRole());
            this.addEdge(source, assignLabel, oldTarget);
        }
        return result;
    }

    private AspectNode addExpression(AspectNode source, Expression expr) throws FormatException {
        switch (expr.getKind()) {
            case CONSTANT: {
                return this.addConstant(((Expression.Const)expr).getConstant());
            }
            case FIELD: {
                return this.addField(source, (Expression.Field)expr);
            }
            case CALL: {
                return this.addCall(source, (Expression.Call)expr);
            }
            case PAR: {
                return this.addPar(source, (Expression.Par)expr);
            }
        }
        assert (false);
        return null;
    }

    private AspectNode addConstant(Constant constant) {
        AspectNode result = (AspectNode)this.addNode();
        result.setAspects(parser.parse(constant.toString(), this.getRole()));
        return result;
    }

    private AspectNode addField(AspectNode source, Expression.Field field) throws FormatException {
        AspectNode owner;
        if (this.getRole() != GraphRole.RULE) {
            throw new FormatException("Field expression '%s' only allowed in rules", field.toString(false), source);
        }
        String ownerName = field.getOwner();
        if (ownerName == null) {
            owner = source;
        } else {
            owner = this.nodeIdMap.get(ownerName);
            if (owner == null) {
                throw new FormatException("Unknown node identifier '%s'", ownerName, source);
            }
        }
        if (owner.getKind().isQuantifier() && !field.getField().equals(AspectKind.NestedValue.COUNT.toString())) {
            throw new FormatException("Quantifier node does not have '%s'-edge", field.getField(), owner, source);
        }
        AspectKind sigKind = AspectKind.toAspectKind(field.getType());
        AspectNode result = this.findTarget(owner, field.getField(), sigKind);
        if (result == null) {
            result = this.addNestedNode(owner);
            result.setAspects(this.createLabel(sigKind));
        } else if (result.getAttrKind() != sigKind) {
            throw new FormatException("Declared type %s differs from actual field type %s", sigKind.getName(), result.getAttrKind().getName(), source);
        }
        assert (sigKind != null);
        AspectLabel idLabel = parser.parse(field.getField(), this.getRole());
        ((AspectEdge)this.addEdge(owner, idLabel, result)).setFixed();
        return result;
    }

    private AspectNode findTarget(AspectNode owner, String fieldName, AspectKind fieldKind) {
        AspectNode result = null;
        for (AspectEdge edge : this.outEdgeSet(owner)) {
            AspectNode target;
            if (!edge.getDisplayLabel().text().equals(fieldName) || (target = (AspectNode)edge.target()).getAttrKind() != fieldKind || this.getRole() == GraphRole.RULE && !edge.getKind().inLHS() && !owner.getKind().isQuantifier()) continue;
            result = (AspectNode)edge.target();
            break;
        }
        return result;
    }

    private AspectNode addCall(AspectNode source, Expression.Call call) throws FormatException {
        Operator operator = call.getOperator();
        if (this.getRole() != GraphRole.RULE) {
            throw new FormatException("Operator expression '%s' only allowed in rules", operator.getTypedName(), source);
        }
        AspectNode result = this.addNestedNode(source);
        result.setAspects(this.createLabel(AspectKind.toAspectKind(call.getType())));
        AspectNode product = this.addNestedNode(source);
        product.setAspects(this.createLabel(AspectKind.PRODUCT));
        AspectLabel operatorLabel = parser.parse(operator.getTypedName(), this.getRole());
        this.addEdge(product, operatorLabel, result);
        List<Expression> args = call.getArguments();
        int i = 0;
        while (i < args.size()) {
            AspectNode argResult = this.addExpression(source, args.get(i));
            AspectLabel argLabel = parser.parse(String.valueOf(AspectKind.ARGUMENT.getPrefix()) + i, this.getRole());
            this.addEdge(product, argLabel, argResult);
            ++i;
        }
        return result;
    }

    private AspectNode addPar(AspectNode source, Expression.Par par) throws FormatException {
        int nr = par.getNumber();
        if (this.getRole() != GraphRole.RULE) {
            throw new FormatException("Parameter expression '%s' only allowed in rules", par.toDisplayString(), source);
        }
        AspectNode result = (AspectNode)this.addNode();
        AspectLabel parLabel = parser.parse(String.valueOf(AspectKind.PARAM_IN.getPrefix()) + nr, this.getRole());
        result.setAspects(parLabel);
        AspectLabel typeLabel = this.createLabel(AspectKind.toAspectKind(par.getType()));
        result.setAspects(typeLabel);
        return result;
    }

    private AspectNode addNestedNode(AspectNode source) throws FormatException {
        AspectNode nesting;
        AspectNode result = (AspectNode)this.addNode();
        if (source.getKind() == AspectKind.EMBARGO) {
            result.setAspect(source.getAspect());
        }
        AspectNode aspectNode = nesting = source.getKind().isQuantifier() ? source.getNestingParent() : source.getNestingLevel();
        if (nesting != null) {
            this.addEdge(result, AspectKind.NestedValue.AT.toString(), nesting);
        }
        return result;
    }

    private AspectLabel createLabel(AspectKind kind) {
        return parser.parse(kind.getPrefix(), this.getRole());
    }

    public AspectGraph renumber() {
        AspectGraph result = this;
        TreeSet<Node> nodes = new TreeSet<Node>(NodeComparator.instance());
        nodes.addAll(this.nodeSet());
        if (!nodes.isEmpty() && ((AspectNode)nodes.last()).getNumber() != this.nodeCount() - 1) {
            result = this.newGraph(this.getName());
            AspectGraphMorphism elementMap = new AspectGraphMorphism(this.getRole());
            int nodeNr = 0;
            for (AspectNode aspectNode : nodes) {
                AspectNode image = (AspectNode)result.addNode(nodeNr);
                for (AspectLabel label : aspectNode.getNodeLabels()) {
                    image.setAspects(label);
                }
                elementMap.putNode(aspectNode, image);
                ++nodeNr;
            }
            for (AspectEdge aspectEdge : this.edgeSet()) {
                AspectEdge edgeImage = (AspectEdge)elementMap.mapEdge(aspectEdge);
                result.addEdgeContext(edgeImage);
            }
            GraphInfo.transfer(this, result, elementMap);
            result.setFixed();
        }
        return result;
    }

    public AspectGraph relabel(TypeLabel oldLabel, TypeLabel newLabel) {
        PlainGraph result = this.createPlainGraph();
        AspectToPlainMap elementMap = new AspectToPlainMap();
        boolean graphChanged = false;
        for (AspectNode node : this.nodeSet()) {
            PlainNode image = (PlainNode)result.addNode(node.getNumber());
            elementMap.putNode(node, image);
            for (PlainLabel nodeLabel : node.relabel(oldLabel, newLabel).getPlainLabels()) {
                result.addEdge(image, nodeLabel, image);
            }
        }
        for (AspectEdge edge : this.edgeSet()) {
            String replacement = null;
            if (edge.getRuleLabel() != null) {
                RegExpr newLabelExpr;
                RegExpr oldLabelExpr = edge.getRuleLabel().getMatchExpr();
                if (oldLabelExpr != null && (newLabelExpr = oldLabelExpr.relabel(oldLabel, newLabel)) != oldLabelExpr) {
                    replacement = newLabelExpr.toString();
                }
            } else if (oldLabel.equals(edge.getTypeLabel())) {
                replacement = newLabel.toPrefixedString();
            }
            AspectLabel edgeLabel = (AspectLabel)edge.label();
            AspectLabel newEdgeLabel = edgeLabel.relabel(oldLabel, newLabel);
            if (replacement != null && newEdgeLabel == edgeLabel) {
                newEdgeLabel = edgeLabel.clone();
            }
            if (newEdgeLabel != edgeLabel) {
                graphChanged = true;
                if (replacement != null) {
                    newEdgeLabel.setInnerText(replacement);
                }
                newEdgeLabel.setFixed();
                edgeLabel = newEdgeLabel;
            }
            PlainNode sourceImage = (PlainNode)elementMap.getNode((Node)edge.source());
            PlainNode targetImage = (PlainNode)elementMap.getNode((Node)edge.target());
            PlainEdge edgeImage = (PlainEdge)result.addEdge(sourceImage, edgeLabel.toString(), targetImage);
            elementMap.putEdge(edge, edgeImage);
        }
        if (!graphChanged) {
            return this;
        }
        GraphInfo.transfer(this, result, elementMap);
        result.setFixed();
        return AspectGraph.newInstance(result);
    }

    public AspectGraph colour(TypeLabel label, Aspect colour) {
        assert (this.getRole() == GraphRole.TYPE);
        PlainGraph result = this.createPlainGraph();
        AspectToPlainMap elementMap = new AspectToPlainMap();
        boolean graphChanged = false;
        for (AspectNode node : this.nodeSet()) {
            PlainNode image = (PlainNode)result.addNode(node.getNumber());
            elementMap.putNode(node, image);
            for (AspectLabel nodeLabel : node.getNodeLabels()) {
                List<Aspect> nodeAspects = nodeLabel.getAspects();
                if (!nodeAspects.isEmpty() && nodeAspects.get(0).getKind() == AspectKind.COLOR) continue;
                result.addEdge(image, nodeLabel.toString(), image);
            }
        }
        for (AspectEdge edge : this.edgeSet()) {
            Aspect newColour;
            AspectLabel edgeLabel = (AspectLabel)edge.label();
            PlainNode sourceImage = (PlainNode)elementMap.getNode((Node)edge.source());
            PlainNode targetImage = (PlainNode)elementMap.getNode((Node)edge.target());
            PlainEdge edgeImage = (PlainEdge)result.addEdge(sourceImage, edgeLabel.toString(), targetImage);
            elementMap.putEdge(edge, edgeImage);
            if (edge.getRole() != EdgeRole.NODE_TYPE) continue;
            TypeLabel nodeType = edge.getTypeLabel();
            boolean labelChanged = nodeType.equals(label);
            graphChanged |= labelChanged;
            Aspect aspect = newColour = labelChanged ? colour : ((AspectNode)edge.source()).getColor();
            if (newColour == null) continue;
            result.addEdge(sourceImage, newColour.toString(), targetImage);
        }
        if (!graphChanged) {
            return this;
        }
        GraphInfo.transfer(this, result, elementMap);
        result.setFixed();
        return AspectGraph.newInstance(result);
    }

    @Override
    public boolean addEdge(AspectEdge edge) {
        edge.setFixed();
        this.normal &= !edge.isAssign() && !edge.isPredicate();
        return super.addEdge(edge);
    }

    @Override
    public final GraphRole getRole() {
        return this.role;
    }

    @Override
    public boolean setFixed() {
        boolean result;
        boolean bl = result = !this.isFixed();
        if (result) {
            FormatErrorSet errors = new FormatErrorSet();
            for (Edge edge : this.edgeSet()) {
                ((AspectEdge)edge).setFixed();
                errors.addAll(((AspectEdge)edge).getErrors());
            }
            for (AspectNode node : this.nodeSet()) {
                node.setFixed();
                errors.addAll(node.getErrors());
            }
            this.nodeIdMap = new HashMap<String, AspectNode>();
            for (AspectNode node : this.nodeSet()) {
                String name;
                AspectNode oldNode;
                Aspect id = node.getId();
                if (id == null || (oldNode = this.nodeIdMap.put(name = id.getContentString(), node)) == null) continue;
                errors.add("Duplicate node identifier %s", name, node, oldNode);
            }
            for (Edge edge : GraphInfo.getLayoutMap(this).edgeMap().keySet()) {
                if (edge.getRole() == EdgeRole.BINARY) continue;
                errors.add("Node label '%s' not allowed on edges", edge.label(), edge);
            }
            this.addErrors(errors);
            super.setFixed();
        }
        return result;
    }

    @Override
    public AspectGraph newGraph(String name) {
        return new AspectGraph(name, this.getRole());
    }

    @Override
    public AspectGraph clone() {
        AspectGraph result = this.newGraph(this.getName());
        AspectGraphMorphism map = new AspectGraphMorphism(this.getRole());
        for (AspectNode node : this.nodeSet()) {
            AspectNode clone = node.clone();
            map.putNode(node, clone);
            result.addNode(clone);
        }
        for (AspectEdge edge : this.edgeSet()) {
            AspectEdge edgeImage = (AspectEdge)map.mapEdge(edge);
            result.addEdgeContext(edgeImage);
        }
        if (this.nodeIdMap != null) {
            HashMap<String, AspectNode> newNodeIdMap = new HashMap<String, AspectNode>();
            for (Map.Entry<String, AspectNode> e : this.nodeIdMap.entrySet()) {
                newNodeIdMap.put(e.getKey(), (AspectNode)map.getNode(e.getValue()));
            }
            result.nodeIdMap = newNodeIdMap;
        }
        GraphInfo.transfer(this, result, null);
        return result;
    }

    public AspectGraph rename(String name) {
        AspectGraph result = this.clone();
        result.setName(name);
        result.setFixed();
        return result;
    }

    public AspectFactory getFactory() {
        return AspectFactory.instance(this.getRole());
    }

    public static AspectGraph newInstance(Graph graph) {
        GraphToAspectMap elementMap = new GraphToAspectMap(graph.getRole());
        GraphRole role = graph.getRole();
        AspectGraph result = new AspectGraph(graph.getName(), role);
        FormatErrorSet errors = new FormatErrorSet();
        assert (elementMap != null && elementMap.isEmpty());
        for (Node node : graph.nodeSet()) {
            AspectNode nodeImage = (AspectNode)result.addNode(node.getNumber());
            elementMap.putNode(node, nodeImage);
        }
        HashMap<Edge, AspectLabel> hashMap = new HashMap<Edge, AspectLabel>();
        for (Edge edge : graph.edgeSet()) {
            AspectLabel label = parser.parse(edge.label().text(), role);
            if (label.isNodeOnly()) {
                AspectNode sourceImage = (AspectNode)elementMap.getNode(edge.source());
                sourceImage.setAspects(label);
                continue;
            }
            hashMap.put(edge, label);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            Edge edge = (Edge)entry.getKey();
            AspectLabel label = (AspectLabel)entry.getValue();
            AspectEdge edgeImage = (AspectEdge)result.addEdge((AspectNode)elementMap.getNode(edge.source()), label, (AspectNode)elementMap.getNode(edge.target()));
            elementMap.putEdge(edge, edgeImage);
            if (edge.source().equals(edge.target()) || edgeImage.getRole() == EdgeRole.BINARY) continue;
            errors.add("%s %s must be a node label", label.getRole().getDescription(true), label, edgeImage);
        }
        GraphInfo.transfer(graph, result, elementMap);
        result.addErrors(errors);
        result.setFixed();
        return result;
    }

    public static AspectGraph emptyGraph(String name, GraphRole role) {
        AspectGraph result = new AspectGraph(name, role);
        result.setFixed();
        return result;
    }

    public static AspectGraph emptyGraph(GraphRole role) {
        return AspectGraph.emptyGraph("", role);
    }

    public static AspectGraph mergeGraphs(Collection<AspectGraph> graphs) {
        if (graphs.size() == 0) {
            return null;
        }
        StringBuilder name = new StringBuilder();
        ArrayList<Point2D.Double> dimensions = new ArrayList<Point2D.Double>();
        double globalMaxX = 0.0;
        double globalMaxY = 0.0;
        for (AspectGraph graph : graphs) {
            assert (graph.getRole() == GraphRole.HOST);
            if (name.length() != 0) {
                name.append("_");
            }
            name.append(graph.getName());
            double maxX = 0.0;
            double maxY = 0.0;
            LayoutMap layoutMap = GraphInfo.getLayoutMap(graph);
            if (layoutMap != null) {
                for (AspectNode node : graph.nodeSet()) {
                    JVertexLayout layout = layoutMap.nodeMap().get(node);
                    if (layout == null) continue;
                    Rectangle2D b = layout.getBounds();
                    maxX = Math.max(maxX, b.getX() + b.getWidth());
                    maxY = Math.max(maxY, b.getY() + b.getHeight());
                }
            }
            dimensions.add(new Point2D.Double(maxX, maxY));
            globalMaxX = Math.max(globalMaxX, maxX);
            globalMaxY = Math.max(globalMaxY, maxY);
        }
        AspectGraph result = new AspectGraph(name.toString(), GraphRole.HOST);
        LayoutMap newLayoutMap = new LayoutMap();
        FormatErrorSet newErrors = new FormatErrorSet();
        int nodeNr = 0;
        int index = 0;
        double offsetX = 0.0;
        double offsetY = 0.0;
        HashMap<AspectNode, AspectNode> nodeMap = new HashMap<AspectNode, AspectNode>();
        HashMap<String, AspectNode> sharedNodes = new HashMap<String, AspectNode>();
        for (AspectGraph graph : graphs) {
            AspectElement fresh;
            nodeMap.clear();
            LayoutMap oldLayoutMap = GraphInfo.getLayoutMap(graph);
            for (AspectNode node : graph.nodeSet()) {
                fresh = null;
                if (node.getId() != null) {
                    String id = node.getId().getContentString();
                    if (sharedNodes.containsKey(id)) {
                        nodeMap.put(node, (AspectNode)sharedNodes.get(id));
                    } else {
                        fresh = node.clone(nodeNr++);
                        sharedNodes.put(id, (AspectNode)fresh);
                    }
                } else {
                    fresh = node.clone(nodeNr++);
                }
                if (fresh == null) continue;
                newLayoutMap.copyNodeWithOffset((Node)((Object)fresh), node, oldLayoutMap, offsetX, offsetY);
                nodeMap.put(node, (AspectNode)fresh);
                result.addNode(fresh);
            }
            for (AspectEdge edge : graph.edgeSet()) {
                fresh = new AspectEdge((AspectNode)nodeMap.get(edge.source()), (AspectLabel)edge.label(), (AspectNode)nodeMap.get(edge.target()));
                newLayoutMap.copyEdgeWithOffset((Edge)((Object)fresh), edge, oldLayoutMap, offsetX, offsetY);
                result.addEdgeContext(fresh);
            }
            for (FormatError oldError : GraphInfo.getErrors(graph)) {
                newErrors.add("Error in start graph %s: %s", name, oldError);
            }
            if (globalMaxX > globalMaxY) {
                offsetY = offsetY + ((Point2D.Double)dimensions.get(index)).getY() + 50.0;
            } else {
                offsetX = offsetX + ((Point2D.Double)dimensions.get(index)).getX() + 50.0;
            }
            ++index;
        }
        GraphInfo.setLayoutMap(result, newLayoutMap);
        GraphInfo.setErrors(result, newErrors);
        result.setFixed();
        return result;
    }

    public static class AspectFactory
    implements ElementFactory<AspectNode, AspectEdge> {
        private int maxNodeNr;
        private final GraphRole graphRole;
        private static Map<GraphRole, AspectFactory> factoryMap = new EnumMap<GraphRole, AspectFactory>(GraphRole.class);

        static {
            factoryMap.put(GraphRole.RULE, new AspectFactory(GraphRole.RULE));
            factoryMap.put(GraphRole.HOST, new AspectFactory(GraphRole.HOST));
            factoryMap.put(GraphRole.TYPE, new AspectFactory(GraphRole.TYPE));
        }

        protected AspectFactory(GraphRole graphRole) {
            this.graphRole = graphRole;
        }

        @Override
        public AspectNode createNode(int nr) {
            this.maxNodeNr = Math.max(this.maxNodeNr, nr);
            return new AspectNode(nr, this.graphRole);
        }

        @Override
        public AspectLabel createLabel(String text) {
            return AspectParser.getInstance().parse(text, this.graphRole);
        }

        @Override
        public AspectEdge createEdge(AspectNode source, String text, AspectNode target) {
            return new AspectEdge(source, this.createLabel(text), target);
        }

        @Override
        public AspectEdge createEdge(AspectNode source, Label label, AspectNode target) {
            return new AspectEdge(source, (AspectLabel)label, target);
        }

        public AspectGraphMorphism createMorphism() {
            return new AspectGraphMorphism(this.graphRole);
        }

        @Override
        public int getMaxNodeNr() {
            return this.maxNodeNr;
        }

        public static AspectFactory instance(GraphRole graphRole) {
            return factoryMap.get((Object)graphRole);
        }
    }

    public static class AspectGraphMorphism
    extends Morphism<AspectNode, AspectEdge> {
        private final GraphRole graphRole;

        public AspectGraphMorphism(GraphRole graphRole) {
            super(AspectFactory.instance(graphRole));
            assert (graphRole.inGrammar());
            this.graphRole = graphRole;
        }

        public AspectGraphMorphism newMap() {
            return new AspectGraphMorphism(this.graphRole);
        }
    }

    private static class AspectToPlainMap
    extends AElementMap<AspectNode, AspectEdge, PlainNode, PlainEdge> {
        public AspectToPlainMap() {
            super(PlainFactory.instance());
        }

        @Override
        public PlainEdge createImage(AspectEdge key) {
            PlainNode imageSource = (PlainNode)this.getNode((Node)key.source());
            if (imageSource == null) {
                return null;
            }
            PlainNode imageTarget = (PlainNode)this.getNode((Node)key.target());
            if (imageTarget == null) {
                return null;
            }
            return (PlainEdge)this.getFactory().createEdge(imageSource, key.getPlainLabel(), imageTarget);
        }
    }

    private static class GraphToAspectMap
    extends AElementMap<Node, Edge, AspectNode, AspectEdge> {
        public GraphToAspectMap(GraphRole graphRole) {
            super(AspectFactory.instance(graphRole));
        }
    }
}

