/*
 * Decompiled with CFR 0.152.
 */
package groove.grammar.aspect;

import groove.algebra.Algebras;
import groove.algebra.Constant;
import groove.algebra.Operator;
import groove.algebra.SignatureKind;
import groove.annotation.Help;
import groove.grammar.aspect.Aspect;
import groove.grammar.aspect.Assignment;
import groove.grammar.aspect.Expression;
import groove.grammar.model.FormatException;
import groove.grammar.type.LabelPattern;
import groove.grammar.type.Multiplicity;
import groove.grammar.type.TypeLabel;
import groove.graph.EdgeRole;
import groove.graph.GraphRole;
import groove.util.Colors;
import groove.util.Pair;
import java.awt.Color;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class AspectKind
extends Enum<AspectKind> {
    public static final /* enum */ AspectKind DEFAULT = new AspectKind("none", ContentKind.NONE){

        @Override
        public String getPrefix() {
            return "";
        }
    };
    public static final /* enum */ AspectKind REMARK = new AspectKind("rem", ContentKind.NONE);
    public static final /* enum */ AspectKind READER = new AspectKind("use", ContentKind.LEVEL);
    public static final /* enum */ AspectKind ERASER = new AspectKind("del", ContentKind.LEVEL);
    public static final /* enum */ AspectKind CREATOR = new AspectKind("new", ContentKind.LEVEL);
    public static final /* enum */ AspectKind ADDER = new AspectKind("cnew", ContentKind.LEVEL);
    public static final /* enum */ AspectKind EMBARGO = new AspectKind("not", ContentKind.LEVEL);
    public static final /* enum */ AspectKind CONNECT = new AspectKind("or", ContentKind.EMPTY);
    public static final /* enum */ AspectKind BOOL = new AspectKind(SignatureKind.BOOL.getName(), ContentKind.BOOL_LITERAL);
    public static final /* enum */ AspectKind INT = new AspectKind(SignatureKind.INT.getName(), ContentKind.INT_LITERAL);
    public static final /* enum */ AspectKind REAL = new AspectKind(SignatureKind.REAL.getName(), ContentKind.REAL_LITERAL);
    public static final /* enum */ AspectKind STRING = new AspectKind(SignatureKind.STRING.getName(), ContentKind.STRING_LITERAL);
    public static final /* enum */ AspectKind ARGUMENT = new AspectKind("arg", ContentKind.NUMBER);
    public static final /* enum */ AspectKind PRODUCT = new AspectKind("prod", ContentKind.NONE);
    public static final /* enum */ AspectKind TEST = new AspectKind("test", ContentKind.TEST_EXPR);
    public static final /* enum */ AspectKind LET = new AspectKind("let", ContentKind.LET_EXPR);
    public static final /* enum */ AspectKind PARAM_BI = new AspectKind("par", ContentKind.PARAM);
    public static final /* enum */ AspectKind PARAM_IN = new AspectKind("parin", ContentKind.PARAM);
    public static final /* enum */ AspectKind PARAM_OUT = new AspectKind("parout", ContentKind.PARAM);
    public static final /* enum */ AspectKind EDGE = new AspectKind("edge", ContentKind.EDGE);
    public static final /* enum */ AspectKind ABSTRACT = new AspectKind("abs", ContentKind.NONE);
    public static final /* enum */ AspectKind IMPORT = new AspectKind("import", ContentKind.EMPTY);
    public static final /* enum */ AspectKind SUBTYPE = new AspectKind("sub", ContentKind.EMPTY);
    public static final /* enum */ AspectKind MULT_IN = new AspectKind("in", ContentKind.MULTIPLICITY);
    public static final /* enum */ AspectKind MULT_OUT = new AspectKind("out", ContentKind.MULTIPLICITY);
    public static final /* enum */ AspectKind COMPOSITE = new AspectKind("part", ContentKind.NONE);
    public static final /* enum */ AspectKind PATH = new AspectKind("path", ContentKind.NONE);
    public static final /* enum */ AspectKind LITERAL = new AspectKind("", ContentKind.NONE);
    public static final /* enum */ AspectKind FORALL = new AspectKind("forall", ContentKind.LEVEL);
    public static final /* enum */ AspectKind FORALL_POS = new AspectKind("forallx", ContentKind.LEVEL);
    public static final /* enum */ AspectKind EXISTS = new AspectKind("exists", ContentKind.LEVEL);
    public static final /* enum */ AspectKind EXISTS_OPT = new AspectKind("existsx", ContentKind.LEVEL);
    public static final /* enum */ AspectKind NESTED = new AspectKind("nested", ContentKind.NESTED);
    public static final /* enum */ AspectKind ID = new AspectKind("id", ContentKind.NAME);
    public static final /* enum */ AspectKind COLOR = new AspectKind("color", ContentKind.COLOR);
    private final ContentKind contentKind;
    private final String name;
    private Aspect aspect;
    private static final Map<GraphRole, Map<String, String>> nodeDocMapMap;
    private static final Map<GraphRole, Map<String, String>> edgeDocMapMap;
    private static final Map<String, AspectKind> kindMap;
    private static final Map<String, NestedValue> nestedValueMap;
    private static final Map<String, String> tokenMap;
    private static final Map<SignatureKind, AspectKind> sigKindMap;
    public static final Set<AspectKind> roles;
    public static final Set<AspectKind> nac;
    public static final Set<AspectKind> lhs;
    public static final Set<AspectKind> rhs;
    public static final Set<AspectKind> meta;
    public static final Set<AspectKind> params;
    public static final Set<AspectKind> existsQuantifiers;
    public static final Set<AspectKind> forallQuantifiers;
    public static final Set<AspectKind> attributers;
    public static final Map<GraphRole, Set<AspectKind>> allowedNodeKinds;
    public static final Map<GraphRole, Set<AspectKind>> allowedEdgeKinds;
    private static /* synthetic */ int[] $SWITCH_TABLE$groove$graph$GraphRole;
    private static final /* synthetic */ AspectKind[] ENUM$VALUES;

    static {
        ENUM$VALUES = new AspectKind[]{DEFAULT, REMARK, READER, ERASER, CREATOR, ADDER, EMBARGO, CONNECT, BOOL, INT, REAL, STRING, ARGUMENT, PRODUCT, TEST, LET, PARAM_BI, PARAM_IN, PARAM_OUT, EDGE, ABSTRACT, IMPORT, SUBTYPE, MULT_IN, MULT_OUT, COMPOSITE, PATH, LITERAL, FORALL, FORALL_POS, EXISTS, EXISTS_OPT, NESTED, ID, COLOR};
        nodeDocMapMap = new EnumMap<GraphRole, Map<String, String>>(GraphRole.class);
        edgeDocMapMap = new EnumMap<GraphRole, Map<String, String>>(GraphRole.class);
        kindMap = new HashMap<String, AspectKind>();
        nestedValueMap = new HashMap<String, NestedValue>();
        tokenMap = new HashMap<String, String>();
        sigKindMap = new EnumMap<SignatureKind, AspectKind>(SignatureKind.class);
        Enum[] enumArray = AspectKind.values();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            AspectKind kind = enumArray[n2];
            AspectKind oldKind = kindMap.put(kind.toString(), kind);
            assert (oldKind == null);
            tokenMap.put(kind.name(), kind.getName());
            SignatureKind sigKind = SignatureKind.getKind(kind.getName());
            if (sigKind != null) {
                sigKindMap.put(sigKind, kind);
            }
            ++n2;
        }
        enumArray = NestedValue.values();
        n = enumArray.length;
        n2 = 0;
        while (n2 < n) {
            Enum value = enumArray[n2];
            NestedValue oldValue = nestedValueMap.put(((NestedValue)value).toString(), (NestedValue)value);
            assert (oldValue == null);
            tokenMap.put(value.name(), ((NestedValue)value).toString());
            ++n2;
        }
        nestedValueMap.put("at", NestedValue.AT);
        tokenMap.put("COLON", ":");
        tokenMap.put("EQUALS", "=");
        tokenMap.put("DOT", ".");
        tokenMap.put("COMMA", ",");
        tokenMap.put("QUOTE", "\"");
        tokenMap.put("TRUE", "true");
        tokenMap.put("FALSE", "false");
        roles = EnumSet.of(ERASER, new AspectKind[]{ADDER, CREATOR, READER, EMBARGO, CONNECT});
        nac = EnumSet.of(EMBARGO, ADDER, CONNECT);
        lhs = EnumSet.of(READER, ERASER);
        rhs = EnumSet.of(READER, CREATOR, ADDER);
        meta = EnumSet.of(FORALL, new AspectKind[]{FORALL_POS, EXISTS, EXISTS_OPT, NESTED, REMARK, CONNECT});
        params = EnumSet.of(PARAM_BI, PARAM_IN, PARAM_OUT);
        existsQuantifiers = EnumSet.of(EXISTS, EXISTS_OPT);
        forallQuantifiers = EnumSet.of(FORALL, FORALL_POS);
        attributers = EnumSet.of(PRODUCT, new AspectKind[]{ARGUMENT, STRING, INT, BOOL, REAL, TEST});
        allowedNodeKinds = new EnumMap<GraphRole, Set<AspectKind>>(GraphRole.class);
        allowedEdgeKinds = new EnumMap<GraphRole, Set<AspectKind>>(GraphRole.class);
        enumArray = GraphRole.values();
        n = enumArray.length;
        n2 = 0;
        while (n2 < n) {
            EnumSet<AspectKind> edgeKinds;
            EnumSet<AspectKind> nodeKinds;
            Enum role = enumArray[n2];
            switch (AspectKind.$SWITCH_TABLE$groove$graph$GraphRole()[role.ordinal()]) {
                case 2: {
                    nodeKinds = EnumSet.of(DEFAULT, new AspectKind[]{REMARK, INT, BOOL, REAL, STRING, COLOR, ID});
                    edgeKinds = EnumSet.of(DEFAULT, REMARK, LITERAL, LET);
                    break;
                }
                case 3: {
                    nodeKinds = EnumSet.of(REMARK, new AspectKind[]{READER, ERASER, CREATOR, ADDER, EMBARGO, BOOL, INT, REAL, STRING, PRODUCT, PARAM_BI, PARAM_IN, PARAM_OUT, FORALL, FORALL_POS, EXISTS, EXISTS_OPT, ID, COLOR});
                    edgeKinds = EnumSet.of(REMARK, new AspectKind[]{READER, ERASER, CREATOR, ADDER, EMBARGO, CONNECT, BOOL, INT, REAL, STRING, ARGUMENT, PATH, LITERAL, FORALL, FORALL_POS, EXISTS, EXISTS_OPT, NESTED, LET, TEST});
                    break;
                }
                case 4: {
                    nodeKinds = EnumSet.of(DEFAULT, new AspectKind[]{REMARK, INT, BOOL, REAL, STRING, ABSTRACT, IMPORT, COLOR, EDGE});
                    edgeKinds = EnumSet.of(REMARK, new AspectKind[]{INT, BOOL, REAL, STRING, ABSTRACT, SUBTYPE, MULT_IN, MULT_OUT, COMPOSITE});
                    break;
                }
                default: {
                    assert (!((GraphRole)role).inGrammar());
                    nodeKinds = EnumSet.noneOf(AspectKind.class);
                    edgeKinds = EnumSet.noneOf(AspectKind.class);
                }
            }
            allowedNodeKinds.put((GraphRole)role, nodeKinds);
            allowedEdgeKinds.put((GraphRole)role, edgeKinds);
            ++n2;
        }
    }

    private AspectKind(String name, ContentKind contentKind) {
        this.name = name;
        this.contentKind = contentKind;
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.name;
    }

    public String getPrefix() {
        return String.valueOf(this.getName()) + ':';
    }

    public ContentKind getContentKind() {
        return this.contentKind;
    }

    public Aspect getAspect() {
        if (this.aspect == null) {
            this.aspect = new Aspect(this, this.contentKind);
        }
        return this.aspect;
    }

    public Pair<Aspect, String> parseAspect(String input, GraphRole role) throws FormatException {
        assert (input.startsWith(this.getName()) && input.indexOf(58) >= 0);
        Pair<Object, String> result = this.getContentKind().parse(input, this.getName().length(), role);
        return new Pair<Aspect, String>(new Aspect(this, this.getContentKind(), result.one()), result.two());
    }

    public boolean isRole() {
        return roles.contains((Object)this);
    }

    public boolean inNAC() {
        return nac.contains((Object)this);
    }

    public boolean inLHS() {
        return lhs.contains((Object)this);
    }

    public boolean inRHS() {
        return rhs.contains((Object)this);
    }

    public boolean isEraser() {
        return this.inLHS() && !this.inRHS();
    }

    public boolean isCreator() {
        return this.inRHS() && !this.inLHS();
    }

    public boolean hasSignature() {
        return this.getSignature() != null;
    }

    public SignatureKind getSignature() {
        return this.contentKind.signature;
    }

    public boolean isMeta() {
        return meta.contains((Object)this);
    }

    public boolean isParam() {
        return params.contains((Object)this);
    }

    public boolean isExists() {
        return existsQuantifiers.contains((Object)this);
    }

    public boolean isForall() {
        return forallQuantifiers.contains((Object)this);
    }

    public boolean isQuantifier() {
        return this.isExists() || this.isForall();
    }

    public boolean isAttrKind() {
        return attributers.contains((Object)this);
    }

    public boolean isLast() {
        return this.contentKind != ContentKind.LEVEL && this.contentKind != ContentKind.MULTIPLICITY && this != COMPOSITE;
    }

    public static AspectKind getKind(String name) {
        return kindMap.get(name);
    }

    public static NestedValue getNestedValue(String name) {
        return nestedValueMap.get(name);
    }

    public static Map<String, String> getNodeDocMap(GraphRole role) {
        Map<String, String> result = nodeDocMapMap.get((Object)role);
        if (result == null) {
            result = AspectKind.computeNodeDocMap(role);
            nodeDocMapMap.put(role, result);
        }
        return result;
    }

    public static Map<String, String> getEdgeDocMap(GraphRole role) {
        Map<String, String> result = edgeDocMapMap.get((Object)role);
        if (result == null) {
            result = AspectKind.computeEdgeDocMap(role);
            edgeDocMapMap.put(role, result);
        }
        return result;
    }

    public static AspectKind toAspectKind(SignatureKind signature) {
        return sigKindMap.get((Object)signature);
    }

    private static Map<String, String> computeNodeDocMap(GraphRole role) {
        TreeMap<String, String> result = new TreeMap<String, String>();
        EnumSet<AspectKind> nodeKinds = EnumSet.copyOf(allowedNodeKinds.get((Object)role));
        if (role == GraphRole.HOST || role == GraphRole.RULE) {
            nodeKinds.add(LET);
        }
        if (role == GraphRole.RULE) {
            nodeKinds.add(TEST);
        }
        for (AspectKind kind : nodeKinds) {
            Help help = AspectKind.computeHelp(kind, role, true, true);
            if (help != null) {
                result.put(help.getItem(), help.getTip());
            }
            if ((help = AspectKind.computeHelp(kind, role, true, false)) == null) continue;
            result.put(help.getItem(), help.getTip());
        }
        return result;
    }

    private static Map<String, String> computeEdgeDocMap(GraphRole role) {
        TreeMap<String, String> result = new TreeMap<String, String>();
        EnumSet<AspectKind> edgeKinds = EnumSet.copyOf(allowedEdgeKinds.get((Object)role));
        edgeKinds.remove((Object)LET);
        edgeKinds.remove((Object)TEST);
        if (role == GraphRole.TYPE) {
            for (AspectKind kind : edgeKinds) {
                if (!kind.hasSignature()) continue;
                edgeKinds.remove((Object)kind);
            }
        }
        for (AspectKind kind : edgeKinds) {
            Help help = AspectKind.computeHelp(kind, role, false, true);
            if (help == null) continue;
            result.put(help.getItem(), help.getTip());
        }
        return result;
    }

    private static Help computeHelp(AspectKind kind, GraphRole role, boolean forNode, boolean withLabel) {
        String h = null;
        String s = null;
        ArrayList<String> b = new ArrayList<String>();
        ArrayList<String> p = new ArrayList<String>();
        String qBody = "The optional %1$s denotes an associated quantifier level.";
        String qPar = "optional associated quantifier level";
        String flagPar = "text of the flag; must consist of letters, digits, '$', '-' or '_'";
        String edgePar = "text of the edge; must consist of letters, digits, '$', '-' or '_'";
        switch (kind) {
            case ABSTRACT: {
                if (!forNode) {
                    s = "%s.COLON.label";
                    h = "Abstract edge type";
                    b.add("Declares an abstract %s-edge between node types.");
                    b.add("The edge can only occur between subtypes where it is redeclared concretely.");
                    p.add(edgePar);
                    break;
                }
                if (withLabel) {
                    s = "%s.COLON.flag";
                    h = "Abstract flag";
                    b.add("Declares an abstract %s for a node type.");
                    b.add("The flag can only occur on subtypes where it is redeclared concretely.");
                    p.add(flagPar);
                    break;
                }
                s = "%s.COLON";
                h = "Abstract node type";
                b.add("Declares a node type to be abstract.");
                b.add("Only nodes of concrete subtypes can actually exist.");
                break;
            }
            case ADDER: {
                if (!forNode) {
                    s = "%s[EQUALS.q]COLON.label";
                    h = "Conditional edge creator";
                    b.add("Tests for the absence of a %2$s-edge; creates it when applied.");
                    b.add(qBody);
                    p.add(qPar);
                    p.add(edgePar);
                    break;
                }
                if (withLabel) {
                    s = "%s[EQUALS.q]COLON.flag";
                    h = "Conditional flag creator";
                    b.add("Tests for the absence of %2$s; creates it when applied.");
                    b.add(qBody);
                    p.add(qPar);
                    p.add(flagPar);
                    break;
                }
                s = "%s.COLON";
                h = "Conditional node creator";
                b.add("Tests for the absence of a node; creates it when applied.");
                break;
            }
            case ARGUMENT: {
                s = "%s.COLON.nr";
                h = "Argument edge";
                b.add("Projects a product node onto argument %s.");
                p.add("argument number, ranging from 0 to the product node arity - 1");
                break;
            }
            case BOOL: {
                if (!forNode) {
                    s = "%s.COLON.op";
                    h = "Boolean operator";
                    b.add("Applies operation %s from the BOOL signature");
                    b.add("to the arguments of the source PRODUCT node.");
                    p.add("boolean operator: one of " + AspectKind.ops(kind));
                    break;
                }
                if (withLabel) {
                    if (role == GraphRole.TYPE) {
                        s = "%s.COLON.field";
                        h = "Boolean field";
                        b.add("Declares %s to be a boolean-valued field.");
                        break;
                    }
                    s = "%s.COLON.(TRUE|FALSE)";
                    h = "Boolean constant";
                    b.add("Represents a constant boolean value (TRUE or FALSE).");
                    break;
                }
                if (role != GraphRole.RULE) break;
                s = "%s.COLON";
                h = "Boolean variable";
                b.add("Declares a boolean-valued variable node.");
                break;
            }
            case COLOR: {
                s = "%s.COLON.(rgb|name)";
                h = "Node type colour";
                b.add("Sets the colour of the nodes and outgoing edges of a type.");
                p.add("comma-seperated list of three colour dimensions, with range 0..255");
                p.add("color name");
                break;
            }
            case COMPOSITE: {
                s = "%s.COLON.label";
                h = "Composite edge property";
                b.add("Declares an edge to be composite.");
                b.add(Help.it("Currently unsupported."));
                break;
            }
            case CONNECT: {
                s = "%s.COLON";
                h = "Embargo choice";
                b.add("Declares a choice between two negative application patterns.");
                break;
            }
            case CREATOR: {
                if (!forNode) {
                    s = "%s[EQUALS.q]COLON.label";
                    h = "Edge creator";
                    b.add("Creates a %2$s-edge when applied.");
                    b.add(qBody);
                    p.add(qPar);
                    p.add("label of the created edge");
                    break;
                }
                if (withLabel) {
                    s = "%s[EQUALS.q]COLON.flag";
                    h = "Flag creator";
                    b.add("Creates a %2$s when applied.");
                    b.add(qBody);
                    p.add(qPar);
                    p.add("created flag; should be preceded by FLAG COLON");
                    break;
                }
                s = "%s.COLON";
                h = "Node creator";
                b.add("Creates a node when applied.");
                break;
            }
            case EDGE: {
                s = "%s.COLON.QUOTE.format.QUOTE.[COMMA.field]+";
                h = "Nodifier edge pattern";
                b.add("Declares the node type to be a nodified edge,");
                b.add("meaning that it will not be displayed as a node.");
                b.add("Instead, the incoming edges will be labelled by expanding %s");
                b.add("with string representations of the concrete values of the %s list");
                p.add("Label format, with parameter syntax as in <tt>String.format</tt>");
                p.add("Comma-separated list of attribute field names");
                break;
            }
            case EMBARGO: {
                if (!forNode) {
                    s = "%s[EQUALS.q]COLON.label";
                    h = "Edge embargo";
                    b.add("Tests for the absence of a %2$s-edge.");
                    b.add(qBody);
                    p.add(qPar);
                    p.add("label of the forbidden edge");
                    break;
                }
                if (withLabel) {
                    s = "%s[EQUALS.q]COLON.flag";
                    h = "Flag embargo";
                    b.add("Tests for the absence of a %2$s.");
                    b.add(qBody);
                    p.add(qPar);
                    p.add("forbidden flag; should be preceded by FLAG COLON");
                    break;
                }
                s = "%s.COLON";
                h = "Node embargo";
                b.add("Tests for the absence of a node.");
                break;
            }
            case ERASER: {
                if (!forNode) {
                    s = "%s[EQUALS.q]COLON.label";
                    h = "Edge eraser";
                    b.add("Tests for the presence of a %2$s-edge; deletes it when applied.");
                    b.add(qBody);
                    p.add(qPar);
                    p.add("label of the erased edge");
                    break;
                }
                if (withLabel) {
                    s = "%s[EQUALS.q]COLON.flag";
                    h = "Flag eraser";
                    b.add("Tests for the presence of a %2$s; deletes it when applied.");
                    b.add(qBody);
                    p.add(qPar);
                    p.add("erased flag; should be preceded by FLAG COLON");
                    break;
                }
                s = "%s.COLON";
                h = "Node eraser";
                b.add("Tests for the presence of a node; deletes it when applied.");
                break;
            }
            case EXISTS: {
                s = "%s[EQUALS.q]COLON";
                h = "Existential quantification";
                b.add("Tests for the mandatory existence of a graph pattern.");
                b.add("Pattern nodes must have outgoing AT-edges to the quantifier.");
                b.add("Pattern edges may be declared through the optional quantifier level %1$s.");
                p.add("declared name for this quantifier level");
                break;
            }
            case EXISTS_OPT: {
                s = "%s[EQUALS.q]COLON";
                h = "Optional existential quantification";
                b.add("Tests for the optional existence of a graph pattern.");
                b.add("Pattern nodes must have outgoing AT-edges to the quantifier.");
                b.add("Pattern edges may be declared through the optional quantifier level %1$s.");
                p.add("declared name for this quantifier level");
                break;
            }
            case FORALL: {
                s = "%s[EQUALS.q]COLON";
                h = "Universal quantification";
                b.add("Matches all occurrences of a graph pattern.");
                b.add("The actual number of occurrences is given by an optional outgoing COUNT-edge.");
                b.add("Pattern nodes must have outgoing AT-edges to the quantifier.");
                b.add("Pattern edges may be declared through the optional quantifier level %1$s.");
                p.add("declared name for this quantifier level");
                break;
            }
            case FORALL_POS: {
                s = "%s[EQUALS.q]COLON";
                h = "Non-vacuous universal quantification";
                b.add("Matches all occurrences of a graph pattern, provided there is at least one.");
                b.add("The actual number of occurrences is given by an optional outgoing COUNT-edge.");
                b.add("Pattern nodes must have outgoing AT-edges to the quantifier.");
                b.add("Pattern edges may be declared through the optional quantifier level %1$s.");
                p.add("declared name for this quantifier level");
                break;
            }
            case ID: {
                s = "%s.COLON.name";
                h = "Node identifier";
                b.add("Assigns an internal node identifier %s.");
                p.add("the declared name for this node");
                break;
            }
            case IMPORT: {
                s = "%s.COLON";
                h = "Imported node type";
                b.add("Indicates that the type is imported from another type graph.");
                b.add("This affects the behaviour of hiding (all elements of) a type graph.");
                break;
            }
            case INT: {
                if (!forNode) {
                    s = "%s.COLON.op";
                    h = "Integer operator";
                    b.add("Applies operation %1$s from the INT signature");
                    b.add("to the arguments of the source PRODUCT node.");
                    p.add("integer operator: one of " + AspectKind.ops(kind));
                    break;
                }
                if (withLabel) {
                    if (role == GraphRole.TYPE) {
                        s = "%s.COLON.field";
                        h = "Integer field";
                        b.add("Declares %s to be an integer-valued field.");
                        break;
                    }
                    s = "%s.COLON.nr";
                    h = "Integer constant";
                    b.add("Represents the constant integer value %1$s.");
                    break;
                }
                if (role != GraphRole.RULE) break;
                s = "INT.COLON";
                h = "Integer variable";
                b.add("Declares an integer-valued variable node.");
                break;
            }
            case LET: {
                s = "%s.COLON.name.EQUALS.expr";
                h = "Assignment";
                b.add("Assigns the value of %2$s to the attribute field %1$s.");
                break;
            }
            case LITERAL: {
                s = "COLON.free";
                h = "Literal edge label";
                b.add("Specifies a %s-labelled edge, where %1$s may be an arbitrary string");
                p.add("a string of arbitrary characters");
                break;
            }
            case MULT_IN: {
                s = "%s.EQUALS[lo.DOT.DOT]hi COLON label";
                h = "Incoming edge multiplicity.";
                b.add("Constrains the number of incoming %3$s-edges for every node");
                b.add("to at least %1$s (if specified) and at most %2$s");
                b.add(Help.it("(This is currently unsupported."));
                p.add("optional lower bound");
                p.add("mandatory upper bound ('*' for unbounded)");
                p.add("label of the incoming edge");
                break;
            }
            case MULT_OUT: {
                s = "%s.EQUALS[lo.DOT.DOT]hi COLON label";
                h = "Outgoing edge multiplicity.";
                b.add("Constrains the number of outgoing %3$s-edges for every node");
                b.add("to at least %1$s (if specified) and at most %2$s");
                b.add(Help.it("(This is currently unsupported."));
                p.add("optional lower bound");
                p.add("mandatory upper bound ('*' for unbounded)");
                p.add("label of the outgoing edge");
                break;
            }
            case NESTED: {
                s = "[%s.COLON](AT|IN|COUNT)";
                h = "Structural nesting edge";
                b.add("Declares quantifier structure (the NESTED-prefix itself is optional):");
                b.add("<li> IN nests one quantifier within another;");
                b.add("<li> AT connects a graph pattern node to a quantifier;");
                b.add("<li> COUNT points to the cardinality of a quantifier.");
                break;
            }
            case DEFAULT: {
                break;
            }
            case PARAM_BI: {
                if (withLabel) {
                    s = "%s.COLON.nr";
                    h = "Bidirectional rule parameter";
                    b.add("Declares bidirectional rule parameter %1$s (ranging from 0).");
                    b.add("When used from a control program this parameter may be instantiated with a concrete value,");
                    b.add("or be used as an output parameter, in which case the value");
                    b.add("is determined by the matching.");
                    p.add("the parameter number, ranging from 0");
                    break;
                }
                s = "PARAM_BI.COLON";
                h = "Anchor node";
                b.add("Declares an explicit anchor node.");
                b.add("This causes the node to be considered relevant in distinguishing matches");
                b.add("even if it is not involved in any deletion, creation or merging.");
                break;
            }
            case PARAM_IN: {
                s = "%s.COLON.nr";
                h = "Rule input parameter";
                b.add("Declares rule input parameter %s (ranging from 0).");
                break;
            }
            case PARAM_OUT: {
                s = "%s.COLON.nr";
                h = "Rule output parameter";
                b.add("Declares rule output parameter %s (ranging from 0).");
                break;
            }
            case PATH: {
                s = "%s.COLON.regexpr";
                h = "Regular path expression";
                b.add("Tests for a path satisfying the regular expression %1$s.");
                p.add("regular expression; for the syntax, consult the appropriate tab.");
                break;
            }
            case PRODUCT: {
                s = "%s.COLON";
                h = "Product node";
                b.add("Declares a product node, corresponding to a tuple of attribute nodes.");
                break;
            }
            case READER: {
                if (!forNode) {
                    s = "%s.EQUALS.q.COLON.regexpr";
                    h = "Quantified reader edge";
                } else if (withLabel) {
                    s = "%s.EQUALS.q.COLON.flag";
                    h = "Quantified reader flag";
                }
                b.add("Tests for the presence of %2$s on quantification level %1$s.");
                p.add(qPar);
                p.add("item tested for");
                break;
            }
            case REAL: {
                if (!forNode) {
                    s = "%s.COLON.op";
                    h = "Real-valued operator";
                    b.add("Applies operation %1$s from the REAL signature");
                    b.add("to the arguments of the source PRODUCT node.");
                    p.add("real operator: one of " + AspectKind.ops(kind));
                    break;
                }
                if (withLabel) {
                    if (role == GraphRole.TYPE) {
                        s = "%s.COLON.field";
                        h = "Real number field";
                        b.add("Declares %s to be a real number-valued field.");
                        break;
                    }
                    s = "%s.COLON.nr.DOT.nr";
                    h = "Real constant";
                    b.add("Represents the constant real value %1$s.%2$s.");
                    break;
                }
                if (role != GraphRole.RULE) break;
                s = "%s.COLON";
                h = "Real variable";
                b.add("Declares a real-valued variable node.");
                break;
            }
            case REMARK: {
                if (forNode) {
                    s = "%s.COLON";
                    b.add("Declares a remark node, to be used for documentation");
                    break;
                }
                s = "%s.COLON.text";
                b.add("Declares a remark edge with (free-formatted) text %1$s");
                break;
            }
            case STRING: {
                if (!forNode) {
                    s = "%s.COLON.op";
                    h = "String operator";
                    b.add("Applies operation %1$s from the STRING signature");
                    b.add("to the arguments of the source PRODUCT node.");
                    p.add("string operator: one of " + AspectKind.ops(kind));
                    break;
                }
                if (withLabel) {
                    if (role == GraphRole.TYPE) {
                        s = "%s.COLON.field";
                        h = "String field";
                        b.add("Declares %s to be a string-valued field.");
                        break;
                    }
                    s = "%s.COLON.QUOTE.text.QUOTE";
                    h = "String constant";
                    b.add("Represents the constant string value %1$s.");
                    break;
                }
                if (role != GraphRole.RULE) break;
                s = "%s.COLON";
                h = "String variable";
                b.add("Declares a string-valued variable node.");
                break;
            }
            case SUBTYPE: {
                s = "%s.COLON";
                h = "Subtype declaration";
                b.add("Declares the source type node to be a subtype of the target type node");
                break;
            }
            case TEST: {
                if (withLabel) {
                    s = "%s.COLON.constraint";
                    h = "Predicate expression";
                    b.add("Tests if the boolean expression %s holds in the graph.");
                    break;
                }
                s = "%s.COLON.name.EQUALS.expr";
                h = "Attribute value test";
                b.add("Tests if the attribute field %1$s equals the value of %2$s.");
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        Help result = null;
        if (s != null) {
            result = new Help(tokenMap);
            result.setSyntax(String.format(s, kind.name()));
            result.setHeader(h);
            result.setBody(b);
            result.setPars(p);
        }
        return result;
    }

    private static String ops(AspectKind kind) {
        StringBuilder result = new StringBuilder();
        assert (kind.hasSignature());
        for (String opName : Algebras.getOperatorNames(SignatureKind.getKind(kind.getName()))) {
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(Help.it(opName));
        }
        return result.toString();
    }

    public static AspectKind[] values() {
        AspectKind[] aspectKindArray = ENUM$VALUES;
        int n = aspectKindArray.length;
        AspectKind[] aspectKindArray2 = new AspectKind[n];
        System.arraycopy(ENUM$VALUES, 0, aspectKindArray2, 0, n);
        return aspectKindArray2;
    }

    public static AspectKind valueOf(String string) {
        return Enum.valueOf(AspectKind.class, string);
    }

    /* synthetic */ AspectKind(String string, int n, String string2, ContentKind contentKind, AspectKind aspectKind) {
        this(string2, contentKind);
    }

    static /* synthetic */ int[] $SWITCH_TABLE$groove$graph$GraphRole() {
        if ($SWITCH_TABLE$groove$graph$GraphRole != null) {
            return $SWITCH_TABLE$groove$graph$GraphRole;
        }
        int[] nArray = new int[GraphRole.values().length];
        try {
            nArray[GraphRole.BUCHI.ordinal()] = 8;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[GraphRole.CTRL.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[GraphRole.HOST.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[GraphRole.LTS.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[GraphRole.NONE.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[GraphRole.PATTERN.ordinal()] = 10;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[GraphRole.RETE.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[GraphRole.RULE.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[GraphRole.SHAPE.ordinal()] = 9;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[GraphRole.TYPE.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$groove$graph$GraphRole = nArray;
        return nArray;
    }

    public static class ContentKind
    extends Enum<ContentKind> {
        public static final /* enum */ ContentKind NONE = new ContentKind(){

            @Override
            Pair<Object, String> parse(String text, int pos, GraphRole role) throws FormatException {
                if (text.charAt(pos) != ':') {
                    throw new FormatException("Suffix '%s' not allowed", text.substring(pos, text.indexOf(58)));
                }
                return new Pair<Object, String>(null, text.substring(pos + 1));
            }

            @Override
            Object parseContent(String text, GraphRole role) {
                throw new UnsupportedOperationException();
            }
        };
        public static final /* enum */ ContentKind EMPTY = new ContentKind(){

            @Override
            Pair<Object, String> parse(String text, int pos, GraphRole role) throws FormatException {
                if (text.charAt(pos) != ':') {
                    throw new FormatException("Suffix '%s' not allowed", text.substring(pos, text.indexOf(58)));
                }
                if (pos < text.length() - 1) {
                    throw new FormatException("Label text '%s' not allowed", text.substring(pos + 1));
                }
                return new Pair<Object, String>(null, text.substring(pos + 1));
            }

            @Override
            Object parseContent(String text, GraphRole role) {
                throw new UnsupportedOperationException();
            }
        };
        public static final /* enum */ ContentKind LEVEL = new ContentKind(){

            @Override
            Pair<Object, String> parse(String text, int pos, GraphRole role) throws FormatException {
                String content = null;
                int end = text.indexOf(58);
                if (!$assertionsDisabled && end < 0) {
                    throw new AssertionError();
                }
                if (end > pos) {
                    content = this.parseContent(text.substring(pos + 1, end), role);
                }
                return new Pair<Object, String>(content, text.substring(end + 1));
            }

            @Override
            String parseContent(String text, GraphRole role) throws FormatException {
                int i = 0;
                while (i < text.length()) {
                    char c = text.charAt(i);
                    if (i == 0 ? !ContentKind.isValidFirstChar(c) : !ContentKind.isValidNextChar(c)) {
                        throw new FormatException("Invalid quantification level", new Object[0]);
                    }
                    ++i;
                }
                return text;
            }
        };
        public static final /* enum */ ContentKind STRING_LITERAL = new ContentKind(SignatureKind.STRING);
        public static final /* enum */ ContentKind BOOL_LITERAL = new ContentKind(SignatureKind.BOOL);
        public static final /* enum */ ContentKind INT_LITERAL = new ContentKind(SignatureKind.INT);
        public static final /* enum */ ContentKind REAL_LITERAL = new ContentKind(SignatureKind.REAL);
        public static final /* enum */ ContentKind MULTIPLICITY = new ContentKind(){

            @Override
            Pair<Object, String> parse(String text, int pos, GraphRole role) throws FormatException {
                int end = text.indexOf(58, pos);
                if (!$assertionsDisabled && end < 0) {
                    throw new AssertionError();
                }
                if (end == pos) {
                    throw new FormatException("Malformed multiplicity", new Object[0]);
                }
                Multiplicity content = this.parseContent(text.substring(pos + 1, end), role);
                return new Pair<Object, String>(content, text.substring(end + 1));
            }

            @Override
            Multiplicity parseContent(String text, GraphRole role) throws FormatException {
                return Multiplicity.parse(text);
            }

            @Override
            String toString(Object content) {
                return ((Multiplicity)content).toString();
            }
        };
        public static final /* enum */ ContentKind PARAM = new ContentKind(){

            @Override
            Pair<Object, String> parse(String text, int pos, GraphRole role) throws FormatException {
                int subtract;
                String nrText;
                if (!$assertionsDisabled && text.indexOf(58) < 0) {
                    throw new AssertionError();
                }
                FormatException nrFormatExc = new FormatException("Invalid parameter number", new Object[0]);
                switch (text.charAt(pos)) {
                    case ':': {
                        nrText = text.substring(pos + 1);
                        subtract = 0;
                        break;
                    }
                    case '=': {
                        if (text.charAt(pos + 1) != '$') {
                            throw new FormatException("Parameter number should start with '%s'", "$");
                        }
                        if (text.charAt(text.length() - 1) != ':') {
                            throw new FormatException("Parameter line should end with '%s'", ":");
                        }
                        nrText = text.substring(pos + 2, text.length() - 1);
                        if (nrText.length() == 0) {
                            throw nrFormatExc;
                        }
                        subtract = 1;
                        break;
                    }
                    default: {
                        throw new FormatException("Can't parse parameter", new Object[0]);
                    }
                }
                Integer content = null;
                if (nrText.length() > 0 && (content = Integer.valueOf(this.parseContent(nrText, role) - subtract)) < 0) {
                    if (content + subtract == 0) {
                        content = null;
                    } else {
                        throw nrFormatExc;
                    }
                }
                return new Pair<Object, String>(content, "");
            }

            @Override
            Integer parseContent(String text, GraphRole role) throws FormatException {
                try {
                    return Integer.parseInt(text);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new FormatException("Invalid parameter number %s", text);
                }
            }
        };
        public static final /* enum */ ContentKind NUMBER = new ContentKind(){

            @Override
            Pair<Object, String> parse(String text, int pos, GraphRole role) throws FormatException {
                if (!$assertionsDisabled && text.indexOf(58) < 0) {
                    throw new AssertionError();
                }
                if (text.charAt(pos) != ':') {
                    throw new FormatException("Can't parse argument", new Object[0]);
                }
                String nrText = text.substring(pos + 1);
                return new Pair<Object, String>(this.parseContent(nrText, role), "");
            }

            @Override
            Integer parseContent(String text, GraphRole role) throws FormatException {
                int result;
                FormatException formatExc = new FormatException("Invalid argument number %s", text);
                try {
                    result = Integer.parseInt(text);
                }
                catch (NumberFormatException numberFormatException) {
                    throw formatExc;
                }
                if (result < 0) {
                    throw formatExc;
                }
                return result;
            }
        };
        public static final /* enum */ ContentKind NESTED = new ContentKind(){

            @Override
            Pair<Object, String> parse(String text, int pos, GraphRole role) throws FormatException {
                if (text.charAt(pos) != ':') {
                    throw new FormatException("Can't parse quantifier nesting", text);
                }
                return new Pair<NestedValue, String>(this.parseContent(text.substring(pos + 1), role), "");
            }

            NestedValue parseContent(String text, GraphRole role) throws FormatException {
                NestedValue content = AspectKind.getNestedValue(text);
                if (content == null) {
                    throw new FormatException("Can't parse quantifier nesting", new Object[0]);
                }
                return content;
            }
        };
        public static final /* enum */ ContentKind COLOR = new ContentKind(){

            @Override
            Pair<Object, String> parse(String text, int pos, GraphRole role) throws FormatException {
                if (text.charAt(pos) != ':') {
                    throw new FormatException("Can't parse colour value", new Object[0]);
                }
                return new Pair<Object, String>(this.parseContent(text.substring(pos + 1), role), "");
            }

            @Override
            Color parseContent(String text, GraphRole role) throws FormatException {
                Color result = Colors.findColor(text);
                if (result == null) {
                    throw new FormatException("Can't parse '%s' as colour", text);
                }
                return result;
            }
        };
        public static final /* enum */ ContentKind NAME = new ContentKind(){

            @Override
            Pair<Object, String> parse(String text, int pos, GraphRole role) throws FormatException {
                if (text.charAt(pos) != ':') {
                    throw new FormatException("Can't parse node name", new Object[0]);
                }
                return new Pair<Object, String>(this.parseContent(text.substring(pos + 1), role), "");
            }

            @Override
            String parseContent(String text, GraphRole role) throws FormatException {
                boolean reserved = text.length() > 1;
                int i = 0;
                while (i < text.length()) {
                    char c = text.charAt(i);
                    if (i == 0 ? !ContentKind.isValidFirstChar(c) : !ContentKind.isValidNextChar(c)) {
                        throw new FormatException("Invalid node name '%s'", text);
                    }
                    reserved &= i == 0 ? Character.isLetter(c) : Character.isDigit(c);
                    ++i;
                }
                if (reserved) {
                    throw new FormatException("Reserved node name '%s' (letter digit+)", text);
                }
                return text;
            }
        };
        public static final /* enum */ ContentKind TEST_EXPR = new ContentKind(){

            @Override
            Pair<Object, String> parse(String text, int pos, GraphRole role) throws FormatException {
                if (text.charAt(pos) != ':') {
                    throw new FormatException("Can't parse attribute predicate", new Object[0]);
                }
                return new Pair<Object, String>(this.parseContent(text.substring(pos + 1), role), "");
            }

            @Override
            Object parseContent(String text, GraphRole role) throws FormatException {
                Object result;
                if (text.indexOf(61) < 0) {
                    Expression expr = Expression.parse(text);
                    if (expr.getKind() == Expression.Kind.FIELD) {
                        throw new FormatException("Identifier '%s' not allowed as predicate expression", text);
                    }
                    SignatureKind type = expr.getType();
                    if (type != SignatureKind.BOOL) {
                        throw new FormatException("Non-boolean expression '%s' not allowed as predicate expression", text);
                    }
                    result = expr;
                } else {
                    result = Assignment.parse(text);
                }
                return result;
            }

            @Override
            String toString(Object content) {
                return content.toString();
            }

            @Override
            Object relabel(Object content, TypeLabel oldLabel, TypeLabel newLabel) {
                if (content instanceof Assignment) {
                    return ((Assignment)content).relabel(oldLabel, newLabel);
                }
                return ((Expression)content).relabel(oldLabel, newLabel);
            }
        };
        public static final /* enum */ ContentKind LET_EXPR = new ContentKind(){

            @Override
            Pair<Object, String> parse(String text, int pos, GraphRole role) throws FormatException {
                if (text.charAt(pos) != ':') {
                    throw new FormatException("Can't parse let expression", new Object[0]);
                }
                return new Pair<Object, String>(this.parseContent(text.substring(pos + 1), role), "");
            }

            @Override
            Assignment parseContent(String text, GraphRole role) throws FormatException {
                return Assignment.parse(text);
            }

            @Override
            Object relabel(Object content, TypeLabel oldLabel, TypeLabel newLabel) {
                return ((Assignment)content).relabel(oldLabel, newLabel);
            }
        };
        public static final /* enum */ ContentKind EDGE = new ContentKind(){

            @Override
            Pair<Object, String> parse(String text, int pos, GraphRole role) throws FormatException {
                if (text.charAt(pos) != ':') {
                    throw new FormatException("Can't parse edge pattern declaration", new Object[0]);
                }
                return new Pair<Object, String>(this.parseContent(text.substring(pos + 1), role), "");
            }

            @Override
            LabelPattern parseContent(String text, GraphRole role) throws FormatException {
                return LabelPattern.parse(text);
            }

            @Override
            Object relabel(Object content, TypeLabel oldLabel, TypeLabel newLabel) {
                return ((LabelPattern)content).relabel(oldLabel, newLabel);
            }
        };
        private final SignatureKind signature;
        public static final char PARAM_START_CHAR = '$';
        private static final /* synthetic */ ContentKind[] ENUM$VALUES;

        static {
            ENUM$VALUES = new ContentKind[]{NONE, EMPTY, LEVEL, STRING_LITERAL, BOOL_LITERAL, INT_LITERAL, REAL_LITERAL, MULTIPLICITY, PARAM, NUMBER, NESTED, COLOR, NAME, TEST_EXPR, LET_EXPR, EDGE};
        }

        private ContentKind() {
            this.signature = null;
        }

        private ContentKind(SignatureKind signature) {
            this.signature = signature;
        }

        Pair<Object, String> parse(String text, int pos, GraphRole role) throws FormatException {
            assert (text.indexOf(58, pos) >= 0);
            if (text.charAt(pos) != ':') {
                throw new FormatException("Prefix %s should be followed by '%s' in %s", text.substring(0, pos), ":", text);
            }
            if (this.signature == null || pos == text.length() - 1) {
                return new Pair<Object, String>(null, text.substring(pos + 1));
            }
            String value = text.substring(pos + 1);
            return new Pair<Object, String>(this.parseContent(value, role), "");
        }

        Object parseContent(String text, GraphRole role) throws FormatException {
            Object result;
            if (this.signature == null) {
                throw new UnsupportedOperationException("No content allowed");
            }
            if (role == GraphRole.TYPE) {
                assert (text.length() > 0);
                boolean isIdent = Character.isJavaIdentifierStart(text.charAt(0));
                int i = 1;
                while (isIdent && i < text.length()) {
                    isIdent = Character.isJavaIdentifierPart(text.charAt(i));
                    ++i;
                }
                if (!isIdent) {
                    throw new FormatException("Attributes field '%s' must be identifier", text);
                }
                result = text;
            } else {
                result = Algebras.getConstant(this.signature, text);
                if (result == null) {
                    result = Algebras.getOperator(this.signature, text);
                }
                if (result == null) {
                    throw new FormatException("Signature '%s' has no constant or operator %s", new Object[]{this.signature, text});
                }
            }
            return result;
        }

        String toString(Object content) {
            if (content == null) {
                return "";
            }
            if (content instanceof Constant) {
                return ((Constant)content).getSymbol();
            }
            if (content instanceof Operator) {
                return ((Operator)content).getName();
            }
            if (content instanceof Color) {
                Color color = (Color)content;
                int red = color.getRed();
                int green = color.getGreen();
                int blue = color.getBlue();
                int alpha = color.getAlpha();
                String colorString = alpha == 255 ? "%s,%s,%s" : "%s,%s,%s,%s";
                return String.format(colorString, red, green, blue, alpha);
            }
            return "" + content;
        }

        public String toString(AspectKind aspect, Object content) {
            if (content == null) {
                return aspect.getPrefix();
            }
            if (this == LEVEL || this == MULTIPLICITY) {
                return String.valueOf(aspect.getName()) + '=' + this.toString(content) + ':';
            }
            return String.valueOf(aspect.getPrefix()) + this.toString(content);
        }

        Object relabel(Object content, TypeLabel oldLabel, TypeLabel newLabel) {
            Object result = content;
            if (this.signature != null && content instanceof String && oldLabel.getRole() == EdgeRole.BINARY && oldLabel.text().equals(content)) {
                result = newLabel.text();
            }
            return result;
        }

        private static boolean isValidFirstChar(char c) {
            return Character.isJavaIdentifierStart(c);
        }

        private static boolean isValidNextChar(char c) {
            return Character.isJavaIdentifierPart(c);
        }

        public static ContentKind[] values() {
            ContentKind[] contentKindArray = ENUM$VALUES;
            int n = contentKindArray.length;
            ContentKind[] contentKindArray2 = new ContentKind[n];
            System.arraycopy(ENUM$VALUES, 0, contentKindArray2, 0, n);
            return contentKindArray2;
        }

        public static ContentKind valueOf(String string) {
            return Enum.valueOf(ContentKind.class, string);
        }
    }

    public static enum NestedValue {
        IN("in"),
        AT("@"),
        COUNT("count");

        private final String text;
        public static final String AT_SYMBOL = "at";

        private NestedValue(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }
    }
}

