/*
 * Decompiled with CFR 0.152.
 */
package groove.grammar.model;

import groove.grammar.QualName;
import groove.grammar.Rule;
import groove.grammar.model.FormatErrorSet;
import groove.grammar.model.FormatException;
import groove.grammar.model.GrammarModel;
import groove.grammar.model.ResourceKind;
import groove.grammar.model.RuleModel;
import groove.graph.GraphInfo;
import groove.util.ChangeCount;
import groove.util.Status;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;

public abstract class ResourceModel<R> {
    private final GrammarModel grammar;
    private final ResourceKind kind;
    private final String name;
    private Status status = Status.START;
    private R resource;
    private final FormatErrorSet errors = new FormatErrorSet();
    private final ChangeCount.Tracker grammarTracker;
    private final Map<ResourceKind, ChangeCount.Tracker> resourceTrackers;

    public ResourceModel(GrammarModel grammar, ResourceKind kind, String name) {
        this.grammar = grammar;
        this.kind = kind;
        this.name = name;
        this.grammarTracker = grammar == null ? null : grammar.createChangeTracker();
        this.resourceTrackers = new EnumMap<ResourceKind, ChangeCount.Tracker>(ResourceKind.class);
        ResourceKind[] resourceKindArray = ResourceKind.values();
        int n = resourceKindArray.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceKind rk = resourceKindArray[n2];
            this.resourceTrackers.put(rk, grammar == null ? ChangeCount.DUMMY_TRACKER : grammar.createChangeTracker(rk));
            ++n2;
        }
    }

    public final GrammarModel getGrammar() {
        return this.grammar;
    }

    public final ResourceKind getKind() {
        return this.kind;
    }

    public final boolean isStale(ResourceKind ... kinds) {
        boolean result = false;
        ResourceKind[] resourceKindArray = kinds;
        int n = kinds.length;
        int n2 = 0;
        while (n2 < n) {
            ResourceKind kind = resourceKindArray[n2];
            result |= this.resourceTrackers.get((Object)kind).isStale();
            ++n2;
        }
        return result;
    }

    public final String getFullName() {
        return this.name;
    }

    public String getLastName() {
        return QualName.getLastName(this.getFullName());
    }

    public abstract Object getSource();

    public boolean isEnabled() {
        return this.getGrammar() == null || this.getGrammar().getActiveNames(this.getKind()).contains(this.getFullName());
    }

    public final R toResource() throws FormatException {
        this.synchronise();
        this.getErrors().throwException();
        return this.resource;
    }

    public final FormatErrorSet getErrors() {
        this.synchronise();
        return this.errors;
    }

    public final boolean hasErrors() {
        return !this.getErrors().isEmpty();
    }

    final FormatErrorSet createErrors() {
        return new FormatErrorSet();
    }

    final void synchronise() {
        if (this.isShouldRebuild()) {
            this.notifyWillRebuild();
            this.status = Status.START;
            this.errors.clear();
            try {
                this.resource = this.compute();
                this.status = Status.DONE;
            }
            catch (FormatException e) {
                this.resource = null;
                this.errors.addAll(e.getErrors());
                this.status = Status.ERROR;
            }
        }
    }

    boolean isShouldRebuild() {
        boolean result = false;
        if (this.getGrammar() != null) {
            result = this.grammarTracker.isStale();
        }
        return result;
    }

    void notifyWillRebuild() {
    }

    final Status getStatus() {
        return this.status;
    }

    final R getResource() {
        this.synchronise();
        return this.resource;
    }

    abstract R compute() throws FormatException;

    Collection<Rule> getRules() {
        Collection<ResourceModel<?>> ruleModels = this.getGrammar().getResourceSet(ResourceKind.RULE);
        ArrayList<Rule> result = new ArrayList<Rule>(ruleModels.size());
        for (ResourceModel<?> model : ruleModels) {
            RuleModel ruleModel = (RuleModel)model;
            try {
                if (!GraphInfo.isEnabled(ruleModel.getSource())) continue;
                result.add((Rule)ruleModel.toResource());
            }
            catch (FormatException formatException) {}
        }
        return result;
    }
}

