/*
 * Decompiled with CFR 0.152.
 */
package groove.grammar.rule;

import groove.grammar.rule.LabelVar;
import groove.grammar.rule.RuleEdge;
import groove.grammar.rule.RuleElement;
import groove.grammar.rule.RuleFactory;
import groove.grammar.rule.RuleLabel;
import groove.grammar.rule.RuleNode;
import groove.grammar.type.TypeGuard;
import groove.graph.GraphRole;
import groove.graph.NodeSetEdgeSetGraph;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class RuleGraph
extends NodeSetEdgeSetGraph<RuleNode, RuleEdge> {
    private final Map<LabelVar, Set<RuleElement>> binderMap = new HashMap<LabelVar, Set<RuleElement>>();
    private final Map<LabelVar, Set<RuleElement>> varMap = new HashMap<LabelVar, Set<RuleElement>>();
    private final RuleFactory factory;

    public RuleGraph(String name) {
        this(name, RuleFactory.newInstance());
    }

    public RuleGraph(String name, RuleFactory factory) {
        super(name);
        this.factory = factory;
    }

    private RuleGraph(RuleGraph graph) {
        super(graph);
        this.factory = graph.getFactory();
    }

    @Override
    public GraphRole getRole() {
        return GraphRole.RULE;
    }

    @Override
    public RuleGraph clone() {
        return new RuleGraph(this);
    }

    @Override
    public RuleGraph newGraph(String name) {
        return new RuleGraph(name, this.getFactory());
    }

    @Override
    public Set<RuleEdge> edgeSet() {
        return super.edgeSet();
    }

    @Override
    public Set<RuleNode> nodeSet() {
        return super.nodeSet();
    }

    public RuleFactory getFactory() {
        return this.factory;
    }

    @Override
    public boolean addNode(RuleNode node) {
        boolean result = super.addNode(node);
        if (result) {
            this.addBinders(node);
        }
        return result;
    }

    @Override
    public boolean addEdge(RuleEdge edge) {
        boolean result = super.addEdge(edge);
        if (result) {
            this.addBinders(edge);
            for (LabelVar var : ((RuleLabel)edge.label()).allVarSet()) {
                this.addKey(this.varMap, var).add(edge);
            }
        }
        return result;
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + "; Variables: " + this.varSet();
    }

    private void addBinders(RuleElement element) {
        for (TypeGuard guard : element.getTypeGuards()) {
            LabelVar var = guard.getVar();
            if (!var.hasName()) continue;
            this.addKey(this.varMap, var).add(element);
            this.addKey(this.binderMap, var).add(element);
        }
    }

    public Set<LabelVar> getBoundVars() {
        return this.binderMap.keySet();
    }

    public Set<RuleElement> getBinders(LabelVar var) {
        return this.binderMap.get(var);
    }

    public boolean addVar(LabelVar var) {
        boolean result = !this.varMap.containsKey(var);
        this.addKey(this.varMap, var);
        return result;
    }

    public boolean addVarSet(Collection<LabelVar> varSet) {
        boolean result = false;
        for (LabelVar var : varSet) {
            result |= this.addVar(var);
        }
        return result;
    }

    public boolean containsVar(LabelVar var) {
        return this.varMap.containsKey(var);
    }

    public Set<LabelVar> varSet() {
        return this.varMap.keySet();
    }

    public Map<LabelVar, Set<RuleElement>> varMap() {
        return this.varMap;
    }

    private Set<RuleElement> addKey(Map<LabelVar, Set<RuleElement>> map, LabelVar var) {
        Set<RuleElement> result = map.get(var);
        if (result == null) {
            result = new HashSet<RuleElement>();
            map.put(var, result);
        }
        return result;
    }
}

