/*
 * Decompiled with CFR 0.152.
 */
package groove.grammar.rule;

import groove.grammar.AnchorKind;
import groove.grammar.host.AnchorValue;
import groove.grammar.host.HostEdge;
import groove.grammar.host.HostFactory;
import groove.grammar.host.HostNode;
import groove.grammar.rule.AnchorKey;
import groove.grammar.rule.LabelVar;
import groove.grammar.rule.RuleEdge;
import groove.grammar.rule.RuleLabel;
import groove.grammar.rule.RuleNode;
import groove.grammar.rule.Valuation;
import groove.grammar.rule.VarMap;
import groove.grammar.type.TypeElement;
import groove.grammar.type.TypeGuard;
import groove.grammar.type.TypeLabel;
import groove.graph.AElementBiMap;
import groove.graph.AElementMap;
import groove.graph.Label;
import java.util.LinkedHashMap;
import java.util.Map;

public class RuleToHostMap
extends AElementBiMap<RuleNode, RuleEdge, HostNode, HostEdge>
implements VarMap {
    private final Valuation valuation = this.createValuation();

    public RuleToHostMap(HostFactory factory) {
        super(factory);
    }

    @Override
    public HostNode putNode(RuleNode key, HostNode image) {
        HostNode result = super.putNode(key, image);
        for (TypeGuard guard : key.getTypeGuards()) {
            this.putVar(guard.getVar(), image.getType());
        }
        return result;
    }

    @Override
    public TypeLabel mapLabel(Label label) {
        TypeLabel result;
        RuleLabel ruleLabel = (RuleLabel)label;
        if (ruleLabel.isWildcard()) {
            TypeGuard guard = ruleLabel.getWildcardGuard();
            if (!guard.isNamed()) {
                throw new IllegalArgumentException(String.format("Label %s cannot be mapped", ruleLabel));
            }
            result = this.getVar(guard.getVar()).label();
        } else {
            assert (ruleLabel.isSharp() || ruleLabel.isAtom()) : String.format("Label %s should be sharp or atom", label);
            result = ruleLabel.getTypeLabel();
        }
        return result;
    }

    @Override
    public Valuation getValuation() {
        return this.valuation;
    }

    @Override
    public TypeElement getVar(LabelVar var) {
        return (TypeElement)this.valuation.get(var);
    }

    @Override
    public TypeElement putVar(LabelVar var, TypeElement value) {
        return this.valuation.put(var, value);
    }

    @Override
    public void putAllVar(Valuation valuation) {
        this.valuation.putAll(valuation);
    }

    @Override
    public void putAll(AElementMap<RuleNode, RuleEdge, HostNode, HostEdge> other) {
        super.putAll(other);
        if (other instanceof RuleToHostMap) {
            this.putAllVar(((RuleToHostMap)other).getValuation());
        }
    }

    public AnchorValue put(AnchorKey key, AnchorValue value) {
        AnchorValue result = null;
        switch (key.getAnchorKind()) {
            case NODE: {
                result = this.putNode(AnchorKind.node(key), AnchorKind.node(value));
                break;
            }
            case EDGE: {
                result = this.putEdge(AnchorKind.edge(key), AnchorKind.edge(value));
                break;
            }
            case LABEL: {
                result = this.putVar(AnchorKind.label(key), AnchorKind.label(value));
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return result;
    }

    public AnchorValue get(AnchorKey key) {
        AnchorValue result = null;
        switch (key.getAnchorKind()) {
            case NODE: {
                result = (AnchorValue)this.getNode(AnchorKind.node(key));
                break;
            }
            case EDGE: {
                result = (AnchorValue)this.getEdge(AnchorKind.edge(key));
                break;
            }
            case LABEL: {
                result = this.getVar(AnchorKind.label(key));
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return result;
    }

    @Override
    public void clear() {
        super.clear();
        this.valuation.clear();
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof RuleToHostMap && super.equals(obj) && this.valuation.equals(((RuleToHostMap)obj).getValuation());
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.valuation.hashCode();
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + " Valuation: " + this.valuation;
    }

    public HostFactory getFactory() {
        return (HostFactory)super.getFactory();
    }

    protected Valuation createValuation() {
        return new Valuation();
    }

    @Override
    protected Map<RuleEdge, HostEdge> createEdgeMap() {
        return new LinkedHashMap<RuleEdge, HostEdge>();
    }

    @Override
    protected Map<RuleNode, HostNode> createNodeMap() {
        return new LinkedHashMap<RuleNode, HostNode>();
    }
}

