/*
 * Decompiled with CFR 0.152.
 */
package groove.grammar.type;

import groove.grammar.host.HostEdge;
import groove.grammar.host.HostGraph;
import groove.grammar.host.HostNode;
import groove.grammar.host.ValueNode;
import groove.grammar.model.FormatException;
import groove.grammar.type.TypeLabel;
import groove.graph.EdgeRole;
import groove.util.ExprParser;
import groove.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IllegalFormatException;
import java.util.List;
import java.util.Map;

public class LabelPattern {
    private final String format;
    private final List<String> argNames = new ArrayList<String>();
    private final Map<String, Integer> argPositions = new HashMap<String, Integer>();
    private static ExprParser parser = new ExprParser('\uffff', new char[]{'\"'}, (char[][])new char[0][]);

    public LabelPattern(String format, List<String> argNames) throws FormatException {
        this.format = format;
        this.argNames.addAll(argNames);
        ArrayList testValues1 = new ArrayList();
        ArrayList<String> testValues2 = new ArrayList<String>();
        int i = 0;
        while (i < argNames.size()) {
            this.argPositions.put(argNames.get(i), i);
            testValues1.add(null);
            testValues2.add("");
            ++i;
        }
        try {
            this.getLabel(testValues1.toArray());
            this.getLabel(testValues2.toArray());
        }
        catch (IllegalFormatException illegalFormatException) {
            throw new FormatException("Format string \"%s\" not valid for %d arguments", format, argNames.size());
        }
    }

    public final String getFormat() {
        return this.format;
    }

    public final List<String> getArgNames() throws IllegalFormatException {
        return this.argNames;
    }

    public String getLabel(Object ... values) {
        return String.format(this.getFormat(), values);
    }

    public String getLabel(HostGraph host, HostNode source) {
        Object[] values = new Object[this.argNames.size()];
        for (HostEdge outEdge : host.outEdgeSet(source)) {
            Integer position = this.argPositions.get(outEdge.label().text());
            if (position == null || !(outEdge.target() instanceof ValueNode)) continue;
            values[position.intValue()] = ((ValueNode)outEdge.target()).getSymbol();
        }
        return this.getLabel(values);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.argNames.hashCode();
        result = 31 * result + this.format.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append('\"');
        result.append(this.format);
        result.append('\"');
        for (String argName : this.argNames) {
            result.append(',');
            result.append(argName);
        }
        return result.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LabelPattern other = (LabelPattern)obj;
        if (!this.argNames.equals(other.argNames)) {
            return false;
        }
        return this.format.equals(other.format);
    }

    public LabelPattern relabel(TypeLabel oldLabel, TypeLabel newLabel) {
        LabelPattern result;
        block5: {
            result = this;
            if (oldLabel.getRole() == EdgeRole.BINARY) {
                ArrayList<String> newArgNames = new ArrayList<String>();
                boolean isNew = false;
                int i = 0;
                while (i < this.getArgNames().size()) {
                    String oldArgName = this.getArgNames().get(i);
                    boolean relabel = oldLabel.text().equals(oldArgName);
                    String newArgName = relabel ? newLabel.text() : oldArgName;
                    isNew |= newArgName != oldArgName;
                    newArgNames.add(newArgName);
                    ++i;
                }
                if (isNew) {
                    try {
                        result = new LabelPattern(this.getFormat(), newArgNames);
                    }
                    catch (FormatException formatException) {
                        if ($assertionsDisabled) break block5;
                        throw new AssertionError();
                    }
                }
            }
        }
        return result;
    }

    public static LabelPattern parse(String text) throws FormatException {
        Pair<String, List<String>> result = parser.parse(text);
        String resultText = result.one();
        List<String> resultArgs = result.two();
        if (resultText.charAt(0) != '\uffff' || resultArgs.size() != 1) {
            throw new FormatException("Incorrect label pattern %s", text);
        }
        String format = result.two().get(0).substring(1, result.two().get(0).length() - 1);
        String[] split = resultText.split(",", -1);
        if (split.length == 0 || split[0].length() != 1) {
            throw new FormatException("Incorrect label pattern %s", text);
        }
        ArrayList<String> argNames = new ArrayList<String>();
        int i = 1;
        while (i < split.length) {
            if (!LabelPattern.isIdentifier(split[i])) {
                throw new FormatException("Incorrect attribute name '%s' in label pattern %s", split[i], text);
            }
            argNames.add(split[i]);
            ++i;
        }
        return new LabelPattern(format, argNames);
    }

    private static boolean isIdentifier(String text) {
        boolean result;
        boolean bl = result = text.length() > 0;
        if (result) {
            result = Character.isJavaIdentifierStart(text.charAt(0));
            int i = 1;
            while (result && i < text.length()) {
                result = Character.isJavaIdentifierPart(text.charAt(i));
                ++i;
            }
        }
        return result;
    }
}

