/*
 * Decompiled with CFR 0.152.
 */
package groove.graph;

import groove.graph.Node;

public abstract class ANode
implements Node,
Cloneable {
    private final int nodeNr;
    private int hashCode;

    protected ANode(int nr) {
        this.nodeNr = nr;
    }

    public Object clone() {
        return this;
    }

    public final int hashCode() {
        if (this.hashCode == 0) {
            int result = this.computeHashCode();
            this.hashCode = result == 0 ? 1 : result;
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Node)) {
            return false;
        }
        Node other = (Node)obj;
        if (this.getNumber() != other.getNumber()) {
            return false;
        }
        return this.getClass() == other.getClass();
    }

    public String toString() {
        return String.valueOf(this.getToStringPrefix()) + this.nodeNr;
    }

    protected abstract String getToStringPrefix();

    public int compareTo(Node obj) {
        int result = this.getNumber() - obj.getNumber();
        if (result == 0) {
            result = this.getClass().getName().compareTo(obj.getClass().getName());
        }
        assert (result != 0 || this.equals(obj)) : String.format("Ordering of distinct objects %s and %s yields 0", this, obj);
        return result;
    }

    @Override
    public int getNumber() {
        return this.nodeNr;
    }

    protected int computeHashCode() {
        int h = this.nodeNr + 2 ^ this.getClass().hashCode();
        h *= h;
        h += ~(h << 14);
        h ^= h >>> 19;
        h += h << 9;
        h ^= h >>> 15;
        return h;
    }
}

