/*
 * Decompiled with CFR 0.152.
 */
package groove.graph.iso;

import groove.grammar.host.HostElement;
import groove.grammar.host.ValueNode;
import groove.grammar.type.TypeLabel;
import groove.graph.Edge;
import groove.graph.Element;
import groove.graph.Graph;
import groove.graph.Label;
import groove.graph.Node;
import groove.graph.iso.CertificateStrategy;
import groove.util.collect.IntSet;
import groove.util.collect.TreeIntSet;

public class Bisimulator
extends CertificateStrategy {
    private int nodePartitionCount;
    private static final int TREE_RESOLUTION = 3;
    private static final int MAX_BREAK_SYMMETRY = 10;
    private static final IntSet certStore = new TreeIntSet(3);
    private static final boolean USE_EDGE1_CERTIFICATES = true;
    private static final boolean BREAK_SYMMETRIES = false;
    private static int totalSymmetryBreakCount;

    public Bisimulator(Graph graph) {
        super(graph);
    }

    @Override
    public CertificateStrategy newInstance(Graph graph, boolean strong) {
        return new Bisimulator(graph);
    }

    @Override
    public int getNodePartitionCount() {
        if (this.nodePartitionCount == 0) {
            this.computeCertificates();
        }
        return this.nodePartitionCount;
    }

    @Override
    public boolean getStrength() {
        return true;
    }

    @Override
    void iterateCertificates() {
        long certificateValue;
        boolean goOn;
        IntSet certStore = Bisimulator.certStore;
        int nodeCertCount = this.nodeCertCount;
        int partitionCount = 0;
        int iterateCount = 0;
        do {
            certificateValue = nodeCertCount;
            certStore.clear(nodeCertCount);
            int i = 0;
            while (i < this.edge2CertCount) {
                MyEdge2Cert edgeCert = (MyEdge2Cert)this.edgeCerts[i];
                certificateValue += (long)edgeCert.setNewValue();
                ++i;
            }
            int minCertValue = Integer.MAX_VALUE;
            MyNodeCert minCert = null;
            CertificateStrategy.NodeCertificate[] nodeCertificateArray = this.nodeCerts;
            int n = this.nodeCerts.length;
            int n2 = 0;
            while (n2 < n) {
                CertificateStrategy.NodeCertificate nodeCert = nodeCertificateArray[n2];
                int newCert = ((MyNodeCert)nodeCert).setNewValue();
                if (iterateCount > 0 && partitionCount < nodeCertCount && !certStore.add(newCert) && minCert == null) {
                    minCertValue = newCert;
                    minCert = (MyNodeCert)nodeCert;
                }
                certificateValue += (long)newCert;
                ++n2;
            }
            int newPartitionCount = certStore.size();
            if (iterateCount == 0) {
                goOn = true;
            } else {
                boolean bl = goOn = newPartitionCount > partitionCount;
            }
            if (partitionCount < nodeCertCount) {
                partitionCount = newPartitionCount;
            }
            ++iterateCount;
        } while (goOn);
        this.nodePartitionCount = partitionCount;
        this.graphCertificate = certificateValue;
        int edgeCount = this.edgeCerts.length;
        int i = this.edge2CertCount;
        while (i < edgeCount) {
            ((MyEdge1Cert)this.edgeCerts[i]).setNewValue();
            ++i;
        }
        Bisimulator.recordIterateCount(iterateCount);
    }

    @Override
    MyNodeCert getNodeCert(Node node) {
        return (MyNodeCert)super.getNodeCert(node);
    }

    @Override
    MyNodeCert createValueNodeCertificate(ValueNode node) {
        return new MyValueNodeCert(node);
    }

    @Override
    MyNodeCert createNodeCertificate(Node node) {
        return new MyNodeCert(node);
    }

    @Override
    CertificateStrategy.EdgeCertificate createEdge1Certificate(Edge edge, CertificateStrategy.NodeCertificate source) {
        return new MyEdge1Cert(edge, (MyNodeCert)source);
    }

    @Override
    CertificateStrategy.EdgeCertificate createEdge2Certificate(Edge edge, CertificateStrategy.NodeCertificate source, CertificateStrategy.NodeCertificate target) {
        return new MyEdge2Cert(edge, (MyNodeCert)source, (MyNodeCert)target);
    }

    public static int getSymmetryBreakCount() {
        return totalSymmetryBreakCount;
    }

    public static abstract class Certificate<EL extends Element>
    implements CertificateStrategy.ElementCertificate<EL> {
        protected int value;
        private final EL element;

        Certificate(EL element) {
            this.element = element;
        }

        public int hashCode() {
            return this.value;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            Certificate other = (Certificate)obj;
            return this.value == other.value;
        }

        @Override
        public int getValue() {
            return this.value;
        }

        @Override
        public void modifyValue(int mod) {
            this.value += mod;
        }

        protected int setNewValue() {
            this.value = this.computeNewValue();
            return this.value;
        }

        protected abstract int computeNewValue();

        @Override
        public EL getElement() {
            return this.element;
        }
    }

    private static class MyEdge1Cert
    extends Certificate<Edge>
    implements CertificateStrategy.EdgeCertificate {
        private final MyNodeCert source;
        private final Label label;
        private final int initValue;

        public MyEdge1Cert(Edge edge, MyNodeCert source) {
            super(edge);
            this.source = source;
            this.label = edge.label();
            this.initValue = this.label.hashCode();
            this.initValue();
            source.addValue(this.value);
        }

        public String toString() {
            return "[" + this.source + "," + ((Edge)this.getElement()).label() + "(" + this.initValue + ")]";
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            MyEdge1Cert other = (MyEdge1Cert)obj;
            return this.source.equals(other.source) && !this.label.equals(other.label);
        }

        @Override
        protected int computeNewValue() {
            int sourceHashCode = this.source.hashCode();
            int result = (sourceHashCode << 8) + (sourceHashCode >> 24) + this.value;
            return result;
        }

        protected void initValue() {
            this.value = this.initValue << 4;
        }
    }

    private static class MyEdge2Cert
    extends Certificate<Edge>
    implements CertificateStrategy.EdgeCertificate {
        private final MyNodeCert source;
        private final MyNodeCert target;
        private final Label label;
        private final int initValue;

        public MyEdge2Cert(Edge edge, MyNodeCert source, MyNodeCert target) {
            super(edge);
            this.source = source;
            this.target = target;
            this.label = edge.label();
            this.initValue = this.label.hashCode();
            this.initValue();
            source.addValue(this.value);
            target.addValue(this.value << 1);
        }

        public String toString() {
            return "[" + this.source + "," + ((Edge)this.getElement()).label() + "(" + this.initValue + ")," + this.target + "]";
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            MyEdge2Cert other = (MyEdge2Cert)obj;
            if (!this.source.equals(other.source) || !this.label.equals(other.label)) {
                return false;
            }
            if (this.target == this.source) {
                return other.target == other.source;
            }
            return this.target.equals(other.target);
        }

        @Override
        protected int computeNewValue() {
            int targetShift = (this.initValue & 0xF) + 1;
            int sourceHashCode = this.source.value;
            int targetHashCode = this.target.value;
            int result = (sourceHashCode << 8 | sourceHashCode >>> 24) + (targetHashCode << targetShift | targetHashCode >>> targetShift) + this.value;
            this.source.nextValue += 2 * result;
            this.target.nextValue -= 3 * result;
            return result;
        }

        protected void initValue() {
            this.value = this.initValue;
        }
    }

    private static class MyNodeCert
    extends Certificate<Node>
    implements CertificateStrategy.NodeCertificate {
        private static final int INIT_NODE_VALUE = 4715;
        private final TypeLabel type;
        int nextValue;

        public MyNodeCert(Node node) {
            super(node);
            if (node instanceof HostElement) {
                this.type = ((HostElement)((Object)node)).getType().label();
                this.value = this.type.hashCode();
            } else {
                this.type = null;
                this.value = 4715;
            }
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.type == null) {
                return true;
            }
            MyNodeCert other = (MyNodeCert)obj;
            return this.type.equals(other.type);
        }

        public String toString() {
            return "c" + this.value;
        }

        public void breakSymmetry() {
            this.value += this.value << 1;
        }

        @Override
        protected int computeNewValue() {
            int result = this.nextValue ^ this.value;
            this.nextValue = 0;
            return result;
        }

        protected void addValue(int inc) {
            this.value += inc;
        }

        protected void addNextValue(int value) {
            this.nextValue += value;
        }
    }

    private static class MyValueNodeCert
    extends MyNodeCert {
        private final Object nodeValue;

        public MyValueNodeCert(ValueNode node) {
            super(node);
            this.nodeValue = node.getValue();
            this.value = this.nodeValue.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            return obj instanceof MyValueNodeCert && this.nodeValue.equals(((MyValueNodeCert)obj).nodeValue);
        }

        @Override
        protected int computeNewValue() {
            int result = this.nextValue ^ this.value;
            this.nextValue = 0;
            return result;
        }
    }
}

