/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.action;

import groove.grammar.aspect.AspectGraph;
import groove.grammar.model.ResourceKind;
import groove.gui.Simulator;
import groove.gui.action.SimulatorAction;
import groove.io.store.EditType;
import java.io.IOException;

public class CopyAction
extends SimulatorAction {
    public CopyAction(Simulator simulator, ResourceKind kind) {
        super(simulator, EditType.COPY, kind);
    }

    @Override
    public void execute() {
        String newName;
        String oldName = this.getSimulatorModel().getSelected(this.getResourceKind());
        if (this.getDisplay().saveEditor(oldName, true, false) && (newName = this.askNewName(oldName, true)) != null) {
            this.doCopy(oldName, newName);
        }
    }

    private boolean doCopy(String oldName, String newName) {
        boolean result = false;
        ResourceKind resourceKind = this.getResourceKind();
        if (resourceKind.isTextBased()) {
            String text = this.getGrammarStore().getTexts(resourceKind).get(oldName);
            result = this.getActions().getSaveAction(resourceKind).doSaveText(newName, text);
        } else {
            AspectGraph host = this.getGrammarStore().getGraphs(resourceKind).get(oldName);
            AspectGraph newHost = host.rename(newName);
            try {
                this.getSimulatorModel().doAddGraph(resourceKind, newHost, false);
                result = true;
            }
            catch (IOException exc) {
                this.showErrorDialog(exc, String.format("Error while copying %s '%s' to '%s'", resourceKind.getDescription(), oldName, newName), new Object[0]);
            }
        }
        return result;
    }

    @Override
    public void refresh() {
        this.setEnabled(this.getSimulatorModel().getSelectSet(this.getResourceKind()).size() == 1 && this.getGrammarStore().isModifiable());
    }
}

