/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.action;

import groove.grammar.groovy.Util;
import groove.grammar.model.GroovyModel;
import groove.grammar.model.ResourceKind;
import groove.gui.Icons;
import groove.gui.Simulator;
import groove.gui.action.SimulatorAction;
import groove.gui.display.GroovyDisplay;
import groove.io.HTMLConverter;

public class ExecGroovyAction
extends SimulatorAction {
    private static final long serialVersionUID = 1652912426926686879L;
    private final boolean enabled = Util.isGroovyPresent();
    private static final String DESCRIPTION = "Execute Groovy script";
    private static final String DISABLED_DESCRIPTION = "To enable, insert the Groovy jars in the Groove bin directory";

    public ExecGroovyAction(Simulator simulator) {
        super(simulator, DESCRIPTION, Icons.GO_START_ICON, null, ResourceKind.GROOVY);
        if (!this.enabled) {
            StringBuilder descr = new StringBuilder(DESCRIPTION);
            descr.append(HTMLConverter.HTML_LINEBREAK);
            descr.append(DISABLED_DESCRIPTION);
            HTMLConverter.HTML_TAG.on(descr);
            this.putValue("ShortDescription", descr.toString());
        }
    }

    @Override
    public void execute() {
        for (String name : this.getSimulatorModel().getSelectSet(this.getResourceKind())) {
            GroovyModel model = (GroovyModel)this.getGrammarModel().getResource(ResourceKind.GROOVY, name);
            if (!model.isEnabled()) continue;
            ((GroovyDisplay)this.getDisplay()).executeGroovy(name);
        }
    }

    @Override
    public void refresh() {
        boolean enabled = this.enabled;
        if (enabled) {
            enabled = !this.getSimulatorModel().getSelectSet(this.getResourceKind()).isEmpty();
        }
        this.setEnabled(enabled);
    }
}

