/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.action;

import groove.explore.AcceptorValue;
import groove.explore.Exploration;
import groove.explore.StrategyValue;
import groove.grammar.model.FormatException;
import groove.grammar.model.GrammarModel;
import groove.gui.Icons;
import groove.gui.Options;
import groove.gui.Simulator;
import groove.gui.SimulatorModel;
import groove.gui.action.SimulatorAction;
import groove.gui.dialog.ExploreWarningDialog;
import groove.gui.display.DisplayKind;
import groove.gui.jgraph.LTSJModel;
import groove.io.HTMLConverter;
import groove.lts.GTS;
import groove.lts.GTSAdapter;
import groove.lts.GTSListener;
import groove.lts.GraphState;
import groove.lts.GraphTransition;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicSliderUI;

public class ExploreAction
extends SimulatorAction {
    private Exploration stateExploration;
    private JPanel animationPanel;
    private JLabel transitionCountLabel;
    private JLabel stateCountLabel;
    private final boolean animated;
    private int speed = 2;
    private int bound;
    private boolean interrupted;
    private static final int INITIAL_STATE_BOUND = 1000;

    public ExploreAction(Simulator simulator, boolean animated) {
        super(simulator, animated ? "Animate State Exploration" : "Explore State Space", animated ? Icons.GO_START_ICON : Icons.GO_FORWARD_ICON);
        if (!animated) {
            this.putValue("AcceleratorKey", Options.DEFAULT_EXPLORATION_KEY);
        }
        this.animated = animated;
    }

    @Override
    public void execute() {
        this.explore(this.getSimulatorModel().getExploration(), true, true);
    }

    public void doExploreState() {
        GraphState state = this.getSimulatorModel().getState();
        this.explore(this.getStateExploration(), true, true);
        this.getSimulatorModel().doSetStateAndMatch(state, null);
    }

    public void explore(Exploration exploration, boolean setResult, boolean emphasise) {
        GraphState lastState;
        LTSJModel ltsJModel = this.getLtsDisplay().getJModel();
        if (ltsJModel == null) {
            if (this.getSimulatorModel().setGts()) {
                ltsJModel = this.getLtsDisplay().getJModel();
            } else {
                return;
            }
        }
        GTS gts = this.getSimulatorModel().getGts();
        if (this.isAnimated()) {
            this.getSimulatorModel().setDisplay(DisplayKind.LTS);
        }
        gts.removeLTSListener(ltsJModel);
        this.bound = 1000;
        ExploreThread generateThread = new ExploreThread(exploration);
        this.getSimulatorModel().getExplorationStats().start();
        ((Thread)generateThread).start();
        this.getSimulatorModel().getExplorationStats().stop();
        this.getSimulatorModel().setGts(gts, true);
        gts.addLTSListener(ltsJModel);
        if (setResult) {
            gts.setResult(exploration.getLastResult());
        }
        if ((lastState = exploration.getLastState()) != null) {
            this.getSimulatorModel().setState(lastState);
        }
        if (emphasise) {
            Collection<GraphState> result = exploration.getLastResult().getValue();
            this.getLtsDisplay().emphasiseStates(new ArrayList<GraphState>(result), true);
        }
        if (this.isAnimated() && exploration.getLastState() != null) {
            this.getSimulatorModel().setState(exploration.getLastState());
        }
    }

    @Override
    public void refresh() {
        GrammarModel grammar = this.getSimulatorModel().getGrammar();
        Exploration exploration = this.getSimulatorModel().getExploration();
        boolean enabled = grammar != null && grammar.getStartGraphModel() != null && !grammar.hasErrors() && grammar.hasRules();
        FormatException compatibilityError = null;
        if (enabled) {
            try {
                exploration.test(grammar.toGrammar());
            }
            catch (FormatException exc) {
                compatibilityError = exc;
                enabled = false;
            }
        }
        this.setEnabled(enabled);
        String toolTipText = String.format("%s (%s)", this.animated ? "Animate State Exploration" : "Explore State Space", HTMLConverter.STRONG_TAG.on(exploration.getIdentifier()));
        if (compatibilityError != null) {
            toolTipText = String.valueOf(toolTipText) + HTMLConverter.HTML_LINEBREAK + HTMLConverter.EMBARGO_TAG.on(HTMLConverter.toHtml(compatibilityError.getMessage()));
        }
        this.putValue("ShortDescription", HTMLConverter.HTML_TAG.on(toolTipText));
    }

    final boolean isAnimated() {
        return this.animated;
    }

    final int getPause() {
        return 4000 / (this.getSpeed() + 1);
    }

    final int getSpeed() {
        return this.speed;
    }

    final void setSpeed(int speed) {
        this.speed = Math.min(10, Math.max(speed, 1));
    }

    final JLabel getStateCountLabel() {
        if (this.stateCountLabel == null) {
            this.stateCountLabel = new JLabel();
        }
        return this.stateCountLabel;
    }

    final JLabel getTransitionCountLabel() {
        if (this.transitionCountLabel == null) {
            this.transitionCountLabel = new JLabel();
        }
        return this.transitionCountLabel;
    }

    final JPanel getAnimationPanel() {
        if (this.animationPanel == null) {
            JLabel label = new JLabel("Animation Speed");
            label.setAlignmentX(0.5f);
            final JSlider slider = new JSlider(0, 1, 10, 2){

                @Override
                public void updateUI() {
                    this.setUI(BasicSliderUI.createUI(this));
                }
            };
            slider.setMajorTickSpacing(9);
            slider.setMinorTickSpacing(1);
            slider.setSnapToTicks(true);
            slider.setPaintTicks(true);
            slider.setPaintLabels(true);
            slider.setFocusable(false);
            slider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    int speed = slider.getValue();
                    ExploreAction.this.setSpeed(speed);
                }
            });
            slider.setAlignmentX(0.5f);
            this.animationPanel = new JPanel();
            this.animationPanel.setLayout(new BoxLayout(this.animationPanel, 1));
            this.animationPanel.add(label);
            this.animationPanel.add(slider);
        }
        return this.animationPanel;
    }

    final void displayProgress(final GTS gts) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ExploreAction.this.getStateCountLabel().setText("States: " + gts.nodeCount());
                ExploreAction.this.getTransitionCountLabel().setText("Transitions: " + gts.edgeCount());
            }
        });
    }

    final void checkContinue(GTS gts) {
        if (gts.nodeCount() >= this.bound && !this.isInterrupted()) {
            block5: {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            ExploreWarningDialog dialog = ExploreWarningDialog.instance();
                            dialog.setBound(ExploreAction.this.bound);
                            if (dialog.ask(ExploreAction.this.getFrame())) {
                                ExploreAction.this.bound = dialog.getBound();
                            } else {
                                ExploreAction.this.setInterrupted(true);
                            }
                        }
                    });
                }
                catch (InterruptedException interruptedException) {
                    this.setInterrupted(true);
                }
                catch (InvocationTargetException e) {
                    e.getCause().printStackTrace();
                    if ($assertionsDisabled) break block5;
                    throw new AssertionError();
                }
            }
            if (this.isInterrupted()) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private Exploration getStateExploration() {
        if (this.stateExploration == null) {
            this.stateExploration = new Exploration(StrategyValue.STATE, AcceptorValue.NONE, 0);
        }
        return this.stateExploration;
    }

    private boolean isInterrupted() {
        return this.interrupted;
    }

    private void setInterrupted(boolean interrupted) {
        this.interrupted = interrupted;
    }

    private final class AnimateListener
    extends GTSAdapter {
        private AnimateListener() {
        }

        @Override
        public void addUpdate(GTS gts, final GraphState state) {
            ExploreAction.this.displayProgress(gts);
            try {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            ExploreAction.this.getSimulatorModel().setState(state);
                        }
                    });
                }
                catch (InvocationTargetException invocationTargetException) {}
                Thread.sleep(ExploreAction.this.getPause());
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }

        @Override
        public void addUpdate(GTS gts, GraphTransition transition) {
            ExploreAction.this.displayProgress(gts);
        }
    }

    private final class ExploreListener
    extends GTSAdapter {
        private ExploreListener() {
        }

        @Override
        public void addUpdate(GTS gts, GraphState state) {
            ExploreAction.this.displayProgress(gts);
            ExploreAction.this.checkContinue(gts);
        }

        @Override
        public void addUpdate(GTS gts, GraphTransition transition) {
            ExploreAction.this.displayProgress(gts);
        }
    }

    private class ExploreThread
    extends Thread {
        private final Exploration exploration;
        private final JDialog cancelDialog = this.createCancelDialog();
        private JButton cancelButton;
        private final GTSListener progressListener = this.createProgressListener();

        public ExploreThread(Exploration exploration) {
            this.exploration = exploration;
        }

        @Override
        public void start() {
            ExploreThread.super.start();
            this.cancelDialog.setVisible(true);
            try {
                this.join();
            }
            catch (InterruptedException interruptedException) {}
            this.cancelDialog.dispose();
        }

        @Override
        public final void run() {
            SimulatorModel simulatorModel = ExploreAction.this.getSimulatorModel();
            GTS gts = simulatorModel.getGts();
            ExploreAction.this.displayProgress(gts);
            gts.addLTSListener(this.progressListener);
            ExploreAction.this.setInterrupted(false);
            GraphState state = simulatorModel.getState();
            try {
                this.exploration.play(gts, state);
            }
            catch (FormatException exc) {
                ExploreAction.this.showErrorDialog(exc, "Exploration strategy %s incompatible with grammar", this.exploration.getIdentifier());
            }
            gts.removeLTSListener(this.progressListener);
            this.disposeCancelDialog();
        }

        private JDialog createCancelDialog() {
            Object[] objectArray;
            if (ExploreAction.this.isAnimated()) {
                objectArray = ExploreAction.this.getAnimationPanel();
            } else {
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = ExploreAction.this.getStateCountLabel();
                objectArray = objectArray2;
                objectArray2[1] = ExploreAction.this.getTransitionCountLabel();
            }
            JOptionPane message = new JOptionPane(objectArray, -1);
            message.setOptions(new Object[]{this.getCancelButton()});
            JDialog result = message.createDialog(ExploreAction.this.getFrame(), "Exploring state space");
            result.pack();
            result.setDefaultCloseOperation(2);
            result.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    ExploreThread.this.interrupt();
                }
            });
            return result;
        }

        private void disposeCancelDialog() {
            assert (!SwingUtilities.isEventDispatchThread());
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        ExploreThread.this.cancelDialog.dispose();
                    }
                });
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        }

        private JButton getCancelButton() {
            if (this.cancelButton == null) {
                this.cancelButton = new JButton("Cancel");
                this.cancelButton.addActionListener(this.createCancelListener());
            }
            return this.cancelButton;
        }

        private ActionListener createCancelListener() {
            return new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ExploreThread.this.interrupt();
                }
            };
        }

        private GTSListener createProgressListener() {
            return ExploreAction.this.isAnimated() ? new AnimateListener() : new ExploreListener();
        }
    }
}

