/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.action;

import groove.gui.Icons;
import groove.gui.Options;
import groove.gui.jgraph.JCell;
import groove.gui.jgraph.JGraph;
import groove.gui.layout.Layouter;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class LayoutAction
extends AbstractAction {
    private final JGraph<?> jGraph;

    public LayoutAction(JGraph<?> jGraph) {
        super(jGraph.getLayouter().getName(), Icons.LAYOUT_ICON);
        this.putValue("AcceleratorKey", Options.LAYOUT_KEY);
        this.jGraph = jGraph;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.jGraph.isEnabled()) {
            this.doLayout();
        }
    }

    public void doLayout() {
        Object[] selection = this.jGraph.getSelectionCells();
        this.jGraph.getModel().setLayoutable(selection.length == 0);
        Object[] objectArray = selection;
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            Object jCell = objectArray[n2];
            if (jCell instanceof JCell) {
                ((JCell)jCell).setLayoutable(true);
            }
            ++n2;
        }
        this.getLayouter().start();
    }

    @Override
    public Object getValue(String key) {
        if (key.equals("Name")) {
            return this.getLayouter().getName();
        }
        return super.getValue(key);
    }

    private Layouter getLayouter() {
        return this.jGraph.getLayouter();
    }
}

