/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.action;

import groove.grammar.aspect.AspectGraph;
import groove.grammar.model.ResourceKind;
import groove.gui.Options;
import groove.gui.Simulator;
import groove.gui.action.SimulatorAction;
import groove.io.store.EditType;
import java.io.IOException;
import javax.swing.SwingUtilities;

public class NewAction
extends SimulatorAction {
    public NewAction(Simulator simulator, ResourceKind resource) {
        super(simulator, EditType.CREATE, resource);
    }

    @Override
    public void execute() {
        ResourceKind resource = this.getResourceKind();
        final String newName = this.askNewName(Options.getNewResourceName(resource), true);
        if (newName != null) {
            try {
                if (resource.isGraphBased()) {
                    AspectGraph newGraph = AspectGraph.emptyGraph(newName, resource.getGraphRole());
                    this.getSimulatorModel().doAddGraph(resource, newGraph, false);
                } else {
                    this.getSimulatorModel().doAddText(this.getResourceKind(), newName, "");
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        NewAction.this.getDisplay().startEditResource(newName);
                    }
                });
            }
            catch (IOException e) {
                this.showErrorDialog(e, "Error creating new %s '%s'", resource.getDescription(), newName);
            }
        }
    }

    @Override
    public void refresh() {
        this.setEnabled(this.getGrammarStore() != null && this.getGrammarStore().isModifiable());
    }
}

