/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.action;

import groove.grammar.model.ResourceKind;
import groove.grammar.model.RuleModel;
import groove.gui.Simulator;
import groove.gui.action.SimulatorAction;
import groove.gui.dialog.NumberDialog;
import java.io.IOException;
import java.util.HashMap;

public class SetPriorityAction
extends SimulatorAction {
    public SetPriorityAction(Simulator simulator) {
        super(simulator, "Set Priority", null);
    }

    @Override
    public void refresh() {
        boolean ruleSelected = this.getSimulatorModel().isSelected(ResourceKind.RULE);
        this.setEnabled(ruleSelected && this.getSimulatorModel().getStore().isModifiable());
    }

    @Override
    public void execute() {
        RuleModel ruleModel = (RuleModel)this.getSimulatorModel().getGraphResource(ResourceKind.RULE);
        NumberDialog dialog = new NumberDialog("New priority: ");
        if (dialog.showDialog(this.getFrame(), "Set Priority", ruleModel.getPriority())) {
            HashMap<String, Integer> priorityMap = new HashMap<String, Integer>();
            for (String name : this.getSimulatorModel().getSelectSet(ResourceKind.RULE)) {
                priorityMap.put(name, dialog.getResult());
            }
            if (!priorityMap.isEmpty()) {
                try {
                    this.getSimulatorModel().doSetPriority(priorityMap);
                }
                catch (IOException exc) {
                    this.showErrorDialog(exc, "Error during rule priority change", new Object[0]);
                }
            }
        }
    }
}

