/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.action;

import groove.grammar.QualName;
import groove.grammar.model.FormatException;
import groove.grammar.model.GrammarModel;
import groove.grammar.model.ResourceKind;
import groove.grammar.type.TypeLabel;
import groove.gui.BehaviourOption;
import groove.gui.Icons;
import groove.gui.Options;
import groove.gui.Simulator;
import groove.gui.SimulatorModel;
import groove.gui.action.ActionStore;
import groove.gui.action.Refreshable;
import groove.gui.dialog.ErrorDialog;
import groove.gui.dialog.FindReplaceDialog;
import groove.gui.dialog.FreshNameDialog;
import groove.gui.dialog.SaveDialog;
import groove.gui.display.ControlDisplay;
import groove.gui.display.DisplayKind;
import groove.gui.display.DisplaysPanel;
import groove.gui.display.GroovyDisplay;
import groove.gui.display.LTSDisplay;
import groove.gui.display.PrologDisplay;
import groove.gui.display.ResourceDisplay;
import groove.gui.display.RuleDisplay;
import groove.gui.display.StateDisplay;
import groove.io.ExtensionFilter;
import groove.io.FileType;
import groove.io.GrooveFileChooser;
import groove.io.store.EditType;
import groove.io.store.SystemStore;
import groove.util.Duo;
import groove.util.Groove;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.LinkedList;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public abstract class SimulatorAction
extends AbstractAction
implements Refreshable {
    private final Simulator simulator;
    private final EditType edit;
    private final ResourceKind resource;

    protected SimulatorAction(Simulator simulator, String name, Icon icon, EditType edit, ResourceKind resource) {
        super(name, icon);
        this.simulator = simulator;
        this.resource = resource;
        this.edit = edit;
        this.putValue("ShortDescription", name);
        this.setEnabled(false);
        if (simulator != null) {
            simulator.getActions().addRefreshable(this);
        }
    }

    protected SimulatorAction(Simulator simulator, String name, Icon icon) {
        this(simulator, name, icon, null, null);
    }

    protected SimulatorAction(Simulator simulator, EditType edit, ResourceKind resource) {
        this(simulator, Options.getEditActionName(edit, resource, false), Icons.getEditIcon(edit, resource), edit, resource);
    }

    protected String getEditActionName() {
        if (this.getEditType() == null) {
            return null;
        }
        return Options.getEditActionName(this.getEditType(), this.getResourceKind(), false);
    }

    protected final Simulator getSimulator() {
        return this.simulator;
    }

    protected final SimulatorModel getSimulatorModel() {
        return this.getSimulator().getModel();
    }

    protected final GrammarModel getGrammarModel() {
        return this.getSimulatorModel().getGrammar();
    }

    protected final SystemStore getGrammarStore() {
        return this.getSimulatorModel().getStore();
    }

    protected final ActionStore getActions() {
        return this.getSimulator().getActions();
    }

    protected final JFrame getFrame() {
        return this.getSimulator().getFrame();
    }

    protected final DisplaysPanel getDisplaysPanel() {
        return this.getSimulator().getDisplaysPanel();
    }

    protected final ResourceDisplay getDisplay() {
        if (this.getResourceKind() == null) {
            throw new IllegalStateException();
        }
        switch (this.getResourceKind()) {
            case CONTROL: {
                return this.getControlDisplay();
            }
            case HOST: {
                return this.getHostDisplay();
            }
            case PROLOG: {
                return this.getPrologDisplay();
            }
            case RULE: {
                return this.getRuleDisplay();
            }
            case TYPE: {
                return this.getTypeDisplay();
            }
            case GROOVY: {
                return this.getGroovyDisplay();
            }
        }
        assert (false);
        return null;
    }

    protected final ResourceDisplay getHostDisplay() {
        return (ResourceDisplay)this.getDisplaysPanel().getDisplay(DisplayKind.HOST);
    }

    protected final RuleDisplay getRuleDisplay() {
        return (RuleDisplay)this.getDisplaysPanel().getDisplay(DisplayKind.RULE);
    }

    protected final ResourceDisplay getTypeDisplay() {
        return (ResourceDisplay)this.getDisplaysPanel().getDisplay(DisplayKind.TYPE);
    }

    protected final ControlDisplay getControlDisplay() {
        return (ControlDisplay)this.getDisplaysPanel().getDisplay(DisplayKind.CONTROL);
    }

    protected final PrologDisplay getPrologDisplay() {
        return (PrologDisplay)this.getDisplaysPanel().getDisplay(DisplayKind.PROLOG);
    }

    protected final GroovyDisplay getGroovyDisplay() {
        return (GroovyDisplay)this.getDisplaysPanel().getDisplay(DisplayKind.GROOVY);
    }

    protected final LTSDisplay getLtsDisplay() {
        return (LTSDisplay)this.getDisplaysPanel().getDisplay(DisplayKind.LTS);
    }

    protected final StateDisplay getStateDisplay() {
        return (StateDisplay)this.getDisplaysPanel().getDisplay(DisplayKind.STATE);
    }

    protected final EditType getEditType() {
        return this.edit;
    }

    protected final ResourceKind getResourceKind() {
        return this.resource;
    }

    public void dispose() {
        this.getActions().removeRefreshable(this);
    }

    @Override
    public void refresh() {
        this.setEnabled(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.execute();
    }

    public abstract void execute();

    protected final String askNewName(String name, boolean mustBeFresh) {
        ResourceKind kind = this.getResourceKind();
        String title = String.format("Select %s%s name", mustBeFresh ? "new " : "", kind.getDescription());
        Set<String> existingNames = this.getSimulatorModel().getGrammar().getNames(kind);
        FreshNameDialog<String> nameDialog = new FreshNameDialog<String>(existingNames, name, mustBeFresh){

            @Override
            protected String createName(String name) {
                return name;
            }
        };
        nameDialog.showDialog(this.getFrame(), title);
        return (String)nameDialog.getName();
    }

    protected final File askSaveResource(String name) {
        ExtensionFilter filter = this.getResourceKind().getFilter();
        GrooveFileChooser chooser = GrooveFileChooser.getFileChooser(filter);
        chooser.setSelectedFile(new File(name));
        return SaveDialog.show(chooser, this.getFrame(), null);
    }

    protected final Duo<TypeLabel> askFindSearch(TypeLabel oldLabel) {
        Duo<Object> result;
        FindReplaceDialog dialog = new FindReplaceDialog(this.getSimulatorModel().getGrammar().getTypeGraph(), oldLabel);
        int dialogResult = dialog.showDialog(this.getFrame(), null);
        switch (dialogResult) {
            case 1: {
                result = new Duo<Object>(dialog.getOldLabel(), null);
                break;
            }
            case 2: {
                result = new Duo<TypeLabel>(dialog.getOldLabel(), dialog.getNewLabel());
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    protected final void showErrorDialog(Throwable exc, String message, Object ... args) {
        final ErrorDialog dialog = new ErrorDialog((Component)this.getFrame(), String.format(message, args), exc);
        if (SwingUtilities.isEventDispatchThread()) {
            dialog.setVisible(true);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        dialog.setVisible(true);
                    }
                });
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
    }

    protected final boolean confirmBehaviourOption(String option) {
        return this.confirmBehaviour(option, null);
    }

    protected final boolean confirmBehaviour(String option, String question) {
        BehaviourOption menu = (BehaviourOption)this.getSimulator().getOptions().getItem(option);
        return menu.confirm(this.getFrame(), question);
    }

    protected final boolean confirmOverwrite(String name) {
        return this.confirmOverwrite(this.getResourceKind(), name);
    }

    protected final boolean confirmOverwrite(ResourceKind resource, String name) {
        int response = JOptionPane.showConfirmDialog(this.getFrame(), String.format("Replace existing %s '%s'?", resource.getDescription(), name), null, 2);
        return response == 0;
    }

    protected final boolean confirmOverwriteGrammar(File grammarFile) {
        if (grammarFile.exists()) {
            int response = JOptionPane.showConfirmDialog(this.getFrame(), "Overwrite existing grammar?", null, 2);
            return response == 0;
        }
        return true;
    }

    protected final JFileChooser getRuleFileChooser() {
        return GrooveFileChooser.getFileChooser(FileType.RULE_FILTER);
    }

    protected final JFileChooser getStateFileChooser() {
        return GrooveFileChooser.getFileChooser(FileType.HOSTS_FILTER);
    }

    protected final JFileChooser getPrologFileChooser() {
        return GrooveFileChooser.getFileChooser(FileType.PROLOG_FILTER);
    }

    protected final JFileChooser getGrammarFileChooser() {
        return this.getGrammarFileChooser(false);
    }

    protected final JFileChooser getGrammarFileChooser(boolean includeArchives) {
        if (includeArchives) {
            return GrooveFileChooser.getFileChooser(FileType.GRAMMARS_FILTER);
        }
        return GrooveFileChooser.getFileChooser(FileType.GRAMMAR_FILTER);
    }

    protected final File getLastGrammarFile() {
        Object location;
        File result = null;
        SystemStore store = this.getSimulatorModel().getStore();
        Object object = location = store == null ? null : store.getLocation();
        if (location instanceof File) {
            result = (File)location;
        } else if (location instanceof URL) {
            result = Groove.toFile((URL)location);
        }
        return result;
    }

    protected final String getNameInGrammar(File selectedFile) throws IOException {
        String grammarPath;
        ExtensionFilter filter = this.getResourceKind().getFilter();
        String selectedPath = filter.stripExtension(selectedFile.getCanonicalPath());
        String name = null;
        Object location = this.getSimulatorModel().getStore().getLocation();
        if (location instanceof File && selectedPath.startsWith(grammarPath = ((File)location).getCanonicalPath())) {
            String diff = selectedPath.substring(grammarPath.length());
            File pathDiff = new File(diff);
            LinkedList<String> pathFragments = new LinkedList<String>();
            while (pathDiff.getName().length() > 0) {
                pathFragments.add(0, pathDiff.getName());
                pathDiff = pathDiff.getParentFile();
            }
            try {
                QualName qualName = new QualName(pathFragments);
                qualName.testValid();
                name = qualName.toString();
            }
            catch (FormatException e) {
                throw new IOException(String.format("Malformed %s name: %s", this.getResourceKind().getDescription(), e.getMessage()));
            }
        }
        return name;
    }
}

