/*
 * Decompiled with CFR 0.152.
 */
package groove.gui.action;

import groove.abstraction.neigh.NeighAbstraction;
import groove.abstraction.neigh.gui.dialog.ShapePreviewDialog;
import groove.abstraction.neigh.shape.Shape;
import groove.grammar.host.HostGraph;
import groove.gui.Options;
import groove.gui.Simulator;
import groove.gui.action.SimulatorAction;

public class ToggleExplorationStateAction
extends SimulatorAction {
    public ToggleExplorationStateAction(Simulator simulator) {
        super(simulator, "Enter Abstraction Mode", null);
        this.putValue("AcceleratorKey", Options.TOGGLE_EXP_MODE_KEY);
    }

    @Override
    public void execute() {
        if (this.getSimulatorModel().isAbstractionMode()) {
            this.getSimulatorModel().setAbstractionMode(false);
            this.putValue("Name", "Enter Abstraction Mode");
            NeighAbstraction.terminate();
        } else {
            this.getSimulatorModel().setAbstractionMode(true);
            this.putValue("Name", "Return to Concrete Mode");
            NeighAbstraction.initialise();
            HostGraph graph = this.getSimulator().getModel().getGts().nodeSet().iterator().next().getGraph();
            Shape shape = Shape.createShape(graph);
            System.out.println(shape);
            ShapePreviewDialog.showShape(this.getSimulator(), shape);
        }
    }

    @Override
    public void refresh() {
        boolean enabled = this.getSimulatorModel().getGrammar() != null && this.getSimulatorModel().getGrammar().getErrors().isEmpty();
        this.setEnabled(enabled);
    }
}

